/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.oauth;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.HttpService;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.HttpServiceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.apache5.ApacheHttpServiceFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.oauth.OAuthClient;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.oauth.OAuthException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.oauth.OAuthToken;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.oauth.PingOneOAuthEvents;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.LogEvent;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class PingOneOAuthClient
implements OAuthClient {
    private static final IntegrationsLogger LOG = new IntegrationsLogger(PingOneOAuthClient.class);
    public static final String DEFAULT_AUTH_BASE_URL = "https://auth.pingone.com";
    public static final String TOKEN_ENDPOINT = "/%s/as/token";
    private static final String GRANT_BODY = "grant_type=client_credentials";
    private static final String GRANT_BODY_ENCODING = "application/x-www-form-urlencoded";
    private static final String ACCEPT_KEY = "Accept";
    private static final String ACCEPT_VALUE = "application/json; charset=UTF-8";
    private static final String AUTHORIZATION_HEADER_KEY = "Authorization";
    private static final String AUTHORIZATION_BASIC_HEADER_PREFIX = "Basic ";
    private HttpService httpService;
    private ObjectMapper mapper;

    public PingOneOAuthClient() {
        this(new ApacheHttpServiceFactory().make(), new ObjectMapper());
    }

    public PingOneOAuthClient(HttpService client, ObjectMapper mapper) {
        this.httpService = client;
        this.mapper = mapper;
    }

    @Override
    public String getAccessToken(String clientId, String clientSecret, String environmentId, String oauthUrl) throws OAuthException {
        if (environmentId == null || environmentId.isEmpty()) {
            LOG.log(PingOneOAuthEvents.OAUTH_MISSING_ENVIRONMENT_ID);
            throw new OAuthException(PingOneOAuthEvents.OAUTH_MISSING_ENVIRONMENT_ID.getMessage());
        }
        String authUrl = (oauthUrl != null && !oauthUrl.trim().isEmpty() ? oauthUrl : DEFAULT_AUTH_BASE_URL) + TOKEN_ENDPOINT;
        return this.getAccessToken(clientId, clientSecret, String.format(authUrl, environmentId));
    }

    @Override
    public String getAccessToken(String clientId, String clientSecret, String oauthUrl) throws OAuthException {
        if (clientId == null || clientId.isEmpty()) {
            LOG.log(PingOneOAuthEvents.OAUTH_MISSING_CLIENT_ID);
            throw new OAuthException(PingOneOAuthEvents.OAUTH_MISSING_CLIENT_ID.getMessage());
        }
        if (clientSecret == null || clientSecret.isEmpty()) {
            LOG.log(PingOneOAuthEvents.OAUTH_MISSING_CLIENT_SECRET);
            throw new OAuthException(PingOneOAuthEvents.OAUTH_MISSING_CLIENT_SECRET.getMessage());
        }
        if (oauthUrl == null || oauthUrl.isEmpty()) {
            LOG.log(PingOneOAuthEvents.OAUTH_MISSING_OAUTH_URL);
            throw new OAuthException(PingOneOAuthEvents.OAUTH_MISSING_OAUTH_URL.getMessage());
        }
        GenericHttpBody body = new GenericHttpBody(GRANT_BODY, GRANT_BODY_ENCODING, StandardCharsets.ISO_8859_1.toString());
        GenericHttpHeaders headers = new GenericHttpHeaders();
        headers.addHeader(AUTHORIZATION_HEADER_KEY, this.buildBasicAuthorizationHeaderValue(clientId, clientSecret));
        headers.addHeader(ACCEPT_KEY, ACCEPT_VALUE);
        GenericHttpRequest httpRequest = new GenericHttpRequest(GenericHttpMethod.POST, oauthUrl, headers, body);
        GenericHttpResponse response = null;
        try {
            response = this.httpService.execute(httpRequest);
        }
        catch (HttpServiceException e) {
            LOG.log((LogEvent)PingOneOAuthEvents.OAUTH_AT_RETRIEVAL_ERROR, e);
            throw new OAuthException(PingOneOAuthEvents.OAUTH_AT_RETRIEVAL_ERROR.getMessage(), e);
        }
        Integer statusCode = response.getStatusCode() != null ? response.getStatusCode() : -1;
        if (statusCode != 200) {
            throw new OAuthException(PingOneOAuthEvents.OAUTH_AT_HTTP_ERROR.getMessage());
        }
        GenericHttpBody respBody = response.getBody();
        if (respBody == null || respBody.getContent() == null) {
            throw new OAuthException(PingOneOAuthEvents.OAUTH_AT_EMPTY_BODY_ERROR.getMessage());
        }
        try {
            return this.mapper.readValue(respBody.getContent(), OAuthToken.class).getAccessToken();
        }
        catch (JsonProcessingException e) {
            throw new OAuthException(PingOneOAuthEvents.OAUTH_AT_PARSING_ERROR.getMessage());
        }
    }

    private String buildBasicAuthorizationHeaderValue(String clientId, String clientSecret) {
        String userNamePassword = String.format("%s:%s", clientId, clientSecret);
        String encoded = Base64.getEncoder().encodeToString(userNamePassword.getBytes());
        return String.format("%s%s", AUTHORIZATION_BASIC_HEADER_PREFIX, encoded);
    }
}

