/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttributeProperty;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.Translator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.AttributeType;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.SchemaAttributeDto;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class SchemaAttributeDtoTranslator
implements Translator<SchemaAttributeDto, SchemaAttribute> {
    @Override
    public SchemaAttribute translate(SchemaAttributeDto dto) throws ResourceException {
        if (dto == null) {
            throw new ResourceException("A `null` SchemaAttributeDto could not be translated");
        }
        String envId = dto.getEnvironment() != null ? dto.getEnvironment().getId() : null;
        String schemaId = dto.getSchema() != null ? dto.getSchema().getId() : null;
        SchemaAttribute schema = new SchemaAttribute(dto.getId());
        schema.add(SchemaAttributeProperty.NAME, dto.getName());
        schema.add(SchemaAttributeProperty.DISPLAY_NAME, StringUtils.isNotBlank(dto.getDisplayName()) ? dto.getDisplayName().trim() : dto.getName());
        schema.add(SchemaAttributeProperty.DESCRIPTION, dto.getDescription());
        schema.add(SchemaAttributeProperty.SCHEMA_TYPE, dto.getSchemaType());
        schema.add(SchemaAttributeProperty.TYPE, dto.getType());
        schema.add(SchemaAttributeProperty.UNIQUE, String.valueOf(dto.isUnique()));
        schema.add(SchemaAttributeProperty.ENABLED, String.valueOf(dto.isEnabled()));
        schema.add(SchemaAttributeProperty.MULTIVALUED, String.valueOf(dto.isMultivalued()));
        schema.add(SchemaAttributeProperty.REQUIRED, String.valueOf(dto.isRequired()));
        schema.add(SchemaAttributeProperty.ENV_ID, envId);
        schema.add(SchemaAttributeProperty.SCHEMA_ID, schemaId);
        if (AttributeType.COMPLEX.name().equalsIgnoreCase(dto.getType()) && dto.getSubAttributes() != null) {
            schema.put(SchemaAttributeProperty.SUB_ATTRIBUTES, dto.getSubAttributes().stream().map(SchemaAttributeDto::getName).collect(Collectors.toList()));
        } else {
            schema.put(SchemaAttributeProperty.SUB_ATTRIBUTES, new ArrayList<String>());
        }
        return schema;
    }
}

