/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.type.TypeReference;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResponseParser;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.SchemaAttributeDtoTranslator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.Translator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.ListResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.SchemaAttributeDto;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.SchemaAttributeList;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.exception.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SchemaAttributeResponseParser
implements ResponseParser<SchemaAttribute> {
    protected static final TypeReference<ListResponse<SchemaAttributeList>> ATTRIBUTE_LIST_TYPE_REF = new TypeReference<ListResponse<SchemaAttributeList>>(){};
    private ObjectMapper mapper;
    private Translator<SchemaAttributeDto, SchemaAttribute> translator;

    public SchemaAttributeResponseParser() {
        this.mapper = new ObjectMapper();
        this.translator = new SchemaAttributeDtoTranslator();
    }

    public SchemaAttributeResponseParser(ObjectMapper mapper, Translator<SchemaAttributeDto, SchemaAttribute> translator) {
        this.mapper = mapper;
        this.translator = translator;
    }

    @Override
    public SchemaAttribute parseCreateResponse(GenericHttpResponse resp) throws CrudException {
        return (SchemaAttribute)ResponseParser.super.parseCreateResponse(resp);
    }

    @Override
    public SchemaAttribute parseReadResponse(GenericHttpResponse resp) throws CrudException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode == 404) {
            throw new ResourceNotFoundException(String.format("Schema Attribute could not be found. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        if (statusCode != null && statusCode != 200) {
            throw new ResourceException(String.format("The read Schema Attribute response indicated an error. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        SchemaAttributeDto resource = null;
        try {
            resource = this.mapper.readValue(body, SchemaAttributeDto.class);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize the read Schema Attribute response.", e);
        }
        return this.translator.translate(resource);
    }

    @Override
    public SchemaAttribute parseUpdateResponse(GenericHttpResponse resp) throws CrudException {
        return (SchemaAttribute)ResponseParser.super.parseUpdateResponse(resp);
    }

    @Override
    public Optional<SchemaAttribute> parsePartialUpdateResponse(GenericHttpResponse resp) throws CrudException {
        return ResponseParser.super.parsePartialUpdateResponse(resp);
    }

    @Override
    public void parseDeleteResponse(GenericHttpResponse resp) throws CrudException {
        ResponseParser.super.parseDeleteResponse(resp);
    }

    @Override
    public List<SchemaAttribute> parseSearchResponse(GenericHttpResponse resp) throws CrudException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode != 200) {
            throw new ResourceException(String.format("The read all Schema Attributes response indicated an error. Status code was \"%d\". Response was: \"%s\"", statusCode, body));
        }
        ListResponse<SchemaAttributeList> response = null;
        try {
            response = this.mapper.readValue(body, ATTRIBUTE_LIST_TYPE_REF);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize the read all Schema Attributes response.", e);
        }
        ArrayList<SchemaAttribute> attributes = new ArrayList<SchemaAttribute>();
        SchemaAttributeList embedded = response.getEmbedded();
        ArrayList attributeList = embedded != null ? embedded.getAttributes() : new ArrayList();
        for (SchemaAttributeDto attributeDto : attributeList) {
            attributes.add(this.translator.translate(attributeDto));
        }
        return attributes;
    }
}

