/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.client.requests;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.client.ScimServiceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.ScimResource;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.exceptions.ScimException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.messages.ErrorResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.utils.StaticUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class RequestBuilder<T extends RequestBuilder> {
    private WebTarget target;
    protected final MultivaluedMap<String, Object> headers = new MultivaluedHashMap();
    protected final MultivaluedMap<String, Object> queryParams = new MultivaluedHashMap();
    private String contentType = "application/scim+json";
    private List<String> accept = new ArrayList<String>();

    RequestBuilder(WebTarget target) {
        this.target = target;
        this.accept("application/scim+json", "application/json");
    }

    public T header(String name, Object ... value) {
        this.headers.addAll((Object)name, value);
        return (T)this;
    }

    public T contentType(String contentType) {
        this.contentType = contentType;
        return (T)this;
    }

    public T accept(String ... acceptStrings) {
        this.accept.clear();
        if (acceptStrings == null || acceptStrings.length == 0) {
            throw new IllegalArgumentException("Accepted media types must not be null or empty");
        }
        for (String acceptString : acceptStrings) {
            this.accept.add(acceptString);
        }
        return (T)this;
    }

    public T queryParam(String name, Object ... value) {
        this.queryParams.addAll((Object)name, value);
        return (T)this;
    }

    static String getResourceVersion(ScimResource resource) throws IllegalArgumentException {
        if (resource == null || resource.getMeta() == null || resource.getMeta().getVersion() == null) {
            throw new IllegalArgumentException("Resource version must be specified by meta.version");
        }
        return resource.getMeta().getVersion();
    }

    static ScimException toScimException(Response response) {
        try {
            ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
            ScimException exception = errorResponse == null ? ScimException.createException(response.getStatus(), null) : ScimException.createException(errorResponse, null);
            response.close();
            return exception;
        }
        catch (ProcessingException ex) {
            return new ScimServiceException(response.getStatus(), ex.getMessage(), ex);
        }
    }

    protected WebTarget target() {
        return this.target;
    }

    WebTarget buildTarget() {
        for (Map.Entry queryParam : this.queryParams.entrySet()) {
            this.target = this.target.queryParam((String)queryParam.getKey(), ((List)queryParam.getValue()).toArray());
        }
        return this.target;
    }

    protected String getContentType() {
        return this.contentType;
    }

    protected List<String> getAccept() {
        return this.accept;
    }

    Invocation.Builder buildRequest() {
        Invocation.Builder builder = this.buildTarget().request(this.accept.toArray(new String[this.accept.size()]));
        for (Map.Entry header : this.headers.entrySet()) {
            builder = builder.header((String)header.getKey(), (Object)StaticUtils.listToString((List)header.getValue(), ", "));
        }
        return builder;
    }
}

