/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.client.requests;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.client.requests.ResourceReturningRequestBuilder;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.ScimResource;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.exceptions.ScimException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public abstract class RetrieveRequestBuilder<T extends RetrieveRequestBuilder<T>>
extends ResourceReturningRequestBuilder<T> {
    protected String version;

    private RetrieveRequestBuilder(WebTarget target) {
        super(target);
    }

    @Override
    Invocation.Builder buildRequest() {
        Invocation.Builder request = super.buildRequest();
        if (this.version != null) {
            request.header("If-None-Match", (Object)this.version);
        }
        return request;
    }

    public static final class Typed
    extends RetrieveRequestBuilder<Typed> {
        public Typed(WebTarget target) {
            super(target);
        }

        public Typed ifNoneMatch(String version) {
            this.version = version;
            return this;
        }

        public <T> T invoke(Class<T> cls) throws ScimException {
            try (Response response = this.buildRequest().get();){
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    Object object = response.readEntity(cls);
                    return (T)object;
                }
                throw Typed.toScimException(response);
            }
        }
    }

    public static final class Generic<T extends ScimResource>
    extends RetrieveRequestBuilder<Generic<T>> {
        private final T resource;

        public Generic(WebTarget target, T resource) {
            super(target);
            this.resource = resource;
        }

        public Generic<T> ifNoneMatch() {
            this.version = Generic.getResourceVersion(this.resource);
            return this;
        }

        public T invoke() throws ScimException {
            return (T)((ScimResource)this.invoke(this.resource.getClass()));
        }

        public <C> C invoke(Class<C> cls) throws ScimException {
            try (Response response = this.buildRequest().get();){
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    Object object = response.readEntity(cls);
                    return (C)object;
                }
                throw Generic.toScimException(response);
            }
        }
    }
}

