/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http2.impl.nio;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.annotation.Internal;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.ConnectionClosedException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.EndpointDetails;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.HttpException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.ProtocolVersion;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.URIScheme;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.impl.nio.BufferedData;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandler;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexer;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.nio.command.CommandSupport;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http2.HttpVersionPolicy;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http2.impl.nio.ServerH2IOEventHandler;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexer;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.io.CloseMode;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.reactor.IOSession;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.reactor.ProtocolIOSession;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.reactor.ssl.TlsDetails;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.util.Args;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSession;

@Internal
public class ServerHttpProtocolNegotiator
implements HttpConnectionEventHandler {
    static final byte[] PREFACE = ClientHttpProtocolNegotiator.PREFACE;
    private final ProtocolIOSession ioSession;
    private final ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ServerH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final BufferedData inBuf;
    private final AtomicReference<HttpConnectionEventHandler> protocolHandlerRef;
    private volatile boolean expectValidH2Preface;

    public ServerHttpProtocolNegotiator(ProtocolIOSession ioSession, ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory, ServerH2StreamMultiplexerFactory http2StreamHandlerFactory, HttpVersionPolicy versionPolicy) {
        this.ioSession = Args.notNull(ioSession, "I/O session");
        this.http1StreamHandlerFactory = Args.notNull(http1StreamHandlerFactory, "HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.inBuf = BufferedData.allocate(1024);
        this.protocolHandlerRef = new AtomicReference<Object>(null);
    }

    @Override
    public void connected(IOSession session) {
        try {
            TlsDetails tlsDetails = this.ioSession.getTlsDetails();
            switch (this.versionPolicy) {
                case NEGOTIATE: {
                    if (tlsDetails == null || !ApplicationProtocol.HTTP_2.id.equals(tlsDetails.getApplicationProtocol())) break;
                    this.expectValidH2Preface = true;
                    break;
                }
                case FORCE_HTTP_2: {
                    if (tlsDetails != null && ApplicationProtocol.HTTP_1_1.id.equals(tlsDetails.getApplicationProtocol())) break;
                    this.expectValidH2Preface = true;
                    break;
                }
                case FORCE_HTTP_1: {
                    ServerHttp1StreamDuplexer http1StreamHandler = this.http1StreamHandlerFactory.create(tlsDetails != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id, this.ioSession);
                    ServerHttp1IOEventHandler protocolHandler = new ServerHttp1IOEventHandler(http1StreamHandler);
                    this.ioSession.upgrade(protocolHandler);
                    this.protocolHandlerRef.set(protocolHandler);
                    http1StreamHandler.onConnect();
                }
            }
        }
        catch (Exception ex) {
            this.exception(session, ex);
        }
    }

    @Override
    public void inputReady(IOSession session, ByteBuffer src) {
        try {
            ByteBuffer data;
            int bytesRead;
            if (src != null) {
                this.inBuf.put(src);
            }
            boolean endOfStream = false;
            if (this.inBuf.length() < PREFACE.length && (bytesRead = this.inBuf.readFrom(session)) == -1) {
                endOfStream = true;
            }
            if ((data = this.inBuf.data()).remaining() >= PREFACE.length) {
                boolean validH2Preface = true;
                for (int i = 0; i < PREFACE.length; ++i) {
                    if (data.get() == PREFACE[i]) continue;
                    if (this.expectValidH2Preface) {
                        throw new HttpException("Unexpected HTTP/2 preface");
                    }
                    validH2Preface = false;
                }
                if (validH2Preface) {
                    ServerH2StreamMultiplexer http2StreamHandler = this.http2StreamHandlerFactory.create(this.ioSession);
                    ServerH2IOEventHandler protocolHandler = new ServerH2IOEventHandler(http2StreamHandler);
                    this.ioSession.upgrade(protocolHandler);
                    this.protocolHandlerRef.set(protocolHandler);
                    http2StreamHandler.onConnect();
                    http2StreamHandler.onInput(data.hasRemaining() ? data : null);
                } else {
                    TlsDetails tlsDetails = this.ioSession.getTlsDetails();
                    ServerHttp1StreamDuplexer http1StreamHandler = this.http1StreamHandlerFactory.create(tlsDetails != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id, this.ioSession);
                    ServerHttp1IOEventHandler protocolHandler = new ServerHttp1IOEventHandler(http1StreamHandler);
                    this.ioSession.upgrade(protocolHandler);
                    this.protocolHandlerRef.set(protocolHandler);
                    data.rewind();
                    http1StreamHandler.onConnect();
                    http1StreamHandler.onInput(data);
                }
            } else if (endOfStream) {
                throw new ConnectionClosedException();
            }
            data.clear();
        }
        catch (Exception ex) {
            this.exception(session, ex);
        }
    }

    @Override
    public void outputReady(IOSession session) {
    }

    @Override
    public void timeout(IOSession session, Timeout timeout) {
        this.exception(session, SocketTimeoutExceptionFactory.create(timeout));
    }

    @Override
    public void exception(IOSession session, Exception cause) {
        session.close(CloseMode.IMMEDIATE);
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.get();
        if (protocolHandler != null) {
            protocolHandler.exception(session, cause);
        } else {
            CommandSupport.failCommands(session, cause);
        }
    }

    @Override
    public void disconnected(IOSession session) {
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.getAndSet(null);
        if (protocolHandler != null) {
            protocolHandler.disconnected(this.ioSession);
        } else {
            CommandSupport.cancelCommands(session);
        }
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.get();
        return protocolHandler != null ? protocolHandler.getEndpointDetails() : null;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        HttpConnectionEventHandler protocolHandler = this.protocolHandlerRef.get();
        return protocolHandler != null ? protocolHandler.getProtocolVersion() : null;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return this.ioSession.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.ioSession.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }

    public String toString() {
        return "[versionPolicy=" + (Object)((Object)this.versionPolicy) + ", expectValidH2Preface=" + this.expectValidH2Preface + ']';
    }
}

