/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http2.ssl;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.HttpHost;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.nio.ssl.FixedPortStrategy;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.nio.ssl.SecurePortStrategy;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http2.ssl.H2TlsSupport;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.ssl.SSLContexts;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.util.Args;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.util.Timeout;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;

public class H2ServerTlsStrategy
implements TlsStrategy {
    private final SSLContext sslContext;
    private final SecurePortStrategy securePortStrategy;
    private final SSLBufferMode sslBufferMode;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    public H2ServerTlsStrategy(SSLContext sslContext, SecurePortStrategy securePortStrategy, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.securePortStrategy = securePortStrategy;
        this.sslBufferMode = sslBufferMode;
        this.initializer = initializer;
        this.verifier = verifier;
    }

    public H2ServerTlsStrategy(SSLContext sslContext, SecurePortStrategy securePortStrategy, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this(sslContext, securePortStrategy, null, initializer, verifier);
    }

    public H2ServerTlsStrategy(SSLContext sslContext, SecurePortStrategy securePortStrategy, SSLSessionVerifier verifier) {
        this(sslContext, securePortStrategy, null, null, verifier);
    }

    public H2ServerTlsStrategy(SSLContext sslContext, SecurePortStrategy securePortStrategy) {
        this(sslContext, securePortStrategy, null, null, null);
    }

    public H2ServerTlsStrategy(int ... securePorts) {
        this(SSLContexts.createSystemDefault(), new FixedPortStrategy(securePorts));
    }

    @Override
    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment, Timeout handshakeTimeout) {
        if (this.securePortStrategy != null && this.securePortStrategy.isSecure(localAddress)) {
            tlsSession.startTls(this.sslContext, host, this.sslBufferMode, H2TlsSupport.enforceRequirements(attachment, this.initializer), this.verifier, handshakeTimeout);
            return true;
        }
        return false;
    }
}

