/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Schema(description="A device profile.")
public class DeviceProfile
extends com.pingidentity.sdk.api.authn.model.DeviceProfile {
    public static final String USER_AGENT = "userAgent";
    public static final String LANGUAGE = "language";
    public static final String COLOR_DEPTH = "colorDepth";
    public static final String DEVICE_MEMORY = "deviceMemory";
    public static final String HARDWARE_CONCURRENCY = "hardwareConcurrency";
    public static final String SCREEN_RESOLUTION = "screenResolution";
    public static final String AVAILABLE_SCREEN_RESOLUTION = "availableScreenResolution";
    public static final String TIMEZONE_OFFSET = "timezoneOffset";
    public static final String TIMEZONE = "timezone";
    public static final String SESSION_STORAGE = "sessionStorage";
    public static final String LOCAL_STORAGE = "localStorage";
    public static final String INDEXED_DB = "indexedDb";
    public static final String ADD_BEHAVIOUR = "addBehaviour";
    public static final String OPEN_DATABASE = "openDatabase";
    public static final String CPU_CLASS = "cpuClass";
    public static final String PLATFORM = "platform";
    public static final String PLUGINS = "plugins";
    public static final String WEBGL = "webgl";
    public static final String WEBGL_VENDOR_AND_RENDERER = "webglVendorAndRenderer";
    public static final String AD_BLOCK = "adBlock";
    public static final String HAS_LIED_LANGUAGES = "hasLiedLanguages";
    public static final String HAS_LIED_RESOLUTION = "hasLiedResolution";
    public static final String HAS_LIED_OS = "hasLiedOs";
    public static final String HAS_LIED_BROWSER = "hasLiedBrowser";
    public static final String TOUCH_SUPPORT = "touchSupport";
    public static final String AUDIO = "audio";
    private List<Map<String, Object>> components = new ArrayList<Map<String, Object>>();
    private Map<String, Object> flattenedComponents = new HashMap<String, Object>();
    private String userAgent;
    private String language;
    private Integer colorDepth;
    private Integer deviceMemory;
    private Integer hardwareConcurrency;
    private List<Integer> screenResolution;
    private List<Integer> availableScreenResolution;
    private Integer timezoneOffset;
    private String timezone;
    private Boolean sessionStorage;
    private Boolean localStorage;
    private Boolean indexedDb;
    private Boolean addBehaviour;
    private Boolean openDatabase;
    private String cpuClass;
    private String platform;
    private Object plugins;
    private String webglVendorAndRenderer;
    private List<String> webgl;
    private Boolean adBlock;
    private Boolean hasLiedLanguages;
    private Boolean hasLiedResolution;
    private Boolean hasLiedOs;
    private Boolean hasLiedBrowser;
    private List<String> touchSupport;
    private String audio;

    @Schema(hidden=true)
    public List<Map<String, Object>> getComponents() {
        return this.components;
    }

    public void setComponents(List<Map<String, Object>> components) {
        this.components = components;
        this.flattenedComponents = components.stream().map(stringObjectMap -> {
            String key = (String)stringObjectMap.get("key");
            Object value = stringObjectMap.get("value");
            if (value == null) {
                value = "not available";
            }
            return new AbstractMap.SimpleImmutableEntry(key, value);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Object getProperty(String key, Class<?> type) {
        Object property = this.flattenedComponents.get(key);
        if (property != null) {
            if (property instanceof String && ("not available".equals(property) || "excluded".equals(property))) {
                return null;
            }
            if (type.isInstance(property)) {
                return type.cast(property);
            }
        }
        return null;
    }

    private List<?> getListType(List<?> list, Class<?> type) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list.stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    @Schema(description="The device's user agent.")
    public String getUserAgent() {
        return this.userAgent != null ? this.userAgent : (String)this.getProperty(USER_AGENT, String.class);
    }

    @Schema(description="The device's language.")
    public String getLanguage() {
        return this.language != null ? this.language : (String)this.getProperty(LANGUAGE, String.class);
    }

    @Schema(description="The device's color depth.")
    public Integer getColorDepth() {
        return this.colorDepth != null ? this.colorDepth : (Integer)this.getProperty(COLOR_DEPTH, Integer.class);
    }

    @Schema(description="The device's memory.")
    public Integer getDeviceMemory() {
        return this.deviceMemory != null ? this.deviceMemory : (Integer)this.getProperty(DEVICE_MEMORY, Integer.class);
    }

    @Schema(description="The device's hardware concurrency.")
    public Integer getHardwareConcurrency() {
        return this.hardwareConcurrency != null ? this.hardwareConcurrency : (Integer)this.getProperty(HARDWARE_CONCURRENCY, Integer.class);
    }

    @Schema(description="The device's screen resolution.")
    public List<Integer> getScreenResolution() {
        return this.screenResolution != null ? this.screenResolution : this.getListType((List)this.getProperty(SCREEN_RESOLUTION, List.class), Integer.class);
    }

    @Schema(description="The device's available resolution.")
    public List<Integer> getAvailableScreenResolution() {
        return this.availableScreenResolution != null ? this.availableScreenResolution : this.getListType((List)this.getProperty(AVAILABLE_SCREEN_RESOLUTION, List.class), Integer.class);
    }

    @Schema(description="The device's timezone offset.")
    public Integer getTimezoneOffset() {
        return this.timezoneOffset != null ? this.timezoneOffset : (Integer)this.getProperty(TIMEZONE_OFFSET, Integer.class);
    }

    @Schema(description="The device's time zone.")
    public String getTimezone() {
        return this.timezone != null ? this.timezone : (String)this.getProperty(TIMEZONE, String.class);
    }

    @Schema(description="Set to true when the session storage API is available on the device.")
    public Boolean getSessionStorage() {
        return this.sessionStorage != null ? this.sessionStorage : (Boolean)this.getProperty(SESSION_STORAGE, Boolean.class);
    }

    @Schema(description="Set to true when the local storage API is available on the device.")
    public Boolean getLocalStorage() {
        return this.localStorage != null ? this.localStorage : (Boolean)this.getProperty(LOCAL_STORAGE, Boolean.class);
    }

    @Schema(description="Set to true when the indexed DB API is available on the device.")
    public Boolean getIndexedDb() {
        return this.indexedDb != null ? this.indexedDb : (Boolean)this.getProperty(INDEXED_DB, Boolean.class);
    }

    @Schema(description="Set to true when the addBehaviour method is available on the device.")
    public Boolean getAddBehaviour() {
        return this.addBehaviour != null ? this.addBehaviour : (Boolean)this.getProperty(ADD_BEHAVIOUR, Boolean.class);
    }

    @Schema(description="Set to true when the openDatabase method is available on the device.")
    public Boolean getOpenDatabase() {
        return this.openDatabase != null ? this.openDatabase : (Boolean)this.getProperty(OPEN_DATABASE, Boolean.class);
    }

    @Schema(description="The device's CPU class.")
    public String getCpuClass() {
        return this.cpuClass != null ? this.cpuClass : (String)this.getProperty(CPU_CLASS, String.class);
    }

    @Schema(description="The device's platform.")
    public String getPlatform() {
        return this.platform != null ? this.platform : (String)this.getProperty(PLATFORM, String.class);
    }

    @Schema(description="The device's plugins.")
    public Object getPlugins() {
        return this.plugins != null ? this.plugins : this.getProperty(PLUGINS, Object.class);
    }

    @Schema(description="The device's webGL vendor and renderer.")
    public String getWebglVendorAndRenderer() {
        return this.webglVendorAndRenderer != null ? this.webglVendorAndRenderer : (String)this.getProperty(WEBGL_VENDOR_AND_RENDERER, String.class);
    }

    @Schema(description="The device's webGL attributes.")
    public List<String> getWebgl() {
        return this.webgl != null ? this.webgl : this.getListType((List)this.getProperty(WEBGL, List.class), String.class);
    }

    @Schema(description="Set to true when ad blocking is detected on the device.")
    public Boolean getAdBlock() {
        return this.adBlock != null ? this.adBlock : (Boolean)this.getProperty(AD_BLOCK, Boolean.class);
    }

    @Schema(description="Set to true when language evasion is detected on the device.")
    public Boolean getHasLiedLanguages() {
        return this.hasLiedLanguages != null ? this.hasLiedLanguages : (Boolean)this.getProperty(HAS_LIED_LANGUAGES, Boolean.class);
    }

    @Schema(description="Set to true when resolution evasion is detected on the device.")
    public Boolean getHasLiedResolution() {
        return this.hasLiedResolution != null ? this.hasLiedResolution : (Boolean)this.getProperty(HAS_LIED_RESOLUTION, Boolean.class);
    }

    @Schema(description="set to true when OS evasion is detected on the device.")
    public Boolean getHasLiedOs() {
        return this.hasLiedOs != null ? this.hasLiedOs : (Boolean)this.getProperty(HAS_LIED_OS, Boolean.class);
    }

    @Schema(description="Set to true when browser evasion is detected on the device.")
    public Boolean getHasLiedBrowser() {
        return this.hasLiedBrowser != null ? this.hasLiedBrowser : (Boolean)this.getProperty(HAS_LIED_BROWSER, Boolean.class);
    }

    @Schema(description="The device's touch support capabilities.")
    public List<String> getTouchSupport() {
        if (this.touchSupport != null) {
            return this.touchSupport;
        }
        List touchSupport = (List)this.getProperty(TOUCH_SUPPORT, List.class);
        if (touchSupport != null) {
            return touchSupport.stream().map(Object::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Schema(description="The device's audio component.")
    public String getAudio() {
        return this.audio != null ? this.audio : (String)this.getProperty(AUDIO, String.class);
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setColorDepth(Integer colorDepth) {
        this.colorDepth = colorDepth;
    }

    public void setDeviceMemory(Integer deviceMemory) {
        this.deviceMemory = deviceMemory;
    }

    public void setHardwareConcurrency(Integer hardwareConcurrency) {
        this.hardwareConcurrency = hardwareConcurrency;
    }

    public void setScreenResolution(List<Integer> screenResolution) {
        this.screenResolution = screenResolution;
    }

    public void setAvailableScreenResolution(List<Integer> availableScreenResolution) {
        this.availableScreenResolution = availableScreenResolution;
    }

    public void setTimezoneOffset(Integer timezoneOffset) {
        this.timezoneOffset = timezoneOffset;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setSessionStorage(Boolean sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    public void setLocalStorage(Boolean localStorage) {
        this.localStorage = localStorage;
    }

    public void setIndexedDb(Boolean indexedDb) {
        this.indexedDb = indexedDb;
    }

    public void setAddBehaviour(Boolean addBehaviour) {
        this.addBehaviour = addBehaviour;
    }

    public void setOpenDatabase(Boolean openDatabase) {
        this.openDatabase = openDatabase;
    }

    public void setCpuClass(String cpuClass) {
        this.cpuClass = cpuClass;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setPlugins(Object plugins) {
        this.plugins = plugins;
    }

    public void setWebglVendorAndRenderer(String webglVendorAndRenderer) {
        this.webglVendorAndRenderer = webglVendorAndRenderer;
    }

    public void setWebgl(List<String> webgl) {
        this.webgl = webgl;
    }

    public void setAdBlock(Boolean adBlock) {
        this.adBlock = adBlock;
    }

    public void setHasLiedLanguages(Boolean hasLiedLanguages) {
        this.hasLiedLanguages = hasLiedLanguages;
    }

    public void setHasLiedResolution(Boolean hasLiedResolution) {
        this.hasLiedResolution = hasLiedResolution;
    }

    public void setHasLiedOs(Boolean hasLiedOs) {
        this.hasLiedOs = hasLiedOs;
    }

    public void setHasLiedBrowser(Boolean hasLiedBrowser) {
        this.hasLiedBrowser = hasLiedBrowser;
    }

    public void setTouchSupport(List<String> touchSupport) {
        this.touchSupport = touchSupport;
    }

    public void setAudio(String audio) {
        this.audio = audio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DeviceProfile that = (DeviceProfile)((Object)o);
        return Objects.equals(this.components, that.components);
    }

    public int hashCode() {
        return Objects.hash(this.components);
    }
}

