/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.pingidentity.adapters.pingone.risk.PingOneRiskManagementAdapterConfiguration;
import com.pingidentity.adapters.pingone.risk.RiskService;
import com.pingidentity.adapters.pingone.risk.api.RiskServiceException;
import com.pingidentity.adapters.pingone.risk.api.TokenServiceException;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.LogEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;

public class RiskPolicyCallbackHelper {
    private static final IntegrationsLogger LOG = new IntegrationsLogger(RiskPolicyCallbackHelper.class);
    private static final String CACHE_KEY_PREFIX = "riskPolicy.";
    private static final Cache<String, List<AbstractSelectionFieldDescriptor.OptionValue>> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public List<AbstractSelectionFieldDescriptor.OptionValue> getRiskPolicyOptionValues(Configuration configuration) {
        String pingOneEnvironment = PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
        String cacheKey = CACHE_KEY_PREFIX + pingOneEnvironment;
        List<Object> optionValues = (List)cache.getIfPresent((Object)cacheKey);
        if (optionValues == null) {
            RiskService riskService = RiskService.configureRiskService(configuration);
            try {
                LOG.log(com.pingidentity.adapters.pingone.risk.LogEvent.GET_RISK_POLICY);
                Map<String, String> riskPolicySetNames = riskService.getRiskPolicyNames();
                optionValues = this.asOptionValues(riskPolicySetNames);
                cache.put((Object)cacheKey, optionValues);
            }
            catch (RiskServiceException | TokenServiceException e) {
                LOG.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.GET_RISK_POLICY_ERROR, e);
                optionValues = Collections.emptyList();
            }
        }
        return optionValues;
    }

    private List<AbstractSelectionFieldDescriptor.OptionValue> asOptionValues(Map<String, String> riskPolicySetNames) {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        optionValues.addAll(riskPolicySetNames.entrySet().stream().map(it -> new AbstractSelectionFieldDescriptor.OptionValue((String)it.getValue(), (String)it.getKey())).collect(Collectors.toList()));
        return optionValues;
    }
}

