/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import com.pingidentity.adapters.pingone.risk.CompletionStatus;
import com.pingidentity.adapters.pingone.risk.HttpClientBuilder;
import com.pingidentity.adapters.pingone.risk.PingOneRiskManagementAdapterConfiguration;
import com.pingidentity.adapters.pingone.risk.ReflectivePingOneEnvironmentAccessor;
import com.pingidentity.adapters.pingone.risk.Region;
import com.pingidentity.adapters.pingone.risk.RiskEvaluation;
import com.pingidentity.adapters.pingone.risk.RiskEvaluationTranslator;
import com.pingidentity.adapters.pingone.risk.RiskEvent;
import com.pingidentity.adapters.pingone.risk.TokenProviderException;
import com.pingidentity.adapters.pingone.risk.TokenService;
import com.pingidentity.adapters.pingone.risk.api.ApiResponseException;
import com.pingidentity.adapters.pingone.risk.api.RiskApiClient;
import com.pingidentity.adapters.pingone.risk.api.RiskServiceException;
import com.pingidentity.adapters.pingone.risk.api.TokenApiClient;
import com.pingidentity.adapters.pingone.risk.api.TokenServiceException;
import com.pingidentity.adapters.pingone.risk.api.model.Event;
import com.pingidentity.adapters.pingone.risk.api.model.RiskEvaluationRequest;
import com.pingidentity.adapters.pingone.risk.api.model.RiskEvaluationResponse;
import com.pingidentity.adapters.pingone.risk.api.model.RiskEventRequest;
import com.pingidentity.adapters.pingone.risk.api.model.RiskPolicySet;
import com.pingidentity.adapters.pingone.risk.api.model.RiskPolicySetsResponse;
import com.pingidentity.adapters.pingone.risk.api.model.RiskPredictor;
import com.pingidentity.adapters.pingone.risk.api.model.RiskPredictorsResponse;
import com.pingidentity.adapters.pingone.risk.api.model.StandardApiErrorResponse;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.fluent.Executor;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.adapter.conf.Configuration;

public class RiskService {
    private static final String RISK_EVALUATION_ERROR = "There was an error during risk evaluation.";
    private static final String RISK_FEEDBACK_ERROR = "There was an error during risk feedback.";
    private static final String RISK_POLICY_SETS_ERROR = "There was an error retrieving risk policies.";
    private static final String RISK_PREDICTORS_ERROR = "There was an error retrieving risk predictors.";
    private final TokenService tokenService;
    private final RiskApiClient riskApiClient;
    private final Map<String, String> apiResponseMappings;
    private final String riskPolicySetId;

    public RiskService(TokenService tokenService, RiskApiClient riskApiClient, Map<String, String> apiResponseMappings, String riskPolicySetId) {
        this.tokenService = tokenService;
        this.riskApiClient = riskApiClient;
        this.apiResponseMappings = apiResponseMappings;
        this.riskPolicySetId = riskPolicySetId;
    }

    public RiskEvaluation evaluateRisk(RiskEvent riskEvent) throws RiskServiceException, TokenServiceException {
        RiskEvaluationRequest riskEvaluationRequest = RiskEvaluationTranslator.translateToRequest(riskEvent);
        if (StringUtils.isNotBlank(this.riskPolicySetId)) {
            riskEvaluationRequest.setRiskPolicySet(new RiskPolicySet(this.riskPolicySetId));
        }
        String token = this.tokenService.getToken();
        try {
            RiskEvaluationResponse riskEvaluationResponse = this.riskApiClient.postRiskEvent(riskEvaluationRequest, token);
            return RiskEvaluationTranslator.translateFromResponse(riskEvaluationResponse, this.apiResponseMappings);
        }
        catch (ApiResponseException e) {
            StandardApiErrorResponse standardApiErrorResponse = (StandardApiErrorResponse)e.getErrorResponse();
            if (standardApiErrorResponse != null) {
                throw new RiskServiceException.Builder().setMessage(RISK_EVALUATION_ERROR).setCause(e).setStatusCode(e.getStatusCode()).setApiErrorId(standardApiErrorResponse.getId()).setApiErrorCode(standardApiErrorResponse.getCode()).setApiErrorMessage(standardApiErrorResponse.getMessage()).build();
            }
            throw new RiskServiceException(RISK_EVALUATION_ERROR, e);
        }
        catch (IOException e) {
            throw new RiskServiceException(RISK_EVALUATION_ERROR, e);
        }
    }

    public void feedbackRisk(String riskEvaluationId, CompletionStatus completionStatus) throws RiskServiceException, TokenServiceException {
        String token = this.tokenService.getToken();
        try {
            RiskEvaluationResponse riskEvaluationResponse = this.riskApiClient.getRiskEvaluation(riskEvaluationId, token);
            Event event = riskEvaluationResponse.getEvent();
            event.setCompletionStatus(completionStatus.name());
            RiskEventRequest riskEventRequest = new RiskEventRequest(event);
            this.riskApiClient.putRiskEvent(riskEventRequest, riskEvaluationId, token);
        }
        catch (ApiResponseException e) {
            this.processApiResponseException(e, RISK_FEEDBACK_ERROR);
        }
        catch (IOException e) {
            throw new RiskServiceException(RISK_FEEDBACK_ERROR, e);
        }
    }

    public Map<String, String> getRiskPolicyNames() throws TokenServiceException, RiskServiceException {
        HashMap<String, String> riskPolicySetNames = new HashMap<String, String>();
        String token = this.tokenService.getToken();
        try {
            RiskPolicySetsResponse riskPolicySetsResponse = this.riskApiClient.getRiskPolicySets(token);
            List<RiskPolicySet> riskPolicySets = riskPolicySetsResponse.getEmbedded().getRiskPolicySets();
            if (riskPolicySets != null) {
                riskPolicySets.forEach(riskPolicySet -> riskPolicySetNames.put(riskPolicySet.getId(), riskPolicySet.getName()));
            }
        }
        catch (ApiResponseException e) {
            this.processApiResponseException(e, RISK_POLICY_SETS_ERROR);
        }
        catch (IOException e) {
            throw new RiskServiceException(RISK_POLICY_SETS_ERROR, e);
        }
        return riskPolicySetNames;
    }

    public Map<String, RiskPredictor> getThirdPartyRiskPredictorNames() throws TokenServiceException, RiskServiceException {
        HashMap<String, RiskPredictor> riskPredictorNames = new HashMap<String, RiskPredictor>();
        String token = this.tokenService.getToken();
        try {
            RiskPredictorsResponse riskPredictorsResponse = this.riskApiClient.getRiskPredictors(token);
            List<RiskPredictor> riskPredictors = riskPredictorsResponse.getEmbedded().getRiskPredictors();
            if (null != riskPredictors) {
                riskPredictors.stream().filter(RiskPredictor::isMapPredictor).forEach(riskPredictor -> riskPredictorNames.put(riskPredictor.getCompactName(), (RiskPredictor)riskPredictor));
            }
        }
        catch (ApiResponseException e) {
            this.processApiResponseException(e, RISK_PREDICTORS_ERROR);
        }
        catch (IOException e) {
            throw new RiskServiceException(RISK_PREDICTORS_ERROR, e);
        }
        return riskPredictorNames;
    }

    private void processApiResponseException(ApiResponseException e, String errorMessage) throws RiskServiceException {
        StandardApiErrorResponse standardApiErrorResponse = (StandardApiErrorResponse)e.getErrorResponse();
        if (standardApiErrorResponse != null) {
            throw new RiskServiceException.Builder().setMessage(errorMessage).setCause(e).setStatusCode(e.getStatusCode()).setApiErrorId(standardApiErrorResponse.getId()).setApiErrorCode(standardApiErrorResponse.getCode()).setApiErrorMessage(standardApiErrorResponse.getMessage()).build();
        }
        throw new RiskServiceException(errorMessage, e);
    }

    public static RiskService configureRiskService(Configuration configuration) {
        String clientSecret;
        String clientId;
        String apiEndpoint;
        String authEndpoint;
        String riskPolicySetId;
        String envId;
        ReflectivePingOneEnvironmentAccessor pingOneEnvironmentAccessor;
        Map<String, String> apiResponseMappings = PingOneRiskManagementAdapterConfiguration.ApiResponseMappingsTable.getApiResponseMappings(configuration);
        String pingOneEnvironment = PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
        if (PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration)) {
            pingOneEnvironment = PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
            pingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(pingOneEnvironment);
            envId = pingOneEnvironmentAccessor.getEnvironmentId();
            riskPolicySetId = PingOneRiskManagementAdapterConfiguration.PingOneRiskPolicyField.getRiskPolicyId(configuration);
            authEndpoint = null;
            apiEndpoint = pingOneEnvironmentAccessor.getManagementEndpoint();
            clientId = null;
            clientSecret = null;
        } else {
            envId = PingOneRiskManagementAdapterConfiguration.EnvIdField.getEnvId(configuration);
            clientId = PingOneRiskManagementAdapterConfiguration.ClientIdField.getClientId(configuration);
            clientSecret = PingOneRiskManagementAdapterConfiguration.ClientSecretField.getClientSecret(configuration);
            riskPolicySetId = PingOneRiskManagementAdapterConfiguration.RiskPolicySetIdField.getRiskPolicySetId(configuration);
            Region region = PingOneRiskManagementAdapterConfiguration.RegionField.getRegion(configuration);
            authEndpoint = region.getAuthEndpoint();
            apiEndpoint = region.getApiEndpoint();
            pingOneEnvironmentAccessor = null;
        }
        int requestTimeout = PingOneRiskManagementAdapterConfiguration.RequestTimeoutField.getRequestTimeout(configuration);
        String proxySettings = PingOneRiskManagementAdapterConfiguration.ProxySettingsField.getProxySettings(configuration);
        String proxyHost = PingOneRiskManagementAdapterConfiguration.ProxyHostField.getProxyHost(configuration);
        int proxyPort = PingOneRiskManagementAdapterConfiguration.ProxyPortField.getProxyPort(configuration);
        CloseableHttpClient httpClient = new HttpClientBuilder().setRequestTimeout(requestTimeout).setProxySettings(proxySettings).setProxyHost(proxyHost).setProxyPort(proxyPort).build();
        Executor executor = Executor.newInstance(httpClient);
        TokenService tokenService = new TokenService(() -> {
            try {
                if (pingOneEnvironmentAccessor != null) {
                    return pingOneEnvironmentAccessor.getAccessToken();
                }
                TokenApiClient tokenApiClient = new TokenApiClient(executor, authEndpoint, envId, clientId, clientSecret);
                return tokenApiClient.requestToken().getAccessToken();
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new TokenProviderException("Error requesting access token", e);
            }
        }, pingOneEnvironmentAccessor != null ? pingOneEnvironment : clientId);
        RiskApiClient riskApiClient = new RiskApiClient(executor, apiEndpoint, envId);
        return new RiskService(tokenService, riskApiClient, apiResponseMappings, riskPolicySetId);
    }
}

