/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk;

import com.pingidentity.adapters.pingone.risk.HttpClientBuilder;
import com.pingidentity.adapters.pingone.risk.PingOneRiskManagementAdapterConfiguration;
import com.pingidentity.adapters.pingone.risk.ReflectivePingOneEnvironmentAccessor;
import com.pingidentity.adapters.pingone.risk.Region;
import com.pingidentity.adapters.pingone.risk.RiskService;
import com.pingidentity.adapters.pingone.risk.TokenProviderException;
import com.pingidentity.adapters.pingone.risk.TokenService;
import com.pingidentity.adapters.pingone.risk.api.ApiResponseException;
import com.pingidentity.adapters.pingone.risk.api.RiskApiClient;
import com.pingidentity.adapters.pingone.risk.api.RiskServiceException;
import com.pingidentity.adapters.pingone.risk.api.TokenApiClient;
import com.pingidentity.adapters.pingone.risk.api.TokenServiceException;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.fluent.Executor;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import java.util.Map;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;

public class TestConnectionAction
implements ActionDescriptor.Action {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(TestConnectionAction.class);
    private static final String CONNECTION_SUCCESSFUL = "Connection was successful. ";
    private static final String USING_RISK_POLICY_SET_NAME = "Risk policy \"%s\" will be used for risk evaluation. ";
    private static final String USING_DEFAULT_RISK_POLICY_SET = "The default risk policy will be used for risk evaluation. ";
    private static final String CONNECTION_UNSUCCESSFUL = "Connection was unsuccessful. ";
    private static final String WARNING_RISK_POLICY_SET_ID_NOT_FOUND = "Warning: risk policy id \"%s\" does not exist in PingOne Risk Management environment \"%s\".";
    private static final String STATUS_LINE_MESSAGE = "PingOne Risk Management returned HTTP status %s %s. ";
    private static final String CHECK_CONFIGURATION_MESSAGE = "Please check the value of the 'PingOne Environment' field";
    private static final String LEGACY_CHECK_CONFIGURATION_MESSAGE = "Please check the values of the 'Environment ID', 'PingFederate Connection Client ID', 'PingFederate Connection Client Secret', and 'Region' fields";
    private static final String CHECK_PROXY_CONFIGURATION_MESSAGE = " as well as proxy configuration, if applicable.";

    public String actionInvoked(Configuration configuration) {
        String result;
        RiskService riskService = TestConnectionAction.configureRiskService(configuration);
        try {
            result = CONNECTION_SUCCESSFUL;
            Map<String, String> riskPolicySetNames = riskService.getRiskPolicyNames();
            String riskPolicySetId = PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration) ? PingOneRiskManagementAdapterConfiguration.PingOneRiskPolicyField.getRiskPolicyId(configuration) : PingOneRiskManagementAdapterConfiguration.RiskPolicySetIdField.getRiskPolicySetId(configuration);
            String riskPolicySetName = riskPolicySetNames.get(riskPolicySetId);
            if (StringUtils.isNotBlank(riskPolicySetId)) {
                if (riskPolicySetName == null) {
                    String envId;
                    if (PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration)) {
                        String pingOneEnvironment = PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
                        ReflectivePingOneEnvironmentAccessor pingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(pingOneEnvironment);
                        envId = pingOneEnvironmentAccessor.getEnvironmentId();
                    } else {
                        envId = PingOneRiskManagementAdapterConfiguration.EnvIdField.getEnvId(configuration);
                    }
                    result = result + String.format(WARNING_RISK_POLICY_SET_ID_NOT_FOUND, riskPolicySetId, envId);
                } else {
                    result = result + String.format(USING_RISK_POLICY_SET_NAME, riskPolicySetName);
                }
            } else {
                result = result + USING_DEFAULT_RISK_POLICY_SET;
            }
        }
        catch (RiskServiceException | TokenServiceException e) {
            LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.risk.LogEvent.TEST_CONNECTION_ACTION_FAILURE, e);
            result = CONNECTION_UNSUCCESSFUL;
            if (e.getCause() instanceof ApiResponseException) {
                ApiResponseException apiResponseException = (ApiResponseException)e.getCause();
                int statusCode = apiResponseException.getStatusCode();
                String reasonPhrase = apiResponseException.getReasonPhrase();
                result = result + String.format(STATUS_LINE_MESSAGE, statusCode, reasonPhrase);
            }
            result = PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration) ? result + CHECK_CONFIGURATION_MESSAGE : result + LEGACY_CHECK_CONFIGURATION_MESSAGE;
            result = e.getCause() instanceof ApiResponseException ? result + "." : result + CHECK_PROXY_CONFIGURATION_MESSAGE;
        }
        return result;
    }

    private static RiskService configureRiskService(Configuration configuration) {
        String apiEndpoint;
        String authEndpoint;
        String riskPolicySetId;
        String envId;
        ReflectivePingOneEnvironmentAccessor pingOneEnvironmentAccessor;
        String pingOneEnvironment;
        Map<String, String> apiResponseMappings = PingOneRiskManagementAdapterConfiguration.ApiResponseMappingsTable.getApiResponseMappings(configuration);
        String clientId = null;
        String clientSecret = null;
        if (PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration)) {
            pingOneEnvironment = PingOneRiskManagementAdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
            pingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(pingOneEnvironment);
            envId = pingOneEnvironmentAccessor.getEnvironmentId();
            riskPolicySetId = PingOneRiskManagementAdapterConfiguration.PingOneRiskPolicyField.getRiskPolicyId(configuration);
            authEndpoint = pingOneEnvironmentAccessor.getAuthenticationEndpoint(false);
            apiEndpoint = pingOneEnvironmentAccessor.getManagementEndpoint();
        } else {
            envId = PingOneRiskManagementAdapterConfiguration.EnvIdField.getEnvId(configuration);
            clientId = PingOneRiskManagementAdapterConfiguration.ClientIdField.getClientId(configuration);
            clientSecret = PingOneRiskManagementAdapterConfiguration.ClientSecretField.getClientSecret(configuration);
            riskPolicySetId = PingOneRiskManagementAdapterConfiguration.RiskPolicySetIdField.getRiskPolicySetId(configuration);
            Region region = PingOneRiskManagementAdapterConfiguration.RegionField.getRegion(configuration);
            authEndpoint = region.getAuthEndpoint();
            apiEndpoint = region.getApiEndpoint();
            pingOneEnvironment = null;
            pingOneEnvironmentAccessor = null;
        }
        int requestTimeout = PingOneRiskManagementAdapterConfiguration.RequestTimeoutField.getRequestTimeout(configuration);
        String proxySettings = PingOneRiskManagementAdapterConfiguration.ProxySettingsField.getProxySettings(configuration);
        String proxyHost = PingOneRiskManagementAdapterConfiguration.ProxyHostField.getProxyHost(configuration);
        int proxyPort = PingOneRiskManagementAdapterConfiguration.ProxyPortField.getProxyPort(configuration);
        CloseableHttpClient httpClient = new HttpClientBuilder().setRequestTimeout(requestTimeout).setProxySettings(proxySettings).setProxyHost(proxyHost).setProxyPort(proxyPort).build();
        Executor executor = Executor.newInstance(httpClient);
        TokenApiClient tokenApiClient = new TokenApiClient(executor, authEndpoint, envId, clientId, clientSecret);
        TokenService tokenService = new TokenService(() -> {
            try {
                if (pingOneEnvironmentAccessor != null) {
                    return pingOneEnvironmentAccessor.getAccessToken();
                }
                return tokenApiClient.requestToken().getAccessToken();
            }
            catch (Throwable e) {
                throw new TokenProviderException("Error requesting access token", e);
            }
        }, pingOneEnvironmentAccessor != null ? pingOneEnvironment : clientId);
        RiskApiClient riskApiClient = new RiskApiClient(executor, apiEndpoint, envId);
        return new RiskService(tokenService, riskApiClient, apiResponseMappings, riskPolicySetId);
    }
}

