/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk.api;

import com.pingidentity.adapters.pingone.risk.shade.org.apache.commons.lang3.StringUtils;
import java.io.IOException;

public class RiskServiceException
extends IOException {
    private static final long serialVersionUID = 1L;
    private static final String API_RESPONSE_MESSAGE = "The API responded with %d [id - %s][%s - %s]";

    public RiskServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    private RiskServiceException(Builder builder) {
        super(builder.toString(), builder.cause);
    }

    public static class Builder {
        private String message;
        private Throwable cause;
        private int statusCode;
        private String apiErrorId;
        private String apiErrorCode;
        private String apiErrorMessage;

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public Builder setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setApiErrorId(String apiErrorId) {
            this.apiErrorId = apiErrorId;
            return this;
        }

        public Builder setApiErrorCode(String apiErrorCode) {
            this.apiErrorCode = apiErrorCode;
            return this;
        }

        public Builder setApiErrorMessage(String apiErrorMessage) {
            this.apiErrorMessage = apiErrorMessage;
            return this;
        }

        public RiskServiceException build() {
            return new RiskServiceException(this);
        }

        public String toString() {
            String message = this.message;
            if (StringUtils.isNotBlank(this.apiErrorId) && StringUtils.isNotBlank(this.apiErrorCode) && StringUtils.isNotBlank(this.apiErrorMessage)) {
                message = message + " " + String.format(RiskServiceException.API_RESPONSE_MESSAGE, this.statusCode, this.apiErrorId, this.apiErrorCode, this.apiErrorMessage);
            }
            return message;
        }
    }
}

