/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk.api;

import com.pingidentity.adapters.pingone.risk.api.ApiResponseException;
import com.pingidentity.adapters.pingone.risk.api.TokenResponseHandler;
import com.pingidentity.adapters.pingone.risk.api.model.TokenResponse;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.commons.codec.binary.Base64;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.fluent.Executor;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.fluent.Form;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.client5.http.fluent.Request;
import com.pingidentity.adapters.pingone.risk.shade.org.apache.hc.core5.http.ContentType;
import java.io.IOException;

public class TokenApiClient {
    private static final String BASIC_AUTH_CREDS_FORMAT = "%s:%s";
    private static final String BASIC_AUTH_HEADER_FORMAT = "Basic %s";
    public static final String TOKEN_ENDPOINT = "/as/token";
    private static final String TOKEN_ENDPOINT_TEMPLATE = "%s/%s/as/token";
    private final Executor executor;
    private final String tokenEndpointUrl;
    private final String basicAuthHeaderValue;

    public TokenApiClient(Executor executor, String authPath, String envId, String clientId, String clientSecret) {
        this.executor = executor;
        this.tokenEndpointUrl = String.format(TOKEN_ENDPOINT_TEMPLATE, authPath, envId);
        String basicAuthCreds = String.format(BASIC_AUTH_CREDS_FORMAT, clientId, clientSecret);
        String encodedBasicAuthCreds = Base64.encodeBase64String(basicAuthCreds.getBytes());
        this.basicAuthHeaderValue = String.format(BASIC_AUTH_HEADER_FORMAT, encodedBasicAuthCreds);
    }

    public TokenResponse requestToken() throws IOException, ApiResponseException {
        Form form = Form.form().add("grant_type", "client_credentials");
        TokenResponseHandler responseHandler = new TokenResponseHandler();
        return this.executor.execute(Request.post(this.tokenEndpointUrl).setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString()).setHeader("Authorization", this.basicAuthHeaderValue).bodyForm(form.build())).handleResponse(responseHandler);
    }
}

