/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk.api.authn;

import com.pingidentity.adapters.pingone.risk.api.authn.ActionSpec;
import com.pingidentity.adapters.pingone.risk.api.authn.CustomDeviceProfileRequired;
import com.pingidentity.adapters.pingone.risk.api.authn.StateSpec;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PingOneRiskManagementAdapterAuthnApiSupport {
    private static final Map<String, AuthnStateSpec<?>> STATE_SPEC_MAP = new LinkedHashMap();
    private final AuthnApiSupport authnApiSupport = AuthnApiSupport.getDefault();

    public static List<AuthnStateSpec<?>> getAuthnStateSpecs() {
        return new ArrayList(STATE_SPEC_MAP.values());
    }

    public boolean isValidP1RiskManagementAdapterAuthnApiPost(HttpServletRequest req, HttpServletResponse resp, String status) throws IOException {
        return this.authnApiSupport.isValidAuthnApiPostRequest(req, resp, this.getExpectedActionIdToModelMapping(status));
    }

    public boolean isSubmitDeviceProfileRequest(HttpServletRequest req) {
        return ActionSpec.SUBMIT_DEVICE_PROFILE.isRequested(req);
    }

    public void writeDeviceProfileRequiredResponse(HttpServletRequest req, HttpServletResponse resp, int deviceProfilingTimeoutInMillis) throws IOException {
        CustomDeviceProfileRequired model = new CustomDeviceProfileRequired(deviceProfilingTimeoutInMillis);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.DEVICE_PROFILE_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    private Map<String, Class<?>> getExpectedActionIdToModelMapping(String status) {
        HashMap actionIdToModelMapping = new HashMap();
        AuthnStateSpec<?> authnStateSpec = STATE_SPEC_MAP.get(status);
        authnStateSpec.getActions().forEach(action -> actionIdToModelMapping.put(action.getId(), action.getModelClass()));
        return actionIdToModelMapping;
    }

    static {
        STATE_SPEC_MAP.put(StateSpec.DEVICE_PROFILE_REQUIRED.getStatus(), StateSpec.DEVICE_PROFILE_REQUIRED);
    }
}

