/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk.configuration;

import com.pingidentity.adapters.pingone.risk.LogEvent;
import com.pingidentity.adapters.pingone.risk.RiskService;
import com.pingidentity.adapters.pingone.risk.api.RiskServiceException;
import com.pingidentity.adapters.pingone.risk.api.TokenServiceException;
import com.pingidentity.adapters.pingone.risk.api.model.RiskPredictor;
import com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;

public class GetRiskPredictorsAction
implements ActionDescriptor.Action {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(GetRiskPredictorsAction.class);
    private static final String CONFIGURED_RISK_PREDICTORS = "The following risk predictors are configured: \n\n%s";
    private static final String UNABLE_TO_GET_RISK_PREDICTORS = "Unable to get risk predictors.";
    private static final String NO_THIRD_PARTY_PREDICTORS_DEFINED = "No risk predictors defined.";

    public String actionInvoked(Configuration configuration) {
        String result;
        RiskService riskService = RiskService.configureRiskService(configuration);
        try {
            result = "";
            Map<String, RiskPredictor> riskPredictors = riskService.getThirdPartyRiskPredictorNames();
            if (riskPredictors.isEmpty()) {
                result = NO_THIRD_PARTY_PREDICTORS_DEFINED;
            } else {
                StringBuilder riskPredictorNames = new StringBuilder();
                AtomicInteger counter = new AtomicInteger(1);
                riskPredictors.forEach((key, value) -> riskPredictorNames.append(counter.getAndIncrement()).append(": ").append(value.toString()).append("\n"));
                result = result + String.format(CONFIGURED_RISK_PREDICTORS, riskPredictorNames);
            }
        }
        catch (RiskServiceException | TokenServiceException e) {
            LOGGER.log((com.pingidentity.adapters.pingone.risk.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.GET_RISK_PREDICTORS_ACTION_FAILURE, e);
            result = UNABLE_TO_GET_RISK_PREDICTORS;
        }
        return result;
    }
}

