/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.consumer;

import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.JwtClaims;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.MalformedClaimException;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.NumericDate;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.consumer.ErrorCodeValidator;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.jwt.consumer.JwtContext;
import com.pingidentity.adapters.pingone.risk.shade.org.jose4j.lang.Maths;

public class NumericDateValidator
implements ErrorCodeValidator {
    private static final ErrorCodeValidator.Error MISSING_EXP = new ErrorCodeValidator.Error(2, "No Expiration Time (exp) claim present.");
    private static final ErrorCodeValidator.Error MISSING_IAT = new ErrorCodeValidator.Error(3, "No Issued At (iat) claim present.");
    private static final ErrorCodeValidator.Error MISSING_NBF = new ErrorCodeValidator.Error(4, "No Not Before (nbf) claim present.");
    private boolean requireExp;
    private boolean requireIat;
    private boolean requireNbf;
    private NumericDate staticEvaluationTime;
    private int allowedClockSkewSeconds = 0;
    private int maxFutureValidityInMinutes = 0;
    private Integer iatAllowedSecondsInTheFuture;
    private Integer iatAllowedSecondsInThePast;

    public void setRequireExp(boolean requireExp) {
        this.requireExp = requireExp;
    }

    public void setRequireIat(boolean requireIat) {
        this.requireIat = requireIat;
    }

    public void setRequireNbf(boolean requireNbf) {
        this.requireNbf = requireNbf;
    }

    public void setEvaluationTime(NumericDate evaluationTime) {
        this.staticEvaluationTime = evaluationTime;
    }

    public void setAllowedClockSkewSeconds(int allowedClockSkewSeconds) {
        this.allowedClockSkewSeconds = allowedClockSkewSeconds;
    }

    public void setMaxFutureValidityInMinutes(int maxFutureValidityInMinutes) {
        this.maxFutureValidityInMinutes = maxFutureValidityInMinutes;
    }

    public void setIatAllowedSecondsInTheFuture(int iatAllowedSecondsInTheFuture) {
        this.iatAllowedSecondsInTheFuture = iatAllowedSecondsInTheFuture;
    }

    public void setIatAllowedSecondsInThePast(int iatAllowedSecondsInThePast) {
        this.iatAllowedSecondsInThePast = iatAllowedSecondsInThePast;
    }

    @Override
    public ErrorCodeValidator.Error validate(JwtContext jwtContext) throws MalformedClaimException {
        NumericDate evaluationTime;
        JwtClaims jwtClaims = jwtContext.getJwtClaims();
        NumericDate expirationTime = jwtClaims.getExpirationTime();
        NumericDate issuedAt = jwtClaims.getIssuedAt();
        NumericDate notBefore = jwtClaims.getNotBefore();
        if (this.requireExp && expirationTime == null) {
            return MISSING_EXP;
        }
        if (this.requireIat && issuedAt == null) {
            return MISSING_IAT;
        }
        if (this.requireNbf && notBefore == null) {
            return MISSING_NBF;
        }
        NumericDate numericDate = evaluationTime = this.staticEvaluationTime == null ? NumericDate.now() : this.staticEvaluationTime;
        if (expirationTime != null) {
            long deltaInSeconds;
            if (Maths.subtract(evaluationTime.getValue(), this.allowedClockSkewSeconds) >= expirationTime.getValue()) {
                String msg = "The JWT is no longer valid - the evaluation time " + evaluationTime + " is on or after the Expiration Time (exp=" + expirationTime + ") claim value" + this.skewMessage();
                return new ErrorCodeValidator.Error(1, msg);
            }
            if (issuedAt != null && expirationTime.isBefore(issuedAt)) {
                return new ErrorCodeValidator.Error(17, "The Expiration Time (exp=" + expirationTime + ") claim value cannot be before the Issued At (iat=" + issuedAt + ") claim value.");
            }
            if (notBefore != null && expirationTime.isBefore(notBefore)) {
                return new ErrorCodeValidator.Error(17, "The Expiration Time (exp=" + expirationTime + ") claim value cannot be before the Not Before (nbf=" + notBefore + ") claim value.");
            }
            if (this.maxFutureValidityInMinutes > 0 && (deltaInSeconds = Maths.subtract(Maths.subtract(expirationTime.getValue(), this.allowedClockSkewSeconds), evaluationTime.getValue())) > (long)this.maxFutureValidityInMinutes * 60L) {
                String msg = "The Expiration Time (exp=" + expirationTime + ") claim value cannot be more than " + this.maxFutureValidityInMinutes + " minutes in the future relative to the evaluation time " + evaluationTime + this.skewMessage();
                return new ErrorCodeValidator.Error(5, msg);
            }
        }
        if (notBefore != null && Maths.add(evaluationTime.getValue(), this.allowedClockSkewSeconds) < notBefore.getValue()) {
            String msg = "The JWT is not yet valid as the evaluation time " + evaluationTime + " is before the Not Before (nbf=" + notBefore + ") claim time" + this.skewMessage();
            return new ErrorCodeValidator.Error(6, msg);
        }
        if (issuedAt != null) {
            if (this.iatAllowedSecondsInTheFuture != null && Maths.subtract(Maths.subtract(issuedAt.getValue(), evaluationTime.getValue()), this.allowedClockSkewSeconds) > (long)this.iatAllowedSecondsInTheFuture.intValue()) {
                String msg = "iat " + issuedAt + " is more than " + this.iatAllowedSecondsInTheFuture + " second(s) ahead of now " + evaluationTime + this.skewMessage();
                return new ErrorCodeValidator.Error(23, msg);
            }
            if (this.iatAllowedSecondsInThePast != null && Maths.subtract(Maths.subtract(evaluationTime.getValue(), issuedAt.getValue()), this.allowedClockSkewSeconds) > (long)this.iatAllowedSecondsInThePast.intValue()) {
                String msg = "As of now " + evaluationTime + " iat " + issuedAt + " is more than " + this.iatAllowedSecondsInThePast + " second(s) in the past" + this.skewMessage();
                return new ErrorCodeValidator.Error(24, msg);
            }
        }
        return null;
    }

    private String skewMessage() {
        if (this.allowedClockSkewSeconds > 0) {
            return " (even when providing " + this.allowedClockSkewSeconds + " seconds of leeway to account for clock skew).";
        }
        return ".";
    }
}

