/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify;

import com.pingidentity.adapters.pingone.verify.CoreContract;
import com.pingidentity.adapters.pingone.verify.CustomLogEvent;
import com.pingidentity.adapters.pingone.verify.LanguagePackMessagesSupport;
import com.pingidentity.adapters.pingone.verify.PollingRequestResponse;
import com.pingidentity.adapters.pingone.verify.ReflectivePingOneEnvironmentAccessor;
import com.pingidentity.adapters.pingone.verify.StateSupport;
import com.pingidentity.adapters.pingone.verify.StateSupportFactory;
import com.pingidentity.adapters.pingone.verify.TemplateSupport;
import com.pingidentity.adapters.pingone.verify.api.ApiClient;
import com.pingidentity.adapters.pingone.verify.api.AuthClient;
import com.pingidentity.adapters.pingone.verify.api.CustomHttpClientFactory;
import com.pingidentity.adapters.pingone.verify.api.TokenService;
import com.pingidentity.adapters.pingone.verify.api.VerifyTransactionRequest;
import com.pingidentity.adapters.pingone.verify.api.model.CustomAuthnErrorDetail;
import com.pingidentity.adapters.pingone.verify.api.model.TransactionStatus;
import com.pingidentity.adapters.pingone.verify.api.model.VerifyResponse;
import com.pingidentity.adapters.pingone.verify.api.model.VerifyResponseWrapper;
import com.pingidentity.adapters.pingone.verify.authn.api.PingOneVerifyAuthnApiSupport;
import com.pingidentity.adapters.pingone.verify.authn.api.StateSpec;
import com.pingidentity.adapters.pingone.verify.config.AdapterConfiguration;
import com.pingidentity.adapters.pingone.verify.config.Region;
import com.pingidentity.adapters.pingone.verify.config.UiConfig;
import com.pingidentity.adapters.pingone.verify.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.verify.exception.ApiException;
import com.pingidentity.adapters.pingone.verify.exception.InvalidUserException;
import com.pingidentity.adapters.pingone.verify.exception.InvalidValueException;
import com.pingidentity.adapters.pingone.verify.exception.LimitExceededException;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpRequestBuilder;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpResponseBuilder;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpService;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpServiceFactory;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwt.NumericDate;
import com.pingidentity.adapters.pingone.verify.util.AccountRecoveryFlowUtil;
import com.pingidentity.adapters.pingone.verify.util.ObjectMapperUtil;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;

public class PingOneVerifyAdapter
implements IdpAuthenticationAdapterV2,
AuthnApiPlugin {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(PingOneVerifyAdapter.class);
    private static final String TX_ID_TITLE = "{\"transactionId\": \"";
    private static final String EMAIL_MASK_PATTERN = "(?<=.{3})[^@](?=[^@]*?@)|(?:(?<=@)|(?!^)\\G(?=[^@]*$)).(?=...*[^@]\\.)";
    private static final String PHONE_MASK_PATTERN = ".*(.{4})$";
    private static final String PHONE_MASK_STRING = "*** *** $1";
    private AuthnApiSupport authnApiSupport = AuthnApiSupport.getDefault();
    private PingOneVerifyAuthnApiSupport pingOneVerifyAuthnApiSupport = new PingOneVerifyAuthnApiSupport(this.authnApiSupport);
    private StateSupportFactory stateSupportFactory;
    private TemplateSupport templateSupport;
    private LanguagePackMessagesSupport languagePackMessagesSupport;
    private Map<String, String> optionalAttributes = new HashMap<String, String>();
    private String envId;
    private String clientId;
    private String clientSecret;
    private String popId;
    private String authEndpoint;
    private String apiEndpoint;
    private String emailAttrName;
    private String phoneAttrName;
    private DeliveryMethod deliveryMethod;
    private String selfieAttrName;
    private String verifyPolicy;
    private String redirectUrl;
    private String redirectMessage;
    private Map<UiConfig, String> biographicAttrNames;
    private String htmlTemplatePrefix;
    private boolean provisionUser;
    private boolean verificationFailedRetry;
    private boolean verificationReset;
    private boolean apiFailureBypass;
    private boolean invalidUserBypass;
    private boolean showSuccessScreen;
    private boolean showFailedScreen;
    private boolean showTimeoutScreen;
    private int stateTimeoutInt;
    private int requestTimeoutInt;
    private String proxySettings;
    private String proxyHost;
    private int proxyPort;
    private TokenService tokenService;
    private AuthClient authClient;
    private ApiClient apiClient;
    private static boolean supportsSetMetadata;
    private static boolean supportsPluginServiceAssociation;
    private String pingOneEnvironment;
    private ReflectivePingOneEnvironmentAccessor pingOneEnvironmentAccessor;

    public PingOneVerifyAdapter() {
    }

    public PingOneVerifyAdapter(Configuration configuration, StateSupportFactory stateSupportFactory, TemplateSupport templateSupport, AuthClient authClient, ApiClient apiClient, TokenService tokenService, AuthnApiSupport authnApiSupport, PingOneVerifyAuthnApiSupport pingOneVerifyAuthnApiSupport, LanguagePackMessagesSupport languagePackMessagesSupport) {
        this.configureInternalState(configuration);
        this.stateSupportFactory = stateSupportFactory;
        this.templateSupport = templateSupport;
        this.authClient = authClient;
        this.apiClient = apiClient;
        this.tokenService = tokenService;
        this.authnApiSupport = authnApiSupport;
        this.pingOneVerifyAuthnApiSupport = pingOneVerifyAuthnApiSupport;
        this.languagePackMessagesSupport = languagePackMessagesSupport;
    }

    public Map lookupAuthN(HttpServletRequest req, HttpServletResponse resp, String spPartnerEntityId, AuthnPolicy authnPolicy, String resumePath) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthnAdapterResponse lookupAuthN(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws AuthnAdapterException, IOException {
        LOGGER.logMethodEntry();
        String passedInUser = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        String resumePath = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
        StateSupport stateSupport = this.stateSupportFactory.make(resumePath);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        String transactionId = stateSupport.getTransactionId(req, resp);
        boolean firstLookUp = stateSupport.getFirstLookUp(req, resp);
        boolean isAccountRecovery = AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters);
        try {
            String userId;
            String token = this.tokenService.getToken();
            this.apiClient.setToken(token);
            if (firstLookUp) {
                boolean userAuthenticated = true;
                if (inParameters.containsKey("com.pingidentity.adapter.input.parameter.userid.authenticated")) {
                    userAuthenticated = (Boolean)inParameters.get("com.pingidentity.adapter.input.parameter.userid.authenticated");
                }
                if (!userAuthenticated) {
                    LOGGER.log(CustomLogEvent.USER_NOT_AUTHENTICATED);
                    authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                    stateSupport.cleanup(req, resp);
                    AuthnAdapterResponse authnAdapterResponse2 = authnAdapterResponse;
                    return authnAdapterResponse2;
                }
                userId = this.apiClient.getUserId(passedInUser, this.popId, this.provisionUser);
                stateSupport.setAttribute("userId", userId, req, resp);
            } else {
                userId = stateSupport.getUserId(req, resp);
            }
            String qrCode = stateSupport.getStringAttribute("qrCode", req, resp);
            String verificationCode = stateSupport.getStringAttribute("verificationCode", req, resp);
            String webVerificationUrl = stateSupport.getStringAttribute("webVerificationUrl", req, resp);
            boolean resetVerificationStatus = this.verificationReset || isAccountRecovery;
            stateSupport.setAttribute("reset verification status", resetVerificationStatus, req, resp);
            VerifyResponseWrapper verifyResponse = this.apiClient.getIdvStatus(userId, transactionId, qrCode, verificationCode, webVerificationUrl, resetVerificationStatus);
            String state = this.getState(req, resp, stateSupport, verifyResponse);
            if (!this.authnApiSupport.isApiRequest(req) || "GET".equals(req.getMethod()) || this.isValidAdapterAuthnApiPost(req, resp, stateSupport, state)) {
                authnAdapterResponse = this.isPollRequest(req) ? this.handleStateRequest(req, resp, stateSupport, inParameters, state, verifyResponse) : (this.isRetryVerificationRequest(req) ? this.handleRetryVerification(req, resp, stateSupport, inParameters, verifyResponse, state) : (this.isContinueAuthenticationRequest(req) ? this.handleContinueAuthentication(req, resp, stateSupport, inParameters, verifyResponse) : (this.isCancelAuthenticationRequest(req) ? this.handleCancelAuthnRequest() : this.handleStateRequest(req, resp, stateSupport, inParameters, state, verifyResponse))));
            } else {
                authnAdapterResponse = new AuthnAdapterResponse();
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            }
        }
        catch (LimitExceededException e) {
            VerifyResponseWrapper verifyResponseWrapper = new VerifyResponseWrapper(null, TransactionStatus.FAIL.getValue());
            verifyResponseWrapper.setLimitExceededErrorMessage();
            verifyResponseWrapper.setErrJson("{\"message\":\"" + e.getMessage() + "\"}");
            authnAdapterResponse = this.handleIdVerificationFailed(req, resp, stateSupport, inParameters, verifyResponseWrapper);
        }
        catch (AccessTokenProviderException | ApiException | InvalidUserException e) {
            boolean bypass = false;
            if (Boolean.parseBoolean(req.getParameter("pollStatus"))) {
                VerifyResponse verifyResponse = new VerifyResponse();
                VerifyResponseWrapper verifyResponseWrapper = new VerifyResponseWrapper(verifyResponse, TransactionStatus.FAIL.getValue(), null, null);
                LOGGER.logMethodExit();
                AuthnAdapterResponse authnAdapterResponse3 = this.sendPollingRequestResponse(req, resp, verifyResponseWrapper, false, false);
                return authnAdapterResponse3;
            }
            if (e instanceof InvalidUserException) {
                if (isAccountRecovery) {
                    LOGGER.log(CustomLogEvent.INVALID_USER_ACCOUNT_RECOVERY);
                } else {
                    LOGGER.log(CustomLogEvent.INVALID_USER);
                }
                if (this.invalidUserBypass) {
                    bypass = true;
                }
            } else {
                if (e instanceof ApiException) {
                    LOGGER.log(CustomLogEvent.PINGONE_FAILED);
                } else {
                    LOGGER.log(CustomLogEvent.ACCESS_TOKEN_EXCEPTION);
                }
                if (this.apiFailureBypass) {
                    bypass = true;
                }
            }
            if (bypass) {
                LOGGER.log((LogEvent)CustomLogEvent.BYPASS, e);
                if (isAccountRecovery) {
                    LOGGER.log(CustomLogEvent.FAIL_BYPASS);
                    authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                    stateSupport.cleanup(req, resp);
                    AuthnAdapterResponse authnAdapterResponse4 = authnAdapterResponse;
                    return authnAdapterResponse4;
                }
                authnAdapterResponse = this.getAuthnSuccess(req, resp, stateSupport, passedInUser, null);
            } else {
                LOGGER.log(CustomLogEvent.EXCEPTION_THROWN);
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            }
        }
        finally {
            if (this.isFlowComplete(authnAdapterResponse)) {
                stateSupport.cleanup(req, resp);
            }
        }
        LOGGER.logMethodExit();
        return authnAdapterResponse;
    }

    public Map<String, Object> getAdapterInfo() {
        return null;
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        IdpAuthnAdapterDescriptor descriptor = new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, UiConfig.ADAPTER.field, this.getContract(), true, AdapterConfiguration.makeAdapterConfigurationGuiDescription(null), false){

            public GuiConfigDescriptorBuilder getGuiConfigDescriptorBuilder() {
                return new GuiConfigDescriptorBuilder(){

                    public GuiConfigDescriptor buildNewGuiDescriptor() {
                        return AdapterConfiguration.makeAdapterConfigurationGuiDescription(null);
                    }

                    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
                        return AdapterConfiguration.makeAdapterConfigurationGuiDescription(configuration);
                    }
                };
            }
        };
        if (supportsSetMetadata && supportsPluginServiceAssociation) {
            try {
                Class<?> pluginMetadataKeysClass = Class.forName("com.pingidentity.sdk.PluginMetadataKeys");
                Class<?> pluginServiceAssociationClass = Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
                Constructor<?> pluginServiceAssociationConstructor = pluginServiceAssociationClass.getConstructor(String.class, String.class);
                descriptor.setMetadata(Collections.singletonMap((String)pluginMetadataKeysClass.getField("PING_ONE_SERVICE_ASSOCIATION").get(null), pluginServiceAssociationConstructor.newInstance("Verify Adapter", pluginServiceAssociationClass.getField("VERIFY_SERVICE_DISPLAY_NAME").get(null))));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return descriptor;
    }

    public boolean logoutAuthN(Map map, HttpServletRequest req, HttpServletResponse resp, String resumePath) {
        return true;
    }

    public void configure(Configuration conf) {
        this.configureInternalState(conf);
        this.stateSupportFactory = new StateSupportFactory();
        this.templateSupport = new TemplateSupport(this.htmlTemplatePrefix, this.languagePackMessagesSupport);
        CustomHttpClientFactory clientFactory = new CustomHttpClientFactory().setRequestTimeout(this.requestTimeoutInt).setProxySettings(this.proxySettings).setProxyHost(this.proxyHost).setProxyPort(this.proxyPort);
        ApacheHttpService httpService = new ApacheHttpServiceFactory().make(new ApacheHttpRequestBuilder(), clientFactory, new ApacheHttpResponseBuilder());
        if (this.pingOneEnvironmentAccessor == null) {
            this.authClient = new AuthClient(httpService, this.authEndpoint, this.envId, this.clientId, this.clientSecret);
        } else {
            this.envId = this.pingOneEnvironmentAccessor.getEnvironmentId();
            this.apiEndpoint = this.pingOneEnvironmentAccessor.getManagementEndpoint();
        }
        this.apiClient = new ApiClient(httpService, this.apiEndpoint, this.envId);
        this.tokenService = new TokenService(() -> {
            try {
                if (this.pingOneEnvironmentAccessor != null) {
                    return this.pingOneEnvironmentAccessor.getAccessToken();
                }
                return this.authClient.postTokenRequest();
            }
            catch (Throwable e) {
                throw new AccessTokenProviderException("Error requesting access token", e);
            }
        }, this.pingOneEnvironmentAccessor != null ? this.pingOneEnvironment : this.clientId);
    }

    public PluginApiSpec getApiSpec() {
        return new PluginApiSpec(PingOneVerifyAuthnApiSupport.getAuthnStateSpecs());
    }

    private Set<String> getContract() {
        return Arrays.stream(CoreContract.values()).map(CoreContract::getValue).collect(Collectors.toSet());
    }

    private void configureInternalState(Configuration conf) {
        this.optionalAttributes = AdapterConfiguration.OptionalAttributesTable.getOptionalAttributes(conf);
        if (AdapterConfiguration.PingOneEnvironmentField.isConfigured(conf)) {
            this.pingOneEnvironment = AdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(conf);
            this.pingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(this.pingOneEnvironment);
            this.popId = AdapterConfiguration.PingOnePopulationsField.getPingOnePopulation(conf);
            this.verifyPolicy = AdapterConfiguration.VerifyPolicyField.getVerifyPolicy(conf);
        } else {
            this.envId = AdapterConfiguration.getStringValue(conf, UiConfig.ENV_ID);
            this.clientId = AdapterConfiguration.getStringValue(conf, UiConfig.CLIENT_ID);
            this.clientSecret = AdapterConfiguration.getStringValue(conf, UiConfig.CLIENT_SECRET);
            Region region = Region.fromValue(AdapterConfiguration.getStringValue(conf, UiConfig.REGION));
            this.authEndpoint = region.getAuthEndpoint();
            this.apiEndpoint = region.getApiEndpoint();
            this.popId = AdapterConfiguration.getStringValue(conf, UiConfig.POP_ID);
            this.verifyPolicy = AdapterConfiguration.getStringValue(conf, UiConfig.POLICY_ID);
        }
        this.emailAttrName = AdapterConfiguration.getStringValueForNewField(conf, UiConfig.EMAIL_ATTR_NAME);
        this.phoneAttrName = AdapterConfiguration.getStringValueForNewField(conf, UiConfig.PHONE_ATTR_NAME);
        this.deliveryMethod = DeliveryMethod.fromString(AdapterConfiguration.getStringValueForNewField(conf, UiConfig.DELIVERY_METHOD));
        this.selfieAttrName = AdapterConfiguration.getStringValueForNewField(conf, UiConfig.SELFIE_ATTR_NAME);
        this.redirectUrl = AdapterConfiguration.getStringValueForNewField(conf, UiConfig.REDIRECT_URL);
        this.redirectMessage = AdapterConfiguration.getStringValueForNewField(conf, UiConfig.REDIRECT_MESSAGE);
        this.biographicAttrNames = new HashMap<UiConfig, String>();
        for (UiConfig uiConfig : UiConfig.BIOGRAPHIC_UI_CONFIGS) {
            String attrName = AdapterConfiguration.getStringValueForNewField(conf, uiConfig);
            if (!StringUtils.isNotBlank(attrName)) continue;
            this.biographicAttrNames.put(uiConfig, attrName);
        }
        this.htmlTemplatePrefix = AdapterConfiguration.getStringValue(conf, UiConfig.HTML_TEMPLATE);
        String messageProperties = AdapterConfiguration.getStringValue(conf, UiConfig.MESSAGE_PROPERTIES);
        String errorMessageKeyPrefix = AdapterConfiguration.getStringValue(conf, UiConfig.ERROR_MESSAGE_KEY_PREFIX);
        this.languagePackMessagesSupport = new LanguagePackMessagesSupport(messageProperties, errorMessageKeyPrefix);
        this.provisionUser = AdapterConfiguration.getBooleanValue(conf, UiConfig.PROVISION_USER);
        this.verificationFailedRetry = AdapterConfiguration.getBooleanValue(conf, UiConfig.VERIFICATION_RETRY);
        this.verificationReset = AdapterConfiguration.getBooleanValue(conf, UiConfig.VERIFICATION_RESET);
        this.invalidUserBypass = "Bypass authentication".equals(AdapterConfiguration.getStringValue(conf, UiConfig.USER_NOT_FOUND_FAILURE_MODE));
        this.apiFailureBypass = "Bypass authentication".equals(AdapterConfiguration.getStringValue(conf, UiConfig.SERVICE_UNAVAILABLE_FAILURE_MODE));
        this.showSuccessScreen = AdapterConfiguration.getBooleanValue(conf, UiConfig.SUCCESS_SCREENS);
        this.showFailedScreen = AdapterConfiguration.getBooleanValue(conf, UiConfig.FAILED_SCREENS);
        this.showTimeoutScreen = AdapterConfiguration.getBooleanValue(conf, UiConfig.TIMEOUT_SCREENS);
        this.stateTimeoutInt = AdapterConfiguration.getIntValue(conf, UiConfig.STATE_TIMEOUT);
        this.requestTimeoutInt = AdapterConfiguration.getIntValue(conf, UiConfig.API_REQUEST_TIMEOUT);
        this.proxySettings = AdapterConfiguration.getStringValue(conf, UiConfig.PROXY_SETTINGS);
        this.proxyHost = AdapterConfiguration.getStringValue(conf, UiConfig.PROXY_HOST);
        this.proxyPort = AdapterConfiguration.getIntValue(conf, UiConfig.PROXY_PORT);
    }

    private String getState(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, VerifyResponseWrapper verifyResponse) {
        String currentState;
        String status = verifyResponse.getTransactionStatus();
        if (TransactionStatus.isVerificationNotNeeded(status)) {
            String currentState2 = StateSpec.ID_VERIFICATION_COMPLETED.getStatus();
            LOGGER.log((LogEvent)CustomLogEvent.ADAPTER_STATE, status, currentState2);
            return currentState2;
        }
        boolean firstLookUp = stateSupport.getFirstLookUp(req, resp);
        if (!firstLookUp) {
            if (TransactionStatus.FAIL.getValue().equals(status) || TransactionStatus.DELETED.getValue().equals(status)) {
                this.getMetadataAndSaveErrJson(req, resp, stateSupport, verifyResponse);
                if (!this.verificationFailedRetry) {
                    LOGGER.log(CustomLogEvent.BLOCK_USER_ERROR);
                    String currentState3 = StateSpec.ID_VERIFICATION_FAILED.getStatus();
                    LOGGER.log((LogEvent)CustomLogEvent.ADAPTER_STATE, status, currentState3);
                    return currentState3;
                }
                stateSupport.setAttribute("savedError", verifyResponse.getErrorMessage(), req, resp);
                LOGGER.log((LogEvent)CustomLogEvent.POLL_STATUS_TRACK, "getstate savedError: " + stateSupport.getSavedError(req, resp) + " errjson" + stateSupport.getSavedErrJson(req, resp));
                stateSupport.setAttribute("needNewTransaction", true, req, resp);
                currentState = StateSpec.ID_VERIFICATION_REQUIRED.getStatus();
            } else {
                currentState = TransactionStatus.IN_PROGRESS.getValue().equals(status) || TransactionStatus.PARTIAL.getValue().equals(status) ? StateSpec.ID_VERIFICATION_IN_PROGRESS.getStatus() : StateSpec.ID_VERIFICATION_REQUIRED.getStatus();
            }
        } else {
            currentState = StateSpec.ID_VERIFICATION_REQUIRED.getStatus();
        }
        if (this.isAdapterTimedOut(req, resp, stateSupport, currentState)) {
            currentState = StateSpec.ID_VERIFICATION_TIMED_OUT.getStatus();
        }
        LOGGER.log((LogEvent)CustomLogEvent.ADAPTER_STATE, status, currentState);
        return currentState;
    }

    private void getMetadataAndSaveErrJson(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, VerifyResponseWrapper verifyResponse) {
        String transactionId = verifyResponse.getId();
        if (transactionId == null) {
            return;
        }
        if (this.verificationFailedRetry) {
            String userId = stateSupport.getUserId(req, resp);
            HashMap<String, AttributeValue> metadata = this.apiClient.getMetaData(userId, transactionId, this.optionalAttributes);
            LOGGER.log((LogEvent)CustomLogEvent.POLL_STATUS_TRACK, "failed with retry tx metadata: " + metadata);
        }
        StringBuilder errBuilder = new StringBuilder();
        errBuilder.append(TX_ID_TITLE).append(transactionId).append("\"");
        errBuilder.append("}");
        verifyResponse.setErrJson(errBuilder.toString());
        stateSupport.setAttribute("savedErrJson", errBuilder.toString(), req, resp);
    }

    private AuthnAdapterResponse handleStateRequest(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, Map<String, Object> inParameters, String state, VerifyResponseWrapper verifyResponse) throws ApiException, AuthnAdapterException, IOException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        stateSupport.setAttribute("prevPfState", state, req, resp);
        authnAdapterResponse = StateSpec.ID_VERIFICATION_COMPLETED.getStatus().equals(state) ? this.handleIdVerificationCompleted(req, resp, stateSupport, inParameters, verifyResponse) : (StateSpec.ID_VERIFICATION_FAILED.getStatus().equals(state) ? this.handleIdVerificationFailed(req, resp, stateSupport, inParameters, verifyResponse) : (StateSpec.ID_VERIFICATION_TIMED_OUT.getStatus().equals(state) ? this.handleIdVerificationTimedOut(req, resp, inParameters, verifyResponse) : this.handleIdVerification(req, resp, stateSupport, inParameters, verifyResponse, state)));
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleIdVerificationCompleted(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, Map<String, Object> inParameters, VerifyResponseWrapper verifyResponse) throws IOException, AuthnAdapterException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneVerifyAuthnApiSupport.writeIdvVerificationCompletedResponse(req, resp);
        } else {
            if (Boolean.parseBoolean(req.getParameter("pollStatus"))) {
                return this.sendPollingRequestResponse(req, resp, verifyResponse, false, false);
            }
            if (!this.showSuccessScreen) {
                authnAdapterResponse = this.handleVerificationCompleted(req, resp, stateSupport, inParameters, verifyResponse);
            } else {
                this.templateSupport.renderVerificationCompletedForm(req, resp, inParameters);
            }
        }
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleIdVerificationFailed(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, Map<String, Object> inParameters, VerifyResponseWrapper verifyResponse) throws IOException, AuthnAdapterException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        LOGGER.log(CustomLogEvent.UNRECOVERABLE_ERROR);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        String transactionId = verifyResponse.getId();
        attributes.put("transactionId", transactionId);
        attributes.put("errorMessage", verifyResponse.getErrorMessage());
        String userId = stateSupport.getUserId(req, resp);
        if (userId != null && transactionId != null) {
            HashMap<String, AttributeValue> metadata = this.apiClient.getMetaData(userId, transactionId, this.optionalAttributes);
            if (!metadata.isEmpty()) {
                attributes.putAll(metadata);
            }
            authnAdapterResponse.setAttributeMap(attributes);
            LOGGER.log((LogEvent)CustomLogEvent.AUTHN_FAIL_RESPONSE, "userId: " + userId + ", attributeMap: " + authnAdapterResponse.getAttributeMap());
        }
        if (this.authnApiSupport.isApiRequest(req)) {
            List<CustomAuthnErrorDetail> customAuthnErrorDetails = this.languagePackMessagesSupport.getErrorMessage(verifyResponse.getErrorMessage(false), req);
            this.pingOneVerifyAuthnApiSupport.writeIdvVerificationFailedResponse(req, resp, customAuthnErrorDetails, transactionId, verifyResponse.getErrJson());
        } else {
            if (Boolean.parseBoolean(req.getParameter("pollStatus"))) {
                return this.sendPollingRequestResponse(req, resp, verifyResponse, false, false);
            }
            if (!this.showFailedScreen) {
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            } else {
                this.templateSupport.renderVerificationFailedForm(req, resp, inParameters, transactionId, verifyResponse.getErrorMessage(true), verifyResponse.getErrJson());
            }
        }
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleIdVerificationTimedOut(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, VerifyResponseWrapper verifyResponse) throws IOException, AuthnAdapterException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        LOGGER.log(CustomLogEvent.TIMED_OUT);
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneVerifyAuthnApiSupport.writeIdvVerificationTimedOutResponse(req, resp);
        } else {
            if (Boolean.parseBoolean(req.getParameter("pollStatus"))) {
                return this.sendPollingRequestResponse(req, resp, verifyResponse, false, false);
            }
            if (!this.showTimeoutScreen) {
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            } else {
                this.templateSupport.renderTimedOutForm(req, resp, inParameters);
            }
        }
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleIdVerification(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, Map<String, Object> inParameters, VerifyResponseWrapper verifyResponse, String state) throws ApiException, AuthnAdapterException, IOException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        boolean options = this.getOptionsAndStoreEmailPhone(req, resp, stateSupport);
        String device = this.getAndStoreDevice(req, resp, stateSupport);
        boolean newtab = device.equals("self");
        String[][] emails = null;
        String[][] phones = null;
        String errorMessage = null;
        boolean express = stateSupport.getBooleanAttribute("express", req, resp);
        String userId = stateSupport.getUserId(req, resp);
        boolean firstLookUp = stateSupport.getFirstLookUp(req, resp);
        boolean needNewTransaction = stateSupport.getBooleanAttribute("needNewTransaction", req, resp);
        LOGGER.log((LogEvent)CustomLogEvent.POLL_STATUS_TRACK, "first: " + firstLookUp + " state: " + state + " options: " + options + " device: " + device + " newtab: " + newtab + " express: " + express + " vcode: " + verifyResponse.getVerificationCode() + " neednewtx: " + needNewTransaction);
        try {
            if (!firstLookUp) {
                if (needNewTransaction) {
                    VerifyTransactionRequest verifyTransactionRequest = this.createVerifyTransactionRequest(req, resp, stateSupport, inParameters, emails, phones, userId, newtab);
                    this.resetVerificationLimits(req, resp, stateSupport, userId);
                    verifyResponse = this.apiClient.createTransaction(verifyTransactionRequest);
                    stateSupport.setTransactionId(verifyResponse.getId(), req, resp);
                    stateSupport.setAttribute("qrCode", verifyResponse.getQrUrl(), req, resp);
                    stateSupport.setAttribute("verificationCode", verifyResponse.getWebVerificationCode(), req, resp);
                    stateSupport.setAttribute("webVerificationUrl", verifyResponse.getWebVerificationUrl(), req, resp);
                    stateSupport.setAttribute("needNewTransaction", false, req, resp);
                    stateSupport.setStateInitTime(NumericDate.now().getValue(), req, resp);
                }
                if (verifyResponse.getErrorMessage() == null) {
                    List<LinkedHashMap<String, Object>> savedError = stateSupport.getSavedError(req, resp);
                    verifyResponse.setErrorMessage(savedError);
                }
                if (verifyResponse.getErrJson() == null) {
                    String savedErrJson = stateSupport.getSavedErrJson(req, resp);
                    verifyResponse.setErrJson(savedErrJson);
                }
            } else {
                Map<NotifType, String[][]> chainedAttrVals = this.getChainedEmailPhone(inParameters);
                emails = chainedAttrVals.get((Object)NotifType.EMAIL);
                phones = chainedAttrVals.get((Object)NotifType.PHONE);
                errorMessage = this.getForcePolicyError(emails, phones);
                express = !device.isEmpty() && errorMessage.isEmpty() && (this.deliveryMethod == DeliveryMethod.USER_SELECTION && device.equals("self") || device.equals("other") && emails.length == 0 && phones.length == 0);
                stateSupport.setAttribute("express", express, req, resp);
                LOGGER.log((LogEvent)CustomLogEvent.POLL_STATUS_TRACK, "errorMessage: " + errorMessage + " deliveryMethod: " + (Object)((Object)this.deliveryMethod) + " device: " + device + " options: " + options + " express: " + express);
                if (options || express) {
                    VerifyTransactionRequest verifyTransactionRequest = this.createVerifyTransactionRequest(req, resp, stateSupport, inParameters, emails, phones, userId, newtab);
                    this.resetVerificationLimits(req, resp, stateSupport, userId);
                    verifyResponse = this.apiClient.createTransaction(verifyTransactionRequest);
                    stateSupport.setTransactionId(verifyResponse.getId(), req, resp);
                    stateSupport.setAttribute("qrCode", verifyResponse.getQrUrl(), req, resp);
                    stateSupport.setAttribute("verificationCode", verifyResponse.getWebVerificationCode(), req, resp);
                    stateSupport.setAttribute("webVerificationUrl", verifyResponse.getWebVerificationUrl(), req, resp);
                    stateSupport.setAttribute("firstLookUp", false, req, resp);
                    stateSupport.setAttribute("savedError", null, req, resp);
                    stateSupport.setAttribute("savedErrJson", null, req, resp);
                    stateSupport.setAttribute("needNewTransaction", false, req, resp);
                    stateSupport.setStateInitTime(NumericDate.now().getValue(), req, resp);
                }
            }
        }
        catch (LimitExceededException e) {
            state = StateSpec.ID_VERIFICATION_FAILED.getStatus();
            verifyResponse = new VerifyResponseWrapper(null, TransactionStatus.FAIL.getValue());
            verifyResponse.setLimitExceededErrorMessage();
            verifyResponse.setErrJson("{\"message\":\"" + e.getMessage() + "\"}");
            return this.handleStateRequest(req, resp, stateSupport, inParameters, state, verifyResponse);
        }
        catch (InvalidValueException e) {
            state = StateSpec.ID_VERIFICATION_FAILED.getStatus();
            verifyResponse = new VerifyResponseWrapper(null, TransactionStatus.FAIL.getValue());
            verifyResponse.setSingleErrorMessage(e.getMessage(), "");
            verifyResponse.setErrJson(TX_ID_TITLE + verifyResponse.getId() + "\", \"message\":\"" + e.getMessage() + "\"}");
            return this.handleStateRequest(req, resp, stateSupport, inParameters, state, verifyResponse);
        }
        boolean isApiRequest = this.authnApiSupport.isApiRequest(req);
        if (isApiRequest) {
            if (StateSpec.ID_VERIFICATION_IN_PROGRESS.getStatus().equals(state)) {
                this.pingOneVerifyAuthnApiSupport.writeIdvVerificationInProgressResponse(req, resp);
            } else if (device.isEmpty()) {
                this.pingOneVerifyAuthnApiSupport.writeIdvVerificationDeviceResponse(req, resp);
            } else if (options || express) {
                if (firstLookUp || needNewTransaction) {
                    LOGGER.log((LogEvent)CustomLogEvent.POLL_STATUS_TRACK, "created tx, vcode: " + verifyResponse.getVerificationCode());
                }
                LOGGER.log((LogEvent)CustomLogEvent.POLL_STATUS_TRACK, "writing required response: " + verifyResponse.getVerificationCode() + " newtab: " + newtab + " " + verifyResponse.getWebVerificationUrl() + " first: " + firstLookUp + " needNewTx: " + needNewTransaction);
                List<CustomAuthnErrorDetail> customAuthnErrorDetails = this.languagePackMessagesSupport.getErrorMessage(verifyResponse.getErrorMessage(false), req);
                this.pingOneVerifyAuthnApiSupport.writeIdvVerificationRequiredResponse(req, resp, verifyResponse, newtab ? "newTab" : "", customAuthnErrorDetails, verifyResponse.getErrJson());
            } else {
                this.pingOneVerifyAuthnApiSupport.writeIdvVerificationOptionsResponse(req, resp, emails, phones, errorMessage, this.deliveryMethod != DeliveryMethod.USER_SELECTION);
            }
        } else {
            if (Boolean.parseBoolean(req.getParameter("pollStatus"))) {
                if (!needNewTransaction) {
                    verifyResponse.setErrJson(null);
                    newtab = false;
                }
                return this.sendPollingRequestResponse(req, resp, verifyResponse, true, newtab);
            }
            if (device.isEmpty()) {
                this.templateSupport.renderVerificationDeviceForm(req, resp, inParameters);
                return authnAdapterResponse;
            }
            if (options || express) {
                LOGGER.log((LogEvent)CustomLogEvent.POLL_STATUS_TRACK, "created tx, vcode: " + verifyResponse.getVerificationCode());
                this.templateSupport.renderVerificationRequiredForm(req, resp, inParameters, verifyResponse, newtab ? "newTab" : "");
            } else {
                this.templateSupport.renderVerificationOptionsForm(req, resp, inParameters, verifyResponse, emails, phones, errorMessage, this.deliveryMethod != DeliveryMethod.USER_SELECTION);
            }
        }
        return authnAdapterResponse;
    }

    private VerifyTransactionRequest createVerifyTransactionRequest(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, Map<String, Object> inParameters, String[][] emails, String[][] phones, String userId, boolean newtab) throws InvalidValueException, LimitExceededException {
        String email = stateSupport.getStringAttribute("email", req, resp);
        String phone = stateSupport.getStringAttribute("phone", req, resp);
        String selfie = this.getSelfie(inParameters);
        String runVerifyPolicy = this.apiClient.checkVerifyPolicy(this.verifyPolicy, emails, phones, userId);
        LOGGER.log((LogEvent)CustomLogEvent.POLL_STATUS_TRACK, "handleidv emailphone: " + email + " " + phone + " newtab " + newtab + " verify policy: " + runVerifyPolicy);
        Map<UiConfig, String[]> biographicAttrValues = this.getBiographicAttrValues(inParameters);
        return VerifyTransactionRequest.builder().userId(userId).email(email).phone(phone).selfie(selfie).verifyPolicy(runVerifyPolicy).emails(emails).phones(phones).redirectUrl(this.redirectUrl).redirectMessage(this.redirectMessage).biographicFieldValues(biographicAttrValues).build();
    }

    private void resetVerificationLimits(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, String userId) throws ApiException {
        if (stateSupport.getBooleanAttribute("reset verification status", req, resp)) {
            this.apiClient.resetVerificationLimits(userId);
        }
    }

    private String getAndStoreDevice(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport) {
        if (this.deliveryMethod != DeliveryMethod.USER_SELECTION) {
            return "other";
        }
        String device = stateSupport.getStringAttribute("deviceAuthentication", req, resp);
        if (device != null && !device.isEmpty()) {
            return device;
        }
        if (this.pingOneVerifyAuthnApiSupport.isDeviceAuthenticationRequest(req)) {
            try {
                Map map = this.authnApiSupport.deserializeAsMap(req);
                device = (String)map.get("deviceAuthentication");
            }
            catch (IOException e) {
                LOGGER.log((LogEvent)CustomLogEvent.AUTHN_FAIL_RESPONSE, "failed to parse deviceAuthentication from authn API request");
            }
        } else {
            device = req.getParameter("deviceAuthentication");
        }
        device = device == null ? "" : device;
        stateSupport.setAttribute("deviceAuthentication", device, req, resp);
        return device;
    }

    private boolean getOptionsAndStoreEmailPhone(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport) {
        boolean options = stateSupport.getBooleanAttribute("optionsAuthentication", req, resp);
        if (options) {
            return options;
        }
        String email = null;
        String phone = null;
        if (this.pingOneVerifyAuthnApiSupport.isOptionsAuthenticationRequest(req)) {
            try {
                Map map = this.authnApiSupport.deserializeAsMap(req);
                options = map.getOrDefault("optionsAuthentication", false);
                if (options) {
                    email = (String)map.get("email");
                    phone = (String)map.get("phone");
                }
            }
            catch (IOException e) {
                LOGGER.log((LogEvent)CustomLogEvent.AUTHN_FAIL_RESPONSE, "failed to parse emailphone optionsAuthentication from authn API request");
            }
        } else {
            options = Boolean.parseBoolean(req.getParameter("optionsAuthentication"));
            if (options) {
                email = req.getParameter("email");
                phone = req.getParameter("phone");
            }
        }
        stateSupport.setAttribute("email", email, req, resp);
        stateSupport.setAttribute("phone", phone, req, resp);
        stateSupport.setAttribute("optionsAuthentication", options, req, resp);
        return options;
    }

    private String getForcePolicyError(String[][] emails, String[][] phones) {
        if (this.deliveryMethod == DeliveryMethod.FORCE_EMAIL_ONLY && emails.length == 0) {
            return this.policyError(this.emailAttrName);
        }
        if (this.deliveryMethod == DeliveryMethod.FORCE_PHONE_ONLY && phones.length == 0) {
            return this.policyError(this.phoneAttrName);
        }
        return "";
    }

    private String policyError(String attrName) {
        String errorMsg = "No '" + attrName + "' attribute found in your account profile";
        LOGGER.log((LogEvent)CustomLogEvent.FORCE_POLICY_ERROR, errorMsg, this.deliveryMethod.value());
        return errorMsg;
    }

    private Map<NotifType, String[][]> getChainedEmailPhone(Map<String, Object> inParameters) {
        Map chAttrMap = inParameters.getOrDefault("com.pingidentity.adapter.input.parameter.chained.attributes", new HashMap());
        StringBuilder sb = new StringBuilder();
        chAttrMap.keySet().forEach(key -> {
            String value = ((AttributeValue)chAttrMap.get(key)).getValue();
            if (key.toLowerCase().contains("photo")) {
                sb.append(key + ": " + (value == null ? null : Integer.valueOf(value.length())) + ", ");
            } else {
                sb.append(key + ": " + value + ", ");
            }
        });
        String[][] emails = this.getAttrValuesWithMask(chAttrMap, this.emailAttrName, NotifType.EMAIL);
        String[][] phones = this.getAttrValuesWithMask(chAttrMap, this.phoneAttrName, NotifType.PHONE);
        LOGGER.log((LogEvent)CustomLogEvent.GET_CHAINED_ATTR, sb.toString(), this.emailAttrName, Arrays.stream(emails).map(e -> e[0] + ": " + e[1]).collect(Collectors.toList()), this.phoneAttrName, Arrays.stream(phones).map(e -> e[0] + ": " + e[1]).collect(Collectors.toList()));
        EnumMap<NotifType, String[][]> map = new EnumMap<NotifType, String[][]>(NotifType.class);
        map.put(NotifType.EMAIL, emails);
        map.put(NotifType.PHONE, phones);
        return map;
    }

    private String getSelfie(Map<String, Object> inParameters) {
        AttributeValue attributeValue = PingOneVerifyAdapter.getAttributeValue(inParameters, this.selfieAttrName);
        String value = attributeValue.getValue();
        LOGGER.log((LogEvent)CustomLogEvent.POLL_STATUS_TRACK, "selfie img size: " + (value == null ? 0 : value.length()));
        return value;
    }

    private String[][] getAttrValuesWithMask(Map<String, Object> chAttrMap, String attrName, NotifType notifType) {
        if (this.deliveryMethod == DeliveryMethod.FORCE_PHONE_ONLY && notifType == NotifType.EMAIL || this.deliveryMethod == DeliveryMethod.FORCE_EMAIL_ONLY && notifType == NotifType.PHONE) {
            return new String[0][0];
        }
        return (String[][])((AttributeValue)chAttrMap.getOrDefault(attrName, new AttributeValue())).getValuesAsCollection().stream().map(String::trim).filter(a -> !a.isEmpty()).map(e -> new String[]{e, this.mask((String)e, notifType)}).toArray(x$0 -> new String[x$0][]);
    }

    private String[] getAttrMultiValues(Map<String, Object> inParameters, String attrName) {
        AttributeValue attributeValue = PingOneVerifyAdapter.getAttributeValue(inParameters, attrName);
        return (String[])attributeValue.getValuesAsCollection().stream().map(String::trim).filter(a -> !a.isEmpty()).toArray(String[]::new);
    }

    private Map<UiConfig, String[]> getBiographicAttrValues(Map<String, Object> inParameters) {
        HashMap<UiConfig, String[]> attrValues = new HashMap<UiConfig, String[]>();
        for (Map.Entry<UiConfig, String> e : this.biographicAttrNames.entrySet()) {
            String chainedAttribute = e.getValue();
            String[] attrMultiValues = this.getAttrMultiValues(inParameters, chainedAttribute);
            if (attrMultiValues != null && attrMultiValues.length > 0) {
                attrValues.put(e.getKey(), attrMultiValues);
                continue;
            }
            LOGGER.log((LogEvent)CustomLogEvent.MISSING_BIOGRAPHIC_VALUE, chainedAttribute);
        }
        if (attrValues.isEmpty()) {
            return null;
        }
        return attrValues;
    }

    private static AttributeValue getAttributeValue(Map<String, Object> inParameters, String attrName) {
        Map chAttrMap = inParameters.getOrDefault("com.pingidentity.adapter.input.parameter.chained.attributes", new HashMap());
        return chAttrMap.getOrDefault(attrName, new AttributeValue());
    }

    private String mask(String original, NotifType type) {
        if (type == NotifType.EMAIL) {
            return original.replaceAll(EMAIL_MASK_PATTERN, "*");
        }
        if (type == NotifType.PHONE) {
            return original.replaceAll("\\D", "").replaceFirst(PHONE_MASK_PATTERN, PHONE_MASK_STRING);
        }
        return "";
    }

    private AuthnAdapterResponse handleVerificationCompleted(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, Map<String, Object> inParameters, VerifyResponseWrapper verifyResponse) {
        String username = inParameters.get("com.pingidentity.adapter.input.parameter.userid").toString();
        return this.getAuthnSuccess(req, resp, stateSupport, username, verifyResponse);
    }

    private AuthnAdapterResponse handleRetryVerification(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, Map<String, Object> inParameters, VerifyResponseWrapper verifyResponse, String state) throws ApiException, AuthnAdapterException, IOException {
        LOGGER.log(CustomLogEvent.RETRY_VERIFICATION);
        stateSupport.setAttribute("firstLookUp", true, req, resp);
        stateSupport.setStateInitTime(NumericDate.now().getValue(), req, resp);
        stateSupport.setAttribute("email", null, req, resp);
        stateSupport.setAttribute("phone", null, req, resp);
        stateSupport.setAttribute("deviceAuthentication", null, req, resp);
        stateSupport.setAttribute("optionsAuthentication", false, req, resp);
        stateSupport.setAttribute("express", false, req, resp);
        return this.handleIdVerification(req, resp, stateSupport, inParameters, verifyResponse, state);
    }

    private AuthnAdapterResponse handleContinueAuthentication(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, Map<String, Object> inParameters, VerifyResponseWrapper verifyResponse) {
        LOGGER.log(CustomLogEvent.CONTINUE_AUTHENTICATION);
        return this.handleVerificationCompleted(req, resp, stateSupport, inParameters, verifyResponse);
    }

    private AuthnAdapterResponse handleCancelAuthnRequest() {
        LOGGER.log(CustomLogEvent.CANCEL_AUTHENTICATION);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setErrorMessage(CustomLogEvent.CANCEL_AUTHENTICATION.getMessage());
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse sendPollingRequestResponse(HttpServletRequest req, HttpServletResponse resp, VerifyResponseWrapper verifyResponse, boolean continuePolling, boolean newTab) throws IOException {
        resp.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        try {
            String errorString = this.languagePackMessagesSupport.getErrorMessage(req, verifyResponse.getErrorMessage(true));
            PollingRequestResponse pollingRequestResponse = new PollingRequestResponse(continuePolling, verifyResponse, errorString, newTab);
            String response = ObjectMapperUtil.getDefault().writeValueAsString(pollingRequestResponse);
            PrintWriter writer = resp.getWriter();
            writer.write(response);
            writer.close();
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            return authnAdapterResponse;
        }
        catch (IOException e) {
            LOGGER.log((LogEvent)CustomLogEvent.SEND_POLL_REQUEST_ERROR, e.getMessage());
            throw new IOException(e);
        }
    }

    private boolean isValidAdapterAuthnApiPost(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, String state) throws IOException {
        String prevState = stateSupport.getStringAttribute("prevPfState", req, resp);
        return this.isPollRequest(req) && (StateSpec.ID_VERIFICATION_REQUIRED.getStatus().equals(prevState) || StateSpec.ID_VERIFICATION_IN_PROGRESS.getStatus().equals(prevState)) || this.pingOneVerifyAuthnApiSupport.isValidPingOneVerifyAdapterAuthnApiPost(req, resp, state);
    }

    private boolean isContinueAuthenticationRequest(HttpServletRequest req) {
        return Boolean.parseBoolean(req.getParameter("continueAuthentication")) || this.pingOneVerifyAuthnApiSupport.isContinueAuthenticationRequest(req);
    }

    private boolean isCancelAuthenticationRequest(HttpServletRequest req) {
        return Boolean.parseBoolean(req.getParameter("cancelAuthentication")) || this.pingOneVerifyAuthnApiSupport.isCancelAuthenticationRequest(req);
    }

    private boolean isPollRequest(HttpServletRequest req) {
        return this.pingOneVerifyAuthnApiSupport.isPollRequest(req);
    }

    private boolean isRetryVerificationRequest(HttpServletRequest req) {
        return Boolean.parseBoolean(req.getParameter("retryVerification")) || this.pingOneVerifyAuthnApiSupport.isRetryVerification(req);
    }

    private AuthnAdapterResponse getAuthnSuccess(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, String subject, VerifyResponseWrapper verifyResponse) {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
        String transactionStatus = TransactionStatus.BYPASS.getValue();
        if (verifyResponse != null) {
            transactionStatus = verifyResponse.getTransactionStatus();
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("subject", subject);
        attributes.put("transactionStatus", transactionStatus);
        if (verifyResponse != null) {
            attributes.put("verifiedDocuments", verifyResponse.getVerifiedDocuments());
            String userId = stateSupport.getUserId(req, resp);
            HashMap<String, AttributeValue> userData = this.apiClient.getUserData(userId, verifyResponse.getId(), this.optionalAttributes);
            attributes.putAll(userData);
        }
        authnAdapterResponse.setAttributeMap(attributes);
        authnAdapterResponse.setUsername(subject);
        LOGGER.log((LogEvent)CustomLogEvent.AUTHN_SUCCESS_RESPONSE, authnAdapterResponse.getUsername(), authnAdapterResponse.getAttributeMap());
        return authnAdapterResponse;
    }

    private boolean isAdapterTimedOut(HttpServletRequest req, HttpServletResponse resp, StateSupport stateSupport, String currentState) {
        boolean isTimedOut = false;
        boolean options = stateSupport.getBooleanAttribute("optionsAuthentication", req, resp);
        boolean express = stateSupport.getBooleanAttribute("express", req, resp);
        if (!options && !express) {
            return false;
        }
        NumericDate now = NumericDate.now();
        String savedState = stateSupport.getStringAttribute("savedState", req, resp);
        if (savedState != null) {
            if (savedState.equals(currentState)) {
                Long stateInitTimeObject = stateSupport.getLongAttribute("stateInitTime", req, resp);
                if (stateInitTimeObject != null) {
                    boolean newRequiredState;
                    boolean needNewTransaction = stateSupport.getBooleanAttribute("needNewTransaction", req, resp);
                    boolean bl = newRequiredState = StateSpec.ID_VERIFICATION_REQUIRED.getStatus().equals(savedState) && StateSpec.ID_VERIFICATION_REQUIRED.getStatus().equals(currentState) && needNewTransaction;
                    if (newRequiredState) {
                        stateSupport.setStateInitTime(now.getValue(), req, resp);
                    } else {
                        NumericDate stateInitTime = NumericDate.fromSeconds(stateInitTimeObject);
                        stateInitTime.addSeconds(this.stateTimeoutInt);
                        if (now.isOnOrAfter(stateInitTime)) {
                            isTimedOut = true;
                        }
                    }
                } else {
                    stateSupport.setStateInitTime(now.getValue(), req, resp);
                }
            } else {
                stateSupport.setAttribute("savedState", currentState, req, resp);
                stateSupport.setStateInitTime(now.getValue(), req, resp);
            }
        } else {
            stateSupport.setAttribute("savedState", currentState, req, resp);
            stateSupport.setStateInitTime(now.getValue(), req, resp);
        }
        return isTimedOut;
    }

    private boolean isFlowComplete(AuthnAdapterResponse authnAdapterResponse) {
        return authnAdapterResponse == null || authnAdapterResponse.getAuthnStatus() != null && !AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS.equals((Object)authnAdapterResponse.getAuthnStatus());
    }

    static {
        Method[] methods = PluginDescriptor.class.getMethods();
        if (Arrays.stream(methods).anyMatch(m -> "setMetadata".equals(m.getName()))) {
            supportsSetMetadata = true;
        }
        try {
            Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
            supportsPluginServiceAssociation = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPluginServiceAssociation = false;
        }
    }

    public static enum DeliveryMethod {
        USER_SELECTION("User Selection"),
        FORCE_EMAIL_ONLY("Force Email Notification Only"),
        FORCE_PHONE_ONLY("Force Phone Notification Only");

        private String value;

        private DeliveryMethod(String val) {
            this.value = val;
        }

        public String value() {
            return this.value;
        }

        public static DeliveryMethod fromString(String value) {
            return Arrays.stream(DeliveryMethod.values()).filter(d -> d.value().equals(value)).findFirst().orElse(null);
        }
    }

    public static enum NotifType {
        EMAIL,
        PHONE;

    }
}

