/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify;

import com.pingidentity.adapters.pingone.verify.LanguagePackMessagesSupport;
import com.pingidentity.adapters.pingone.verify.api.model.VerifyResponseWrapper;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.template.TemplateRendererUtil;
import com.pingidentity.sdk.template.TemplateRendererUtilException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;

public class TemplateSupport {
    public static final String VERIFICATION_COMPLETED_SUFFIX = "-completed.html";
    public static final String VERIFICATION_FAILED_SUFFIX = "-failed.html";
    public static final String VERIFICATION_REQUIRED_SUFFIX = "-required.html";
    public static final String VERIFICATION_TIMED_OUT_SUFFIX = "-timed-out.html";
    public static final String VERIFICATION_OPTIONS_SUFFIX = "-options.html";
    public static final String VERIFICATION_DEVICE_SUFFIX = "-device.html";
    public String completedTemplate;
    public String failedTemplate;
    public String requiredTemplate;
    public String timedOutTemplate;
    public String optionsTemplate;
    public String deviceTemplate;
    private final LanguagePackMessagesSupport languagePackMessagesSupport;

    public TemplateSupport(String htmlTemplatePrefix, LanguagePackMessagesSupport languagePackMessagesSupport) {
        this.completedTemplate = htmlTemplatePrefix + VERIFICATION_COMPLETED_SUFFIX;
        this.failedTemplate = htmlTemplatePrefix + VERIFICATION_FAILED_SUFFIX;
        this.requiredTemplate = htmlTemplatePrefix + VERIFICATION_REQUIRED_SUFFIX;
        this.timedOutTemplate = htmlTemplatePrefix + VERIFICATION_TIMED_OUT_SUFFIX;
        this.optionsTemplate = htmlTemplatePrefix + VERIFICATION_OPTIONS_SUFFIX;
        this.deviceTemplate = htmlTemplatePrefix + VERIFICATION_DEVICE_SUFFIX;
        this.languagePackMessagesSupport = languagePackMessagesSupport;
    }

    public void renderVerificationCompletedForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws AuthnAdapterException {
        HashMap<String, Object> params = new HashMap<String, Object>(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneVerifyAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("continueAuthentication", "continueAuthentication");
        try {
            TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.completedTemplate, params);
        }
        catch (TemplateRendererUtilException e) {
            throw new AuthnAdapterException((Throwable)e);
        }
    }

    public void renderVerificationFailedForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String txid, List<String> verifyResponseError, String errJson) throws AuthnAdapterException {
        HashMap<String, Object> params = new HashMap<String, Object>(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneVerifyAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("cancelAuthentication", "cancelAuthentication");
        params.put("retryVerification", "retryVerification");
        params.put("id", txid);
        String error = this.languagePackMessagesSupport.getErrorMessage(req, verifyResponseError);
        if (error != null) {
            params.put("errorMessage", error);
        }
        if (errJson != null) {
            params.put("errJson", errJson);
        }
        try {
            TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.failedTemplate, params);
        }
        catch (TemplateRendererUtilException e) {
            throw new AuthnAdapterException((Throwable)e);
        }
    }

    public void renderVerificationRequiredForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, VerifyResponseWrapper verifyResponse, String newTab) throws AuthnAdapterException {
        HashMap<String, Object> params = new HashMap<String, Object>(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneVerifyAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("qrCode", verifyResponse.getQrUrl());
        params.put("verificationCode", verifyResponse.getVerificationCode());
        params.put("cancelAuthentication", "cancelAuthentication");
        params.put("retryVerification", "retryVerification");
        params.put("pollStatus", "pollStatus");
        params.put("transactionStatus", verifyResponse.getTransactionStatus());
        params.put("webVerificationUrl", verifyResponse.getWebVerificationUrl());
        params.put("newTab", newTab);
        try {
            TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.requiredTemplate, params);
        }
        catch (TemplateRendererUtilException e) {
            throw new AuthnAdapterException((Throwable)e);
        }
    }

    public void renderTimedOutForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws AuthnAdapterException {
        HashMap<String, Object> params = new HashMap<String, Object>(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneVerifyAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("cancelAuthentication", "cancelAuthentication");
        params.put("retryVerification", "retryVerification");
        try {
            TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.timedOutTemplate, params);
        }
        catch (TemplateRendererUtilException e) {
            throw new AuthnAdapterException((Throwable)e);
        }
    }

    public void renderVerificationOptionsForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, VerifyResponseWrapper verifyResponse, String[][] emails, String[][] phones, String errorMessage, boolean forcePolicy) throws AuthnAdapterException {
        HashMap<String, Object> params = new HashMap<String, Object>(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneVerifyAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("cancelAuthentication", "cancelAuthentication");
        params.put("retryVerification", "retryVerification");
        params.put("optionsAuthentication", "optionsAuthentication");
        params.put("emails", emails);
        params.put("phones", phones);
        params.put("email", "email");
        params.put("phone", "phone");
        params.put("errorMessage", errorMessage);
        params.put("forcePolicy", forcePolicy);
        try {
            TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.optionsTemplate, params);
        }
        catch (TemplateRendererUtilException e) {
            throw new AuthnAdapterException((Throwable)e);
        }
    }

    public void renderVerificationDeviceForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws AuthnAdapterException {
        HashMap<String, Object> params = new HashMap<String, Object>(inParameters);
        LanguagePackMessages languagePackMessages = this.languagePackMessagesSupport.getPingOneVerifyAdapterMessages(req);
        params.put("languagePackMessages", languagePackMessages);
        params.put("resumePath", inParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.put("cancelAuthentication", "cancelAuthentication");
        params.put("deviceAuthentication", "deviceAuthentication");
        try {
            TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)this.deviceTemplate, params);
        }
        catch (TemplateRendererUtilException e) {
            throw new AuthnAdapterException((Throwable)e);
        }
    }
}

