/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.authn.api;

import com.pingidentity.adapters.pingone.verify.api.model.CustomAuthnErrorDetail;
import com.pingidentity.adapters.pingone.verify.api.model.VerifyResponseWrapper;
import com.pingidentity.adapters.pingone.verify.authn.api.ActionSpec;
import com.pingidentity.adapters.pingone.verify.authn.api.IdVerificationCompleted;
import com.pingidentity.adapters.pingone.verify.authn.api.IdVerificationDevice;
import com.pingidentity.adapters.pingone.verify.authn.api.IdVerificationFailed;
import com.pingidentity.adapters.pingone.verify.authn.api.IdVerificationInProgress;
import com.pingidentity.adapters.pingone.verify.authn.api.IdVerificationOptions;
import com.pingidentity.adapters.pingone.verify.authn.api.IdVerificationRequired;
import com.pingidentity.adapters.pingone.verify.authn.api.IdVerificationTimedOut;
import com.pingidentity.adapters.pingone.verify.authn.api.StateSpec;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PingOneVerifyAuthnApiSupport {
    private static final Map<String, AuthnStateSpec<?>> STATE_SPEC_MAP = new LinkedHashMap();
    private final AuthnApiSupport authnApiSupport;

    public PingOneVerifyAuthnApiSupport(AuthnApiSupport authnApiSupport) {
        this.authnApiSupport = authnApiSupport;
    }

    public boolean isValidPingOneVerifyAdapterAuthnApiPost(HttpServletRequest req, HttpServletResponse resp, String state) throws IOException {
        return this.authnApiSupport.isValidAuthnApiPostRequest(req, resp, this.getExpectedActionIdToModelMapping(state));
    }

    public static List<AuthnStateSpec<?>> getAuthnStateSpecs() {
        return new ArrayList(STATE_SPEC_MAP.values());
    }

    public boolean isRetryVerification(HttpServletRequest req) {
        return ActionSpec.RETRY_VERIFICATION.isRequested(req);
    }

    public boolean isPollRequest(HttpServletRequest req) {
        return ActionSpec.POLL.isRequested(req);
    }

    public boolean isContinueAuthenticationRequest(HttpServletRequest req) {
        return CommonActionSpec.CONTINUE_AUTHENTICATION.isRequested(req);
    }

    public boolean isCancelAuthenticationRequest(HttpServletRequest req) {
        return CommonActionSpec.CANCEL_AUTHENTICATION.isRequested(req);
    }

    public boolean isDeviceAuthenticationRequest(HttpServletRequest req) {
        return ActionSpec.DEVICE_AUTHENTICATION.isRequested(req);
    }

    public boolean isOptionsAuthenticationRequest(HttpServletRequest req) {
        return ActionSpec.OPTIONS_AUTHENTICATION.isRequested(req);
    }

    public void writeIdvVerificationCompletedResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IdVerificationCompleted model = new IdVerificationCompleted();
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.ID_VERIFICATION_COMPLETED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeIdvVerificationFailedResponse(HttpServletRequest req, HttpServletResponse resp, List<CustomAuthnErrorDetail> errorMessages, String txid, String errjson) throws IOException {
        IdVerificationFailed model = new IdVerificationFailed();
        model.setTxId(txid);
        model.setErrJson(errjson);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.ID_VERIFICATION_FAILED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeIdvVerificationInProgressResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IdVerificationInProgress model = new IdVerificationInProgress();
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.ID_VERIFICATION_IN_PROGRESS, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeIdvVerificationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, VerifyResponseWrapper response, String newTab, List<CustomAuthnErrorDetail> errorMessages, String errjson) throws IOException {
        IdVerificationRequired model = new IdVerificationRequired();
        model.setQrUrl(response.getQrUrl());
        model.setVerificationCode(response.getVerificationCode());
        model.setTxStatus(response.getTransactionStatus());
        model.setNewTab(newTab);
        model.setWebVerificationUrl(response.getWebVerificationUrl());
        if (errjson != null) {
            model.setErrJson(errjson);
        }
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.ID_VERIFICATION_REQUIRED, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeIdvVerificationTimedOutResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IdVerificationTimedOut model = new IdVerificationTimedOut();
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.ID_VERIFICATION_TIMED_OUT, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeIdvVerificationDeviceResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IdVerificationDevice model = new IdVerificationDevice();
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.ID_VERIFICATION_DEVICE, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    public void writeIdvVerificationOptionsResponse(HttpServletRequest req, HttpServletResponse resp, String[][] emails, String[][] phones, String errorMessage, boolean forcePolicy) throws IOException {
        IdVerificationOptions model = new IdVerificationOptions();
        model.setEmails(emails);
        model.setPhones(phones);
        model.setErrorMessage(errorMessage);
        model.setForcePolicy(forcePolicy);
        AuthnState authnState = this.authnApiSupport.makeAuthnState(req, StateSpec.ID_VERIFICATION_OPTIONS, (Object)model);
        this.authnApiSupport.writeAuthnStateResponse(req, resp, authnState);
    }

    private Map<String, Class<?>> getExpectedActionIdToModelMapping(String status) {
        HashMap actionIdToModelMapping = new HashMap();
        AuthnStateSpec<?> authnStateSpec = STATE_SPEC_MAP.get(status);
        authnStateSpec.getActions().forEach(action -> actionIdToModelMapping.put(action.getId(), action.getModelClass()));
        return actionIdToModelMapping;
    }

    static {
        STATE_SPEC_MAP.put(StateSpec.ID_VERIFICATION_COMPLETED.getStatus(), StateSpec.ID_VERIFICATION_COMPLETED);
        STATE_SPEC_MAP.put(StateSpec.ID_VERIFICATION_FAILED.getStatus(), StateSpec.ID_VERIFICATION_FAILED);
        STATE_SPEC_MAP.put(StateSpec.ID_VERIFICATION_IN_PROGRESS.getStatus(), StateSpec.ID_VERIFICATION_IN_PROGRESS);
        STATE_SPEC_MAP.put(StateSpec.ID_VERIFICATION_REQUIRED.getStatus(), StateSpec.ID_VERIFICATION_REQUIRED);
        STATE_SPEC_MAP.put(StateSpec.ID_VERIFICATION_TIMED_OUT.getStatus(), StateSpec.ID_VERIFICATION_TIMED_OUT);
        STATE_SPEC_MAP.put(StateSpec.ID_VERIFICATION_DEVICE.getStatus(), StateSpec.ID_VERIFICATION_DEVICE);
        STATE_SPEC_MAP.put(StateSpec.ID_VERIFICATION_OPTIONS.getStatus(), StateSpec.ID_VERIFICATION_OPTIONS);
    }
}

