/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.config;

import com.pingidentity.adapters.pingone.verify.CustomLogEvent;
import com.pingidentity.adapters.pingone.verify.config.PopulationsHelper;
import com.pingidentity.adapters.pingone.verify.config.PopulationsPreRenderCallback;
import com.pingidentity.adapters.pingone.verify.config.Region;
import com.pingidentity.adapters.pingone.verify.config.TestConnection;
import com.pingidentity.adapters.pingone.verify.config.UiConfig;
import com.pingidentity.adapters.pingone.verify.config.VerifyPoliciesHelper;
import com.pingidentity.adapters.pingone.verify.config.VerifyPoliciesPreRenderCallback;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.util.JsonPointerValidator;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.verify.validator.ProvisionValidator;
import com.pingidentity.adapters.pingone.verify.validator.ProxyConfigurationValidator;
import com.pingidentity.adapters.pingone.verify.validator.RedirectValidator;
import com.pingidentity.adapters.pingone.verify.validator.TableUniqueKeyValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.HttpsURLValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.StringLengthValidator;

public class AdapterConfiguration {
    private static boolean supportsPingOneEnvironmentFieldDescriptor;
    private static final int MINIMUM_STATE_TIMEOUT_IN_SEC = 60;
    static FieldValidator required;

    public static AdapterConfigurationGuiDescriptor makeAdapterConfigurationGuiDescription(Configuration configuration) {
        AdapterConfigurationGuiDescriptor adapterConf = new AdapterConfigurationGuiDescriptor();
        adapterConf.setDescription(UiConfig.ADAPTER.desc);
        adapterConf.addTable((TableDescriptor)new OptionalAttributesTable());
        if (supportsPingOneEnvironmentFieldDescriptor) {
            adapterConf.addField(PingOneEnvironmentField.newPingOneEnvironmentField());
            if (configuration == null || PingOneEnvironmentField.isConfigured(configuration)) {
                FieldDescriptor pingOnePopulationsField = PingOnePopulationsField.newPingOnePopulationsField(configuration, Collections.singletonList(SelectFieldDescriptor.SELECT_ONE));
                pingOnePopulationsField.addValidator(AdapterConfiguration::rateLimitExceededValidator);
                adapterConf.addField(pingOnePopulationsField);
                adapterConf.addPreRenderCallback((PreRenderCallback)new PopulationsPreRenderCallback());
                FieldDescriptor verifyPolicyField = VerifyPolicyField.newVerifyPolicyField(configuration, Collections.singletonList(new AbstractSelectionFieldDescriptor.OptionValue("Default", null)));
                verifyPolicyField.addValidator(AdapterConfiguration::verifyPolicyValidator);
                adapterConf.addField(verifyPolicyField);
                adapterConf.addPreRenderCallback((PreRenderCallback)new VerifyPoliciesPreRenderCallback());
                adapterConf.addField((FieldDescriptor)new CustomHiddenTextField(UiConfig.HIDDEN_ENV_ID, new FieldValidator[0]));
                adapterConf.addField((FieldDescriptor)RegionFieldDescriptor.hiddenInstance());
                adapterConf.addField((FieldDescriptor)new CustomHiddenTextField(UiConfig.HIDDEN_CLIENT_ID, new FieldValidator[0]));
                adapterConf.addField((FieldDescriptor)new CustomHiddenTextField(UiConfig.HIDDEN_CLIENT_SECRET, true, new FieldValidator[0]));
                adapterConf.addField((FieldDescriptor)new CustomHiddenTextField(UiConfig.HIDDEN_POP_ID, new FieldValidator[0]));
                adapterConf.addField((FieldDescriptor)new CustomHiddenTextField(UiConfig.HIDDEN_POLICY_ID, new FieldValidator[0]));
            }
        }
        if (!supportsPingOneEnvironmentFieldDescriptor || configuration != null && !PingOneEnvironmentField.isConfigured(configuration)) {
            adapterConf.addField((FieldDescriptor)new CustomTextField(UiConfig.ENV_ID, required));
            adapterConf.addField((FieldDescriptor)new RegionFieldDescriptor());
            adapterConf.addField((FieldDescriptor)new CustomTextField(UiConfig.CLIENT_ID, required));
            adapterConf.addField((FieldDescriptor)new CustomTextField(UiConfig.CLIENT_SECRET, true, required));
            adapterConf.addField((FieldDescriptor)new CustomTextField(UiConfig.POP_ID, new FieldValidator[0]));
            adapterConf.addField((FieldDescriptor)new CustomTextField(UiConfig.POLICY_ID, new FieldValidator[0]));
        }
        CustomTextField emailFD = new CustomTextField(UiConfig.EMAIL_ATTR_NAME, new FieldValidator[0]);
        CustomTextField phoneFD = new CustomTextField(UiConfig.PHONE_ATTR_NAME, new FieldValidator[0]);
        CustomTextField selfieFD = new CustomTextField(UiConfig.SELFIE_ATTR_NAME, new FieldValidator[0]);
        CustomRadioField deliveryMethodFD = new CustomRadioField(UiConfig.DELIVERY_METHOD, "User Selection", "Force Email Notification Only", "Force Phone Notification Only");
        emailFD.setDefaultForLegacyConfig(emailFD.getDefaultValue());
        phoneFD.setDefaultForLegacyConfig(phoneFD.getDefaultValue());
        selfieFD.setDefaultForLegacyConfig(selfieFD.getDefaultValue());
        deliveryMethodFD.setDefaultForLegacyConfig(deliveryMethodFD.getDefaultValue());
        adapterConf.addField((FieldDescriptor)emailFD);
        adapterConf.addField((FieldDescriptor)phoneFD);
        adapterConf.addField((FieldDescriptor)selfieFD);
        adapterConf.addField((FieldDescriptor)deliveryMethodFD);
        CustomTextField redirectUrlField = new CustomTextField(UiConfig.REDIRECT_URL, new FieldValidator[0]);
        redirectUrlField.addValidator((FieldValidator)new HttpsURLValidator(), true);
        CustomTextField redirectMessageField = new CustomTextField(UiConfig.REDIRECT_MESSAGE, new FieldValidator[0]);
        redirectMessageField.addValidator((FieldValidator)new StringLengthValidator(256), true);
        adapterConf.addField((FieldDescriptor)redirectUrlField);
        adapterConf.addField((FieldDescriptor)redirectMessageField);
        adapterConf.addValidator((ConfigurationValidator)new RedirectValidator());
        for (UiConfig uiConfig : UiConfig.BIOGRAPHIC_UI_CONFIGS) {
            CustomTextField biographicField = new CustomTextField(uiConfig, new FieldValidator[0]);
            adapterConf.addField((FieldDescriptor)biographicField);
        }
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(UiConfig.TEST_USERNAME, new FieldValidator[0]));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(UiConfig.HTML_TEMPLATE, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(UiConfig.MESSAGE_PROPERTIES, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(UiConfig.ERROR_MESSAGE_KEY_PREFIX, required));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomCheckBoxField(UiConfig.PROVISION_USER));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomCheckBoxField(UiConfig.VERIFICATION_RETRY));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomCheckBoxField(UiConfig.VERIFICATION_RESET));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomRadioField(UiConfig.USER_NOT_FOUND_FAILURE_MODE, "Block user", "Bypass authentication"));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomRadioField(UiConfig.SERVICE_UNAVAILABLE_FAILURE_MODE, "Block user", "Bypass authentication"));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomCheckBoxField(UiConfig.SUCCESS_SCREENS));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomCheckBoxField(UiConfig.FAILED_SCREENS));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomCheckBoxField(UiConfig.TIMEOUT_SCREENS));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(UiConfig.STATE_TIMEOUT, new FieldValidator[]{required, new IntegerValidator(60, Integer.MAX_VALUE)}));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(UiConfig.API_REQUEST_TIMEOUT, new FieldValidator[]{required, new IntegerValidator(0, Integer.MAX_VALUE)}));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomRadioField(UiConfig.PROXY_SETTINGS, "No Proxy", "System Defaults", "Custom"));
        adapterConf.addAdvancedField((FieldDescriptor)new CustomTextField(UiConfig.PROXY_HOST, new FieldValidator[0]));
        CustomTextField proxyPortField = new CustomTextField(UiConfig.PROXY_PORT, new FieldValidator[0]);
        proxyPortField.addValidator((FieldValidator)new IntegerValidator(1, 65535), true);
        adapterConf.addAdvancedField((FieldDescriptor)proxyPortField);
        adapterConf.addValidator((ConfigurationValidator)new ProxyConfigurationValidator());
        adapterConf.addValidator((ConfigurationValidator)new ProvisionValidator());
        adapterConf.addValidator(conf -> {
            if (PingOneEnvironmentField.isConfigured(conf)) {
                try {
                    Class<?> pingOneEnvironmentValidatorClass = Class.forName("org.sourceid.saml20.adapter.gui.validation.impl.PingOneEnvironmentValidator");
                    Constructor<?> pingOneEnvironmentValidatorConstructor = pingOneEnvironmentValidatorClass.getConstructor(new Class[0]);
                    Object pingOneEnvironmentValidator = pingOneEnvironmentValidatorConstructor.newInstance(new Object[0]);
                    Method addValidatorMethod = pingOneEnvironmentValidatorClass.getMethod("validate", Field.class);
                    addValidatorMethod.invoke(pingOneEnvironmentValidator, conf.getField(UiConfig.PINGONE_ENV.field));
                    return;
                }
                catch (InvocationTargetException e) {
                    if (!(e.getTargetException() instanceof ValidationException)) return;
                    throw (ValidationException)e.getTargetException();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException reflectiveOperationException) {
                    return;
                }
            } else {
                if (!PingOneEnvironmentField.isConfigured(configuration) && AdapterConfiguration.legacyPingOneFieldsAreConfigured(conf)) return;
                throw new ValidationException("'" + UiConfig.PINGONE_ENV.field + "' is required.");
            }
        });
        adapterConf.addValidator(conf -> {
            String phoneAttrName;
            String deliveryMethod = AdapterConfiguration.getStringValue(conf, UiConfig.DELIVERY_METHOD);
            if (deliveryMethod.equals("Force Email Notification Only")) {
                String emailAttrName = AdapterConfiguration.getStringValue(conf, UiConfig.EMAIL_ATTR_NAME);
                if (StringUtils.isBlank(emailAttrName)) {
                    throw new ValidationException("Email chained attribute can not be blank when verification URL delivery method is 'Force Email Notification Only'");
                }
            } else if (deliveryMethod.equals("Force Phone Notification Only") && StringUtils.isBlank(phoneAttrName = AdapterConfiguration.getStringValue(conf, UiConfig.PHONE_ATTR_NAME))) {
                throw new ValidationException("Phone chained attribute can not be blank when verification URL delivery method is 'Force Phone Notification Only'");
            }
        });
        adapterConf.addAction(new ActionDescriptor(UiConfig.TEST_CONNECTION.field, UiConfig.TEST_CONNECTION.desc, (ActionDescriptor.Action)new TestConnection()));
        return adapterConf;
    }

    private static void rateLimitExceededValidator(Field field) throws ValidationException {
        if (CustomLogEvent.RATE_LIMIT_EXCEEDED.getMessage().equals(field.getValue())) {
            throw new ValidationException(field.getName() + ": " + "A request failed because the number of requests has exceeded the rate limit. Retry later.");
        }
    }

    private static void verifyPolicyValidator(Field field) throws ValidationException {
        if ("Verify Policies not found in Environment".equals(field.getValue())) {
            throw new ValidationException(field.getName() + ": " + "Verify Policies not found in Environment");
        }
        AdapterConfiguration.rateLimitExceededValidator(field);
    }

    public static boolean containsField(AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor, String fieldName) {
        return adapterConfigurationGuiDescriptor.getFields().stream().anyMatch(it -> fieldName.equals(it.getName()));
    }

    public static FieldDescriptor getField(AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor, String name) {
        return adapterConfigurationGuiDescriptor.getFields().stream().filter(it -> name.equals(it.getName())).findFirst().orElse(null);
    }

    public static boolean legacyPingOneFieldsAreConfigured(Configuration configuration) {
        return CustomTextField.isConfigured(configuration, UiConfig.ENV_ID) && RegionFieldDescriptor.isConfigured(configuration) && CustomTextField.isConfigured(configuration, UiConfig.CLIENT_ID) && CustomTextField.isConfigured(configuration, UiConfig.CLIENT_SECRET) && CustomTextField.isConfigured(configuration, UiConfig.POP_ID) && CustomTextField.isConfigured(configuration, UiConfig.POLICY_ID);
    }

    public static String getStringValue(Configuration configuration, UiConfig config) {
        String value = configuration.getFieldValue(config.field);
        return value != null ? value.trim() : null;
    }

    public static String getStringValueForNewField(Configuration configuration, UiConfig config) {
        String value = configuration.getFieldValue(config.field);
        return value != null ? value.trim() : config.defaultValue;
    }

    public static int getIntValue(Configuration configuration, UiConfig config) {
        return configuration.getIntFieldValue(config.field);
    }

    public static boolean getBooleanValue(Configuration configuration, UiConfig config) {
        return configuration.getBooleanFieldValue(config.field);
    }

    static {
        try {
            Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
            supportsPingOneEnvironmentFieldDescriptor = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPingOneEnvironmentFieldDescriptor = false;
        }
        required = new RequiredFieldValidator();
    }

    private static class RegionFieldDescriptor
    extends SelectFieldDescriptor {
        private static final List<AbstractSelectionFieldDescriptor.OptionValue> OPTION_VALUES = Arrays.stream(Region.values()).map(region -> new AbstractSelectionFieldDescriptor.OptionValue(region.getName(), region.getValue())).collect(Collectors.toList());

        public RegionFieldDescriptor() {
            super(UiConfig.REGION.field, UiConfig.REGION.desc, OPTION_VALUES);
            this.setDefaultValue(UiConfig.REGION.defaultValue);
        }

        public static SelectFieldDescriptor hiddenInstance() {
            SelectFieldDescriptor regionField = new SelectFieldDescriptor(UiConfig.HIDDEN_REGION.field, UiConfig.HIDDEN_REGION.desc, OPTION_VALUES);
            regionField.setHidden(true);
            return regionField;
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotBlank(AdapterConfiguration.getStringValue(configuration, UiConfig.REGION));
        }
    }

    public static class CustomCheckBoxField
    extends CheckBoxFieldDescriptor {
        public CustomCheckBoxField(UiConfig config) {
            super(config.field, config.desc);
            this.setDefaultValue(Boolean.parseBoolean(config.defaultValue));
        }
    }

    public static class CustomRadioField
    extends RadioGroupFieldDescriptor {
        public CustomRadioField(UiConfig config, String ... args) {
            super(config.field, config.desc, args);
            this.setDefaultValue(config.defaultValue);
        }
    }

    public static class CustomHiddenTextField
    extends CustomTextField {
        public CustomHiddenTextField(UiConfig config, FieldValidator ... listOfValidator) {
            super(config, listOfValidator);
            this.setHidden(true);
        }

        public CustomHiddenTextField(UiConfig config, boolean masked, FieldValidator ... listOfValidator) {
            super(config, masked, listOfValidator);
            this.setHidden(true);
        }
    }

    public static class CustomTextField
    extends TextFieldDescriptor {
        public CustomTextField(UiConfig config, FieldValidator ... listOfValidator) {
            super(config.field, config.desc);
            this.setDefaultValue(config.defaultValue);
            if (listOfValidator.length != 0) {
                for (FieldValidator validator : listOfValidator) {
                    this.addValidator(validator);
                }
            }
        }

        public CustomTextField(UiConfig config, boolean masked, FieldValidator ... listOfValidator) {
            super(config.field, config.desc, masked);
            if (listOfValidator.length != 0) {
                for (FieldValidator validator : listOfValidator) {
                    this.addValidator(validator);
                }
            }
        }

        public static String getValue(Configuration configuration, UiConfig config) {
            String value = configuration.getFieldValue(config.field);
            return value != null ? value.trim() : null;
        }

        public static boolean isConfigured(Configuration configuration, UiConfig config) {
            return configuration != null && StringUtils.isNotBlank(CustomTextField.getValue(configuration, config));
        }
    }

    public static class VerifyPolicyField {
        public static FieldDescriptor newVerifyPolicyField(Configuration configuration, List<AbstractSelectionFieldDescriptor.OptionValue> optionValues) {
            String defaultValue = null;
            if (configuration != null) {
                VerifyPoliciesHelper verifyPoliciesHelper;
                String legacyPolicyId = AdapterConfiguration.getStringValue(configuration, UiConfig.POLICY_ID);
                if (PingOneEnvironmentField.isConfigured(configuration) && !VerifyPolicyField.isVerifyPolicySelectConfigured(configuration) && StringUtils.isNotEmpty(legacyPolicyId) && (optionValues = (verifyPoliciesHelper = new VerifyPoliciesHelper()).getVerifyPolicies(configuration)).stream().anyMatch(it -> legacyPolicyId.equals(it.getValue()))) {
                    defaultValue = legacyPolicyId;
                }
            }
            SelectFieldDescriptor verifyPolicyField = new SelectFieldDescriptor(UiConfig.VERIFY_POLICY.field, UiConfig.VERIFY_POLICY.desc, optionValues);
            verifyPolicyField.setDefaultValue(defaultValue);
            verifyPolicyField.setDefaultForLegacyConfig(defaultValue);
            return verifyPolicyField;
        }

        public static boolean isVerifyPolicySelectConfigured(Configuration conf) {
            if (conf != null) {
                return StringUtils.isNotBlank(AdapterConfiguration.getStringValue(conf, UiConfig.VERIFY_POLICY));
            }
            return false;
        }

        public static String getVerifyPolicy(Configuration configuration) {
            String policySelectField = AdapterConfiguration.getStringValue(configuration, UiConfig.VERIFY_POLICY);
            return policySelectField != null ? policySelectField : AdapterConfiguration.getStringValue(configuration, UiConfig.POLICY_ID);
        }
    }

    public static class PingOnePopulationsField {
        public static FieldDescriptor newPingOnePopulationsField(Configuration configuration, List<AbstractSelectionFieldDescriptor.OptionValue> optionValues) {
            String defaultValue = SelectFieldDescriptor.SELECT_ONE.getValue();
            if (configuration != null) {
                PopulationsHelper populationsHelper;
                String legacyPopulationId = AdapterConfiguration.getStringValue(configuration, UiConfig.POP_ID);
                if (PingOneEnvironmentField.isConfigured(configuration) && !PingOnePopulationsField.isPopulationSelectConfigured(configuration) && StringUtils.isNotEmpty(legacyPopulationId) && (optionValues = (populationsHelper = new PopulationsHelper()).getPopulations(configuration)).stream().anyMatch(it -> legacyPopulationId.equals(it.getValue()))) {
                    defaultValue = legacyPopulationId;
                }
            }
            SelectFieldDescriptor populationField = new SelectFieldDescriptor(UiConfig.PINGONE_POPULATION.field, UiConfig.PINGONE_POPULATION.desc, optionValues);
            populationField.setDefaultValue(defaultValue);
            populationField.setDefaultForLegacyConfig(defaultValue);
            return populationField;
        }

        public static boolean isPopulationSelectConfigured(Configuration conf) {
            if (conf != null) {
                return StringUtils.isNotBlank(AdapterConfiguration.getStringValue(conf, UiConfig.PINGONE_POPULATION));
            }
            return false;
        }

        public static String getPingOnePopulation(Configuration configuration) {
            String populationSelectField = AdapterConfiguration.getStringValue(configuration, UiConfig.PINGONE_POPULATION);
            return populationSelectField != null ? populationSelectField : AdapterConfiguration.getStringValue(configuration, UiConfig.POP_ID);
        }
    }

    public static class PingOneEnvironmentField {
        public static FieldDescriptor newPingOneEnvironmentField() {
            try {
                Class<?> pingOneEnvironmentFieldClass = Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
                Constructor<?> pingOneEnvironmentFieldConstructor = pingOneEnvironmentFieldClass.getConstructor(String.class, String.class);
                return (FieldDescriptor)pingOneEnvironmentFieldConstructor.newInstance(UiConfig.PINGONE_ENV.field, UiConfig.PINGONE_ENV.desc);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String getPingOneEnvironment(Configuration configuration) {
            return configuration.getFieldValue(UiConfig.PINGONE_ENV.field);
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotEmpty(AdapterConfiguration.getStringValue(configuration, UiConfig.PINGONE_ENV));
        }
    }

    public static class OptionalAttributesTable
    extends TableDescriptor {
        private static final List<FieldDescriptor> ROW = Arrays.asList(new FieldDescriptor[]{new CustomTextField(UiConfig.LOCAL_ATTR, new FieldValidator[]{new RequiredFieldValidator()}), new CustomTextField(UiConfig.VERIFY_ATTR, new JsonPointerValidator())});

        private OptionalAttributesTable() {
            super(UiConfig.OPTIONAL_ATTR_TABLE.field, UiConfig.OPTIONAL_ATTR_TABLE.desc, ROW);
            this.addValidator((RowValidator)new TableUniqueKeyValidator(UiConfig.OPTIONAL_ATTR_TABLE.field, UiConfig.LOCAL_ATTR.field));
        }

        public static Map<String, String> getOptionalAttributes(Configuration configuration) {
            Table optionalAttributesTable = configuration.getTable(UiConfig.OPTIONAL_ATTR_TABLE.field);
            if (optionalAttributesTable != null) {
                return optionalAttributesTable.getRows().stream().collect(Collectors.toMap(OptionalAttributesTable::getLocalAttribute, OptionalAttributesTable::getRemoteAttribute));
            }
            return new HashMap<String, String>();
        }

        private static String getLocalAttribute(Row row) {
            return row.getFieldValue(UiConfig.LOCAL_ATTR.field);
        }

        private static String getRemoteAttribute(Row row) {
            return row.getFieldValue(UiConfig.VERIFY_ATTR.field);
        }
    }
}

