/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.config;

import com.pingidentity.adapters.pingone.verify.config.AdapterConfiguration;
import com.pingidentity.adapters.pingone.verify.config.PopulationsHelper;
import com.pingidentity.adapters.pingone.verify.config.UiConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;

public class PopulationsPreRenderCallback
implements PreRenderCallback {
    public void callback(List<FieldDescriptor> fields, List<FieldDescriptor> advancedFields, List<TableDescriptor> tables, Configuration config) {
        if (AdapterConfiguration.PingOneEnvironmentField.isConfigured(config) && this.isValidPingOneEnvironment(config)) {
            PopulationsHelper populationsHelper = new PopulationsHelper();
            List<AbstractSelectionFieldDescriptor.OptionValue> optionValues = populationsHelper.getPopulations(config);
            Optional<FieldDescriptor> populationField = this.getPopulationField(fields);
            populationField.ifPresent(fieldDescriptor -> ((SelectFieldDescriptor)fieldDescriptor).setOptionValues(optionValues));
        }
    }

    private Optional<FieldDescriptor> getPopulationField(List<FieldDescriptor> fields) {
        return fields.stream().filter(it -> UiConfig.PINGONE_POPULATION.field.equals(it.getName())).findFirst();
    }

    private boolean isValidPingOneEnvironment(Configuration configuration) {
        try {
            Class<?> pingOneEnvironmentValidatorClass = Class.forName("org.sourceid.saml20.adapter.gui.validation.impl.PingOneEnvironmentValidator");
            Constructor<?> pingOneEnvironmentValidatorConstructor = pingOneEnvironmentValidatorClass.getConstructor(new Class[0]);
            Object pingOneEnvironmentValidator = pingOneEnvironmentValidatorConstructor.newInstance(new Object[0]);
            Method validateMethod = pingOneEnvironmentValidatorClass.getMethod("validate", Field.class);
            validateMethod.invoke(pingOneEnvironmentValidator, configuration.getField(UiConfig.PINGONE_ENV.field));
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }
}

