/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.config;

import com.pingidentity.adapters.pingone.verify.ReflectivePingOneEnvironmentAccessor;
import com.pingidentity.adapters.pingone.verify.api.ApiClient;
import com.pingidentity.adapters.pingone.verify.api.AuthClient;
import com.pingidentity.adapters.pingone.verify.api.CustomHttpClientFactory;
import com.pingidentity.adapters.pingone.verify.api.TokenService;
import com.pingidentity.adapters.pingone.verify.api.model.VerifyResponseWrapper;
import com.pingidentity.adapters.pingone.verify.config.AdapterConfiguration;
import com.pingidentity.adapters.pingone.verify.config.Region;
import com.pingidentity.adapters.pingone.verify.config.UiConfig;
import com.pingidentity.adapters.pingone.verify.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.verify.exception.ApiException;
import com.pingidentity.adapters.pingone.verify.exception.InvalidUserException;
import com.pingidentity.adapters.pingone.verify.exception.LimitExceededException;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpRequestBuilder;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpResponseBuilder;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpService;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpServiceFactory;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;

public class TestConnection
implements ActionDescriptor.Action {
    public String actionInvoked(Configuration configuration) {
        String token;
        String clientId;
        AuthClient authClient;
        String apiEndpoint;
        String envId;
        ReflectivePingOneEnvironmentAccessor pingOneEnvironmentAccessor;
        String pingOneEnvironment;
        String testUserId = AdapterConfiguration.getStringValue(configuration, UiConfig.TEST_USERNAME);
        int requestTimeoutInt = AdapterConfiguration.getIntValue(configuration, UiConfig.API_REQUEST_TIMEOUT);
        String proxySettings = AdapterConfiguration.getStringValue(configuration, UiConfig.PROXY_SETTINGS);
        String proxyHost = AdapterConfiguration.getStringValue(configuration, UiConfig.PROXY_HOST);
        int proxyPort = AdapterConfiguration.getIntValue(configuration, UiConfig.PROXY_PORT);
        StringBuilder result = new StringBuilder();
        CustomHttpClientFactory clientFactory = new CustomHttpClientFactory().setRequestTimeout(requestTimeoutInt).setProxySettings(proxySettings).setProxyHost(proxyHost).setProxyPort(proxyPort);
        ApacheHttpService httpService = new ApacheHttpServiceFactory().make(new ApacheHttpRequestBuilder(), clientFactory, new ApacheHttpResponseBuilder());
        if (AdapterConfiguration.PingOneEnvironmentField.isConfigured(configuration)) {
            pingOneEnvironment = AdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
            pingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(pingOneEnvironment);
            envId = pingOneEnvironmentAccessor.getEnvironmentId();
            apiEndpoint = pingOneEnvironmentAccessor.getManagementEndpoint();
            authClient = null;
            clientId = null;
        } else {
            envId = AdapterConfiguration.getStringValue(configuration, UiConfig.ENV_ID);
            clientId = AdapterConfiguration.getStringValue(configuration, UiConfig.CLIENT_ID);
            String clientSecret = AdapterConfiguration.getStringValue(configuration, UiConfig.CLIENT_SECRET);
            Region region = Region.fromValue(AdapterConfiguration.getStringValue(configuration, UiConfig.REGION));
            String authEndpoint = region.getAuthEndpoint();
            apiEndpoint = region.getApiEndpoint();
            authClient = new AuthClient(httpService, authEndpoint, envId, clientId, clientSecret);
            pingOneEnvironment = null;
            pingOneEnvironmentAccessor = null;
        }
        ApiClient apiClient = new ApiClient(httpService, apiEndpoint, envId);
        TokenService tokenService = new TokenService(() -> {
            try {
                if (pingOneEnvironmentAccessor != null) {
                    return pingOneEnvironmentAccessor.getAccessToken();
                }
                return authClient.postTokenRequest();
            }
            catch (Throwable e) {
                throw new AccessTokenProviderException("Error requesting access token", e);
            }
        }, pingOneEnvironmentAccessor != null ? pingOneEnvironment : clientId);
        try {
            token = tokenService.getToken();
        }
        catch (AccessTokenProviderException e) {
            if (e.getCause() instanceof ApiException) {
                return e.getCause().getMessage();
            }
            return "Error exchanging credential for access token.";
        }
        result.append("Successfully exchanged credential for access token.\n");
        result.append("\n");
        apiClient.setToken(token);
        if (StringUtils.isBlank(testUserId)) {
            result.append("Unable to complete further testing due to empty '" + UiConfig.TEST_USERNAME.field + "' field.");
        } else {
            String userIdTrimmed = testUserId.trim();
            try {
                String userId = apiClient.getUserId(userIdTrimmed, null, false);
                VerifyResponseWrapper verifyResponse = apiClient.getIdvStatus(userId, null, null, null, null);
                String transactionStatus = verifyResponse.getTransactionStatus();
                if (transactionStatus == null) {
                    transactionStatus = "NEW USER";
                }
                result.append("Test connection to PingOne Verify succeed. " + userIdTrimmed + "'s verification status is: " + transactionStatus);
            }
            catch (InvalidUserException e) {
                result.append("Unable to confirm status of '" + UiConfig.TEST_USERNAME.field + "' provided. Please make sure '" + userIdTrimmed + "' exist in PingOne and has PingOne Verify enabled.");
                return result.toString();
            }
            catch (LimitExceededException e) {
                result.append("Test connection to PingOne Verify failed. A request failed because the number of requests has exceeded the rate limit. Retry later.");
            }
            catch (ApiException e) {
                result.append("Test connection to PingOne Verify failed. Please check if PingOne Verify is operating normally and environment is set up for PingOne Verify.");
            }
            catch (AuthnAdapterException authnAdapterException) {
                // empty catch block
            }
        }
        return result.toString();
    }
}

