/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.config;

import com.pingidentity.adapters.pingone.verify.CustomLogEvent;
import com.pingidentity.adapters.pingone.verify.ReflectivePingOneEnvironmentAccessor;
import com.pingidentity.adapters.pingone.verify.api.ApiClient;
import com.pingidentity.adapters.pingone.verify.api.CustomHttpClientFactory;
import com.pingidentity.adapters.pingone.verify.config.AdapterConfiguration;
import com.pingidentity.adapters.pingone.verify.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.verify.shade.com.google.common.cache.Cache;
import com.pingidentity.adapters.pingone.verify.shade.com.google.common.cache.CacheBuilder;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpRequestBuilder;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpResponseBuilder;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpService;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.common.http.apache5.ApacheHttpServiceFactory;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.verify.shade.com.pingidentity.integrations.logger.LogEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;

public class VerifyPoliciesHelper {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(VerifyPoliciesHelper.class);
    private static final String CACHE_KEY_PREFIX = "verifyPolicies.";
    private static final Cache<String, List<AbstractSelectionFieldDescriptor.OptionValue>> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public List<AbstractSelectionFieldDescriptor.OptionValue> getVerifyPolicies(Configuration configuration) {
        String pingOneEnvironment = AdapterConfiguration.PingOneEnvironmentField.getPingOneEnvironment(configuration);
        String cacheKey = CACHE_KEY_PREFIX + pingOneEnvironment;
        List<AbstractSelectionFieldDescriptor.OptionValue> optionValues = cache.getIfPresent(cacheKey);
        if (optionValues == null) {
            try {
                ApiClient apiClient = this.getApiClient(pingOneEnvironment);
                optionValues = apiClient.getVerifyPoliciesAsOptionValues();
                cache.put(cacheKey, optionValues);
            }
            catch (Exception e) {
                LOGGER.log((LogEvent)CustomLogEvent.VERIFY_POLICIES_CALLBACK_ERROR, e);
                optionValues = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
            }
        }
        return optionValues;
    }

    private ApiClient getApiClient(String pingOneEnvironment) throws AccessTokenProviderException {
        String accessToken;
        ReflectivePingOneEnvironmentAccessor reflectivePingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(pingOneEnvironment);
        try {
            accessToken = reflectivePingOneEnvironmentAccessor.getAccessToken();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new AccessTokenProviderException("Error requesting access token", e);
        }
        String envId = reflectivePingOneEnvironmentAccessor.getEnvironmentId();
        String apiPath = reflectivePingOneEnvironmentAccessor.getManagementEndpoint();
        CustomHttpClientFactory clientFactory = new CustomHttpClientFactory().setRequestTimeout(2000).setProxySettings("System Defaults");
        ApacheHttpService httpService = new ApacheHttpServiceFactory().make(new ApacheHttpRequestBuilder(), clientFactory, new ApacheHttpResponseBuilder());
        ApiClient apiClient = new ApiClient(httpService, apiPath, envId);
        apiClient.setToken(accessToken);
        return apiClient;
    }
}

