/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.client5.http.impl.classic;

import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.client5.http.HttpRoute;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.client5.http.impl.classic.AbstractBackoff;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.annotation.Contract;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.pool.ConnPoolControl;
import com.pingidentity.adapters.pingone.verify.shade.org.apache.hc.core5.util.Args;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public class LinearBackoffManager
extends AbstractBackoff {
    private static final Logger LOG = LoggerFactory.getLogger(LinearBackoffManager.class);
    private final int increment;
    private final ConcurrentHashMap<HttpRoute, AtomicInteger> routeAttempts;

    public LinearBackoffManager(ConnPoolControl<HttpRoute> connPoolControl) {
        this(connPoolControl, 1);
    }

    public LinearBackoffManager(ConnPoolControl<HttpRoute> connPoolControl, int increment) {
        super(connPoolControl);
        this.increment = Args.positive(increment, "Increment");
        this.routeAttempts = new ConcurrentHashMap();
    }

    @Override
    public void backOff(HttpRoute route) {
        Instant now = Instant.now();
        if (this.shouldSkip(route, now)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("BackOff not applied for route: {}, cool-down period not elapsed", (Object)route);
            }
            return;
        }
        AtomicInteger attempt = this.routeAttempts.compute(route, (r, oldValue) -> {
            if (oldValue == null) {
                return new AtomicInteger(1);
            }
            oldValue.incrementAndGet();
            return oldValue;
        });
        this.getLastRouteBackoffs().put(route, now);
        int currentMax = this.getConnPerRoute().getMaxPerRoute(route);
        this.getConnPerRoute().setMaxPerRoute(route, this.getBackedOffPoolSize(currentMax));
        attempt.incrementAndGet();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Backoff applied for route: {}, new max connections: {}", (Object)route, (Object)this.getConnPerRoute().getMaxPerRoute(route));
        }
    }

    @Override
    public void probe(HttpRoute route) {
        Instant now = Instant.now();
        if (this.shouldSkip(route, now)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probe not applied for route: {}, cool-down period not elapsed", (Object)route);
            }
            return;
        }
        this.routeAttempts.compute(route, (r, oldValue) -> {
            if (oldValue == null || oldValue.get() <= 1) {
                return null;
            }
            oldValue.decrementAndGet();
            return oldValue;
        });
        this.getLastRouteProbes().put(route, now);
        int currentMax = this.getConnPerRoute().getMaxPerRoute(route);
        int newMax = Math.max(currentMax - this.increment, this.getCap().get());
        this.getConnPerRoute().setMaxPerRoute(route, newMax);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Probe applied for route: {}, new max connections: {}", (Object)route, (Object)this.getConnPerRoute().getMaxPerRoute(route));
        }
    }

    private boolean shouldSkip(HttpRoute route, Instant now) {
        Instant lastProbe = this.getLastRouteProbes().getOrDefault(route, Instant.EPOCH);
        Instant lastBackoff = this.getLastRouteBackoffs().getOrDefault(route, Instant.EPOCH);
        return Duration.between(lastProbe, now).compareTo(this.getCoolDown().get().toDuration()) < 0 || Duration.between(lastBackoff, now).compareTo(this.getCoolDown().get().toDuration()) < 0;
    }

    @Override
    protected int getBackedOffPoolSize(int curr) {
        return curr + this.increment;
    }

    @Override
    public void setBackoffFactor(double d) {
    }
}

