/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jws;

import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jca.ProviderContext;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwa.AlgorithmInfo;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jwa.CryptoPrimitive;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.jws.JsonWebSignatureAlgorithm;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.keys.KeyPersuasion;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.lang.ByteUtil;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.lang.InvalidKeyException;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.lang.JoseException;
import com.pingidentity.adapters.pingone.verify.shade.org.jose4j.mac.MacUtil;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class HmacUsingShaAlgorithm
extends AlgorithmInfo
implements JsonWebSignatureAlgorithm {
    private int minimumKeyLength;

    public HmacUsingShaAlgorithm(String id, String javaAlgo, int minimumKeyLength) {
        this.setAlgorithmIdentifier(id);
        this.setJavaAlgorithm(javaAlgo);
        this.setKeyPersuasion(KeyPersuasion.SYMMETRIC);
        this.setKeyType("oct");
        this.minimumKeyLength = minimumKeyLength;
    }

    @Override
    public boolean verifySignature(byte[] signatureBytes, Key key, byte[] securedInputBytes, ProviderContext providerContext) throws JoseException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException(key.getClass() + " cannot be used for HMAC verification.");
        }
        Mac mac = this.getMacInstance(key, providerContext);
        byte[] calculatedSigature = mac.doFinal(securedInputBytes);
        return ByteUtil.secureEquals(signatureBytes, calculatedSigature);
    }

    @Override
    public CryptoPrimitive prepareForSign(Key key, ProviderContext providerContext) throws JoseException {
        Mac mac = this.getMacInstance(key, providerContext);
        return new CryptoPrimitive(mac);
    }

    @Override
    public byte[] sign(CryptoPrimitive cryptoPrimitive, byte[] securedInputBytes) throws JoseException {
        Mac mac = cryptoPrimitive.getMac();
        return mac.doFinal(securedInputBytes);
    }

    private Mac getMacInstance(Key key, ProviderContext providerContext) throws JoseException {
        String macProvider = providerContext.getSuppliedKeyProviderContext().getMacProvider();
        return MacUtil.getInitializedMac(this.getJavaAlgorithm(), key, macProvider);
    }

    void validateKey(Key key) throws InvalidKeyException {
        int length;
        if (key == null) {
            throw new InvalidKeyException("key is null");
        }
        if (key.getEncoded() != null && (length = ByteUtil.bitLength(key.getEncoded())) < this.minimumKeyLength) {
            throw new InvalidKeyException("A key of the same size as the hash output (i.e. " + this.minimumKeyLength + " bits for " + this.getAlgorithmIdentifier() + ") or larger MUST be used with the HMAC SHA algorithms but this key is only " + length + " bits");
        }
    }

    @Override
    public void validateSigningKey(Key key) throws InvalidKeyException {
        this.validateKey(key);
    }

    @Override
    public void validateVerificationKey(Key key) throws InvalidKeyException {
        this.validateKey(key);
    }

    @Override
    public boolean isAvailable() {
        try {
            Mac.getInstance(this.getJavaAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        return true;
    }

    public static class HmacSha512
    extends HmacUsingShaAlgorithm {
        public HmacSha512() {
            super("HS512", "HmacSHA512", 512);
        }
    }

    public static class HmacSha384
    extends HmacUsingShaAlgorithm {
        public HmacSha384() {
            super("HS384", "HmacSHA384", 384);
        }
    }

    public static class HmacSha256
    extends HmacUsingShaAlgorithm {
        public HmacSha256() {
            super("HS256", "HmacSHA256", 256);
        }
    }
}

