/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import com.pingidentity.configservice.Reloadable;
import com.pingidentity.pf.adapters.referenceid.BackchannelCreds;
import com.pingidentity.pf.adapters.referenceid.BackchannelReferenceAuthnAdapter;
import com.pingidentity.pf.adapters.referenceid.LoggerMessage;
import com.pingidentity.pf.adapters.referenceid.RequestError;
import com.pingidentity.pf.adapters.referenceid.cert.util.CertHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.AdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.ArtifactPersistenceService;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.servlet.adapter.Handler;
import shaded.refid.com.pingidentity.integrations.logger.IntegrationsLogger;
import shaded.refid.com.pingidentity.integrations.logger.LogEvent;

abstract class AbstractHandler
implements Handler,
Reloadable {
    private static final IntegrationsLogger logger = new IntegrationsLogger(AbstractHandler.class);
    private Map<String, Map<String, BackchannelReferenceAuthnAdapter>> usernameToAdapterCache;
    private Map<String, BackchannelReferenceAuthnAdapter> subjectDNToAdapterCache;
    private Map<String, BackchannelReferenceAuthnAdapter> issuerDNToAdapterCache;
    protected final ArtifactPersistenceService persistenceService = StateMgmtFactory.getArtifactPersistenceService();
    protected final AdapterManager adapterManager = MgmtFactory.getAdapterManager();
    private Map<String, Map<String, BackchannelReferenceAuthnAdapter>> instanceToAdapterCache;
    private final ReentrantLock reloadLock = new ReentrantLock();
    private boolean canReload = true;

    protected AbstractHandler() {
        this.adapterManager.registerForReloadEvents((Reloadable)this);
    }

    public void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            BackchannelReferenceAuthnAdapter adapterInstance = null;
            BackchannelCreds creds = new BackchannelCreds(req, resp);
            adapterInstance = this.lookup(creds);
            if (adapterInstance == null) {
                throw new LoginException("Invalid credentials");
            }
            if (adapterInstance.isRequireTLS() && !req.isSecure()) {
                logger.log(LoggerMessage.SSL_TLS_REQUIRED_ERROR);
                resp.sendError(400, "SSL/TLS is required.");
            } else {
                this.doHandle(req, resp, adapterInstance);
            }
        }
        catch (LoginException e) {
            int status = 401;
            if (e instanceof AccountException) {
                status = 403;
            }
            resp.setStatus(status);
            logger.log((LogEvent)LoggerMessage.AUTHN_FAILED, e);
            resp.setHeader("Content-Type", "application/json");
            resp.getWriter().write(new RequestError(status, e.getMessage()).getJson());
            resp.flushBuffer();
            return;
        }
    }

    synchronized BackchannelReferenceAuthnAdapter lookup(BackchannelCreds creds) throws LoginException {
        BackchannelReferenceAuthnAdapter adapterInstance = null;
        if (!StringUtils.isBlank((CharSequence)creds.getInstanceId())) {
            logger.log((LogEvent)LoggerMessage.INSTANCE_ID_FOUND, "ping.instanceId", "ping-instanceId", creds.getInstanceId());
            adapterInstance = this.lookupInstanceId(creds.getInstanceId());
        } else {
            if (this.isInstanceIdRequired()) {
                String errorMessage = String.format(LoggerMessage.MULTIPLE_ADAPTER_INSTANCE_ID.toString(), "ping.instanceId", "ping-instanceId");
                logger.log((LogEvent)LoggerMessage.MULTIPLE_ADAPTER_INSTANCE_ID, "ping.instanceId", "ping-instanceId");
                throw new LoginException(errorMessage);
            }
            adapterInstance = adapterInstance == null && creds.getSubjectDN() != null ? this.lookupSubjectDN(creds.getSubjectDN()) : adapterInstance;
            adapterInstance = adapterInstance == null && creds.getIssuerDN() != null ? this.lookupIssuerDN(creds.getIssuerDN()) : adapterInstance;
            BackchannelReferenceAuthnAdapter backchannelReferenceAuthnAdapter = adapterInstance = adapterInstance == null && !StringUtils.isBlank((CharSequence)creds.getUsername()) && !StringUtils.isBlank((CharSequence)creds.getPassphrase()) ? this.lookup(creds.getUsername(), creds.getPassphrase()) : adapterInstance;
        }
        if (adapterInstance != null) {
            logger.log((LogEvent)LoggerMessage.CREDENTIALS_MAPPED, adapterInstance.instanceId);
            adapterInstance.validateCreds(creds);
        }
        return adapterInstance;
    }

    synchronized BackchannelReferenceAuthnAdapter lookupInstanceId(String instanceId) throws LoginException {
        Map<String, BackchannelReferenceAuthnAdapter> map = this.getInstanceCache().get(instanceId);
        return map == null ? null : map.get(instanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Map<String, Map<String, BackchannelReferenceAuthnAdapter>> getInstanceCache() {
        this.reloadLock.lock();
        this.canReload = false;
        try {
            if (this.instanceToAdapterCache == null) {
                this.instanceToAdapterCache = new HashMap<String, Map<String, BackchannelReferenceAuthnAdapter>>();
                LinkedList instances = new LinkedList();
                instances.addAll(this.adapterManager.getIdpAuthnAdapterInstances());
                instances.addAll(this.adapterManager.getSpAuthnAdapterInstances());
                for (AuthnAdapterInstance adapterInstance : instances) {
                    String id = adapterInstance.getId();
                    boolean isIdp = adapterInstance instanceof IdpAuthnAdapterInstance;
                    Object adapter = isIdp ? this.adapterManager.getIdpAuthnAdapter(id) : this.adapterManager.getSpAuthnAdapter(id);
                    if (!(adapter instanceof BackchannelReferenceAuthnAdapter)) continue;
                    BackchannelReferenceAuthnAdapter backRefAdapter = (BackchannelReferenceAuthnAdapter)adapter;
                    Map<String, BackchannelReferenceAuthnAdapter> map = this.instanceToAdapterCache.get(id);
                    if (map == null) {
                        map = new HashMap<String, BackchannelReferenceAuthnAdapter>();
                        this.instanceToAdapterCache.put(id, map);
                    }
                    map.put(id, backRefAdapter);
                }
            }
        }
        finally {
            this.canReload = true;
            this.reloadLock.unlock();
        }
        return this.instanceToAdapterCache;
    }

    public void reload() {
        if (this.canReload && this.reloadLock.tryLock()) {
            this.usernameToAdapterCache = null;
            this.subjectDNToAdapterCache = null;
            this.issuerDNToAdapterCache = null;
            this.instanceToAdapterCache = null;
            this.reloadLock.unlock();
        }
    }

    synchronized BackchannelReferenceAuthnAdapter lookup(String username, String password) {
        Map<String, BackchannelReferenceAuthnAdapter> map = this.getCache().get(username);
        return map == null ? null : map.get(password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Map<String, Map<String, BackchannelReferenceAuthnAdapter>> getCache() {
        this.reloadLock.lock();
        this.canReload = false;
        try {
            if (this.usernameToAdapterCache == null) {
                this.usernameToAdapterCache = new HashMap<String, Map<String, BackchannelReferenceAuthnAdapter>>();
                LinkedList instances = new LinkedList();
                instances.addAll(this.adapterManager.getIdpAuthnAdapterInstances());
                instances.addAll(this.adapterManager.getSpAuthnAdapterInstances());
                for (AuthnAdapterInstance adapterInstance : instances) {
                    String id = adapterInstance.getId();
                    boolean isIdp = adapterInstance instanceof IdpAuthnAdapterInstance;
                    Object adapter = isIdp ? this.adapterManager.getIdpAuthnAdapter(id) : this.adapterManager.getSpAuthnAdapter(id);
                    if (!(adapter instanceof BackchannelReferenceAuthnAdapter)) continue;
                    BackchannelReferenceAuthnAdapter backRefAdapter = (BackchannelReferenceAuthnAdapter)adapter;
                    Configuration configuration = adapterInstance.getConfiguration();
                    String uname = configuration.getFieldValue("User Name");
                    String pwd = configuration.getFieldValue("Pass Phrase");
                    Map<String, BackchannelReferenceAuthnAdapter> map = this.usernameToAdapterCache.get(uname);
                    if (map == null) {
                        map = new HashMap<String, BackchannelReferenceAuthnAdapter>();
                        this.usernameToAdapterCache.put(uname, map);
                    }
                    map.put(pwd, backRefAdapter);
                }
            }
        }
        finally {
            this.canReload = true;
            this.reloadLock.unlock();
        }
        return this.usernameToAdapterCache;
    }

    synchronized BackchannelReferenceAuthnAdapter lookupSubjectDN(X500Principal subjectDN) {
        for (Map.Entry<String, BackchannelReferenceAuthnAdapter> entry : this.getSubjectDNCache().entrySet()) {
            if (!CertHelper.compareDN(subjectDN, CertHelper.createDNList(entry.getKey()))) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Map<String, BackchannelReferenceAuthnAdapter> getSubjectDNCache() {
        this.reloadLock.lock();
        this.canReload = false;
        try {
            if (this.subjectDNToAdapterCache == null) {
                this.subjectDNToAdapterCache = new HashMap<String, BackchannelReferenceAuthnAdapter>();
                LinkedList instances = new LinkedList();
                instances.addAll(this.adapterManager.getIdpAuthnAdapterInstances());
                instances.addAll(this.adapterManager.getSpAuthnAdapterInstances());
                for (AuthnAdapterInstance adapterInstance : instances) {
                    String id = adapterInstance.getId();
                    boolean isIdp = adapterInstance instanceof IdpAuthnAdapterInstance;
                    Object adapter = isIdp ? this.adapterManager.getIdpAuthnAdapter(id) : this.adapterManager.getSpAuthnAdapter(id);
                    if (!(adapter instanceof BackchannelReferenceAuthnAdapter)) continue;
                    BackchannelReferenceAuthnAdapter backRefAdapter = (BackchannelReferenceAuthnAdapter)adapter;
                    Configuration configuration = adapterInstance.getConfiguration();
                    String subjectDN = configuration.getFieldValue("Allowed Subject DN");
                    if (this.subjectDNToAdapterCache.get(subjectDN) != null) continue;
                    this.subjectDNToAdapterCache.put(subjectDN, backRefAdapter);
                }
            }
        }
        finally {
            this.canReload = true;
            this.reloadLock.unlock();
        }
        return this.subjectDNToAdapterCache;
    }

    synchronized BackchannelReferenceAuthnAdapter lookupIssuerDN(X500Principal issuerDN) {
        for (Map.Entry<String, BackchannelReferenceAuthnAdapter> entry : this.getIssuerDNCache().entrySet()) {
            if (!CertHelper.compareDN(issuerDN, CertHelper.createDNList(entry.getKey()))) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Map<String, BackchannelReferenceAuthnAdapter> getIssuerDNCache() {
        this.reloadLock.lock();
        this.canReload = false;
        try {
            if (this.issuerDNToAdapterCache == null) {
                this.issuerDNToAdapterCache = new HashMap<String, BackchannelReferenceAuthnAdapter>();
                LinkedList instances = new LinkedList();
                instances.addAll(this.adapterManager.getIdpAuthnAdapterInstances());
                instances.addAll(this.adapterManager.getSpAuthnAdapterInstances());
                for (AuthnAdapterInstance adapterInstance : instances) {
                    String id = adapterInstance.getId();
                    boolean isIdp = adapterInstance instanceof IdpAuthnAdapterInstance;
                    Object adapter = isIdp ? this.adapterManager.getIdpAuthnAdapter(id) : this.adapterManager.getSpAuthnAdapter(id);
                    if (!(adapter instanceof BackchannelReferenceAuthnAdapter)) continue;
                    BackchannelReferenceAuthnAdapter backRefAdapter = (BackchannelReferenceAuthnAdapter)adapter;
                    Configuration configuration = adapterInstance.getConfiguration();
                    String issuerDN = configuration.getFieldValue("Allowed Issuer DN");
                    if (this.issuerDNToAdapterCache.get(issuerDN) != null) continue;
                    this.issuerDNToAdapterCache.put(issuerDN, backRefAdapter);
                }
            }
        }
        finally {
            this.canReload = true;
            this.reloadLock.unlock();
        }
        return this.issuerDNToAdapterCache;
    }

    synchronized boolean isInstanceIdRequired() {
        int idpCount = 0;
        int spCount = 0;
        LinkedList instances = new LinkedList();
        instances.addAll(this.adapterManager.getIdpAuthnAdapterInstances());
        instances.addAll(this.adapterManager.getSpAuthnAdapterInstances());
        for (AuthnAdapterInstance adapterInstance : instances) {
            String id = adapterInstance.getId();
            boolean isIdp = adapterInstance instanceof IdpAuthnAdapterInstance;
            Object adapter = isIdp ? this.adapterManager.getIdpAuthnAdapter(id) : this.adapterManager.getSpAuthnAdapter(id);
            if (!(adapter instanceof BackchannelReferenceAuthnAdapter)) continue;
            if (isIdp) {
                ++idpCount;
                continue;
            }
            ++spCount;
        }
        return idpCount > 1 || spCount > 1;
    }

    abstract void doHandle(HttpServletRequest var1, HttpServletResponse var2, BackchannelReferenceAuthnAdapter var3) throws ServletException, IOException;
}

