/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import com.pingidentity.pf.adapters.referenceid.LogCleaner;
import com.pingidentity.pf.adapters.referenceid.LoggerMessage;
import java.security.cert.X509Certificate;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.auth.BasicAuthHelp;
import org.sourceid.auth.BasicAuthValue;
import org.sourceid.auth.BearerAuthHelp;
import shaded.refid.com.pingidentity.integrations.logger.IntegrationsLogger;
import shaded.refid.com.pingidentity.integrations.logger.LogEvent;

public class BackchannelCreds {
    private static final IntegrationsLogger logger = new IntegrationsLogger(BackchannelCreds.class);
    private String instanceId = null;
    private String username = null;
    private String passphrase = null;
    private X500Principal subjectDN = null;
    private X500Principal issuerDN = null;
    private String bearerAccessToken = null;
    private static final String UNAME_HEADER_NAME = "ping.uname";
    private static final String PWD_HEADER_NAME = "ping.pwd";
    public static final String INSTANCE_HEADER_NAME = "ping.instanceId";
    private static final String UNAME_HEADER_NAME_DASH = "ping-uname";
    private static final String PWD_HEADER_NAME_DASH = "ping-pwd";
    public static final String INSTANCE_HEADER_NAME_DASH = "ping-instanceId";
    HttpServletRequest httpServletRequest;
    HttpServletResponse httpServletResponse;

    BackchannelCreds(HttpServletRequest req, HttpServletResponse resp) throws LoginException {
        this.httpServletRequest = req;
        this.httpServletResponse = resp;
        X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        if (certs != null) {
            logger.log(LoggerMessage.ATTEMPT_CERT_AUTH);
            this.subjectDN = certs[0].getSubjectX500Principal();
            this.issuerDN = certs[0].getIssuerX500Principal();
        }
        if (req.getHeader(INSTANCE_HEADER_NAME) != null) {
            this.instanceId = req.getHeader(INSTANCE_HEADER_NAME);
        } else if (req.getHeader(INSTANCE_HEADER_NAME_DASH) != null) {
            this.instanceId = req.getHeader(INSTANCE_HEADER_NAME_DASH);
        }
        String basicAuthHeaderValue = BasicAuthHelp.getHeaderValue((HttpServletRequest)req);
        String bearerAuthHeaderValue = BearerAuthHelp.getHeaderValue((HttpServletRequest)req);
        if (!StringUtils.isEmpty((CharSequence)bearerAuthHeaderValue)) {
            this.bearerAccessToken = BearerAuthHelp.getAuthTokenFromHeaders((HttpServletRequest)req);
        }
        if (StringUtils.isEmpty((CharSequence)basicAuthHeaderValue)) {
            logger.log((LogEvent)LoggerMessage.ATTEMPT_AUTH_HEADER, UNAME_HEADER_NAME, UNAME_HEADER_NAME_DASH, PWD_HEADER_NAME, PWD_HEADER_NAME_DASH);
            if (req.getHeader(UNAME_HEADER_NAME) != null) {
                this.username = req.getHeader(UNAME_HEADER_NAME);
            } else if (req.getHeader(UNAME_HEADER_NAME_DASH) != null) {
                this.username = req.getHeader(UNAME_HEADER_NAME_DASH);
            }
            if (req.getHeader(PWD_HEADER_NAME) != null) {
                this.passphrase = req.getHeader(PWD_HEADER_NAME);
            } else if (req.getHeader(PWD_HEADER_NAME_DASH) != null) {
                this.passphrase = req.getHeader(PWD_HEADER_NAME_DASH);
            }
        } else {
            logger.log(LoggerMessage.BASIC_AUTH_PROVIDED);
            BasicAuthValue values = BasicAuthHelp.getValues((String)basicAuthHeaderValue);
            this.username = values.getUsername();
            this.passphrase = values.getPassword();
        }
        logger.log((LogEvent)LoggerMessage.USER_PASS, LogCleaner.clean(this.username), StringUtils.isBlank((CharSequence)this.passphrase) ? this.passphrase : "*****");
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public X500Principal getSubjectDN() {
        return this.subjectDN;
    }

    public X500Principal getIssuerDN() {
        return this.issuerDN;
    }

    public String getBearerAccessToken() {
        return this.bearerAccessToken;
    }
}

