/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import com.pingidentity.pf.adapters.referenceid.BackchannelCreds;
import com.pingidentity.pf.adapters.referenceid.cert.util.CertHelper;
import com.pingidentity.sdk.oauth20.AccessToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CredsValidatorUtil {
    List<X500Principal> acceptableSubjectDN = new ArrayList<X500Principal>();
    List<X500Principal> acceptableIssuerDN = new ArrayList<X500Principal>();
    String httpBasicAuthUsername = "";
    String httpBasicAuthPassphrase = "";
    String tokenManagerId = null;
    String bearerTokenValidClientIds = null;
    String bearerTokenRequiredScopes = null;
    BearerAccessTokenMgmtPluginManager tokenManagerPlugin = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();

    private CredsValidatorUtil() {
    }

    public List<X500Principal> getAcceptableSubjectDN() {
        return this.acceptableSubjectDN;
    }

    public List<X500Principal> getAcceptableIssuerDN() {
        return this.acceptableIssuerDN;
    }

    public String getHttpBasicAuthUsername() {
        return this.httpBasicAuthUsername;
    }

    public String getHttpBasicAuthPassphrase() {
        return this.httpBasicAuthPassphrase;
    }

    public String getTokenManagerId() {
        return this.tokenManagerId;
    }

    public String getBearerTokenValidClientIds() {
        return this.bearerTokenValidClientIds;
    }

    public void setBearerTokenValidClientIds(String bearerTokenValidClientIds) {
        this.bearerTokenValidClientIds = bearerTokenValidClientIds;
    }

    public String getBearerTokenRequiredScopes() {
        return this.bearerTokenRequiredScopes;
    }

    public void setBearerTokenRequiredScopes(String bearerTokenRequiredScopes) {
        this.bearerTokenRequiredScopes = bearerTokenRequiredScopes;
    }

    private void setBearerTokenValidationFailureHeader(BackchannelCreds creds, String realm, String error, String errorDescription, String scope) {
        String headerValue = "Bearer realm=\"" + realm + "\"";
        if (StringUtils.isNotBlank((CharSequence)error)) {
            headerValue = headerValue + ",\nerror=\"" + error + "\"";
        }
        if (StringUtils.isNotBlank((CharSequence)errorDescription)) {
            headerValue = headerValue + ",\nerror_description=\"" + errorDescription + "\"";
        }
        if (StringUtils.isNotBlank((CharSequence)scope)) {
            headerValue = headerValue + ",\nrequired_scope=\"" + scope + "\"";
        }
        creds.getHttpServletResponse().setHeader("WWW-Authenticate", headerValue);
    }

    public String sanitizeRealm(String input) {
        if (input == null) {
            return "";
        }
        String noCRLF = input.replaceAll("[\\r\\n]", "");
        return noCRLF.replace("\"", "\\\"");
    }

    public String getRealm(HttpServletRequest request) {
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (scheme.equals("http") && serverPort != 80 || scheme.equals("https") && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        url.append(contextPath).append(servletPath);
        if (pathInfo != null) {
            url.append(pathInfo);
        }
        return url.toString();
    }

    public void validateCredentials(BackchannelCreds creds) throws LoginException {
        boolean basicAuthConfigured = false;
        boolean mutualAuthConfigured = false;
        boolean bearerTokenConfigured = false;
        boolean basicAuthReceived = false;
        boolean mutualAuthReceived = false;
        boolean bearerTokenReceived = false;
        boolean basicAuthValidationStatus = false;
        boolean bearerTokenValidationStatus = false;
        boolean bearerTokenInsufficientScope = false;
        boolean mutualAuthValidationSubjectDNCheckStatus = false;
        boolean mutualAuthValidationIssuerDNCheckStatus = false;
        String basicAuthValidationStatusMessage = "";
        String mutualAuthValidationStatusMessage = "";
        String bearerTokenAuthValidationStatusMessage = "";
        basicAuthConfigured = !StringUtils.isBlank((CharSequence)this.httpBasicAuthUsername) && !StringUtils.isBlank((CharSequence)this.httpBasicAuthPassphrase);
        mutualAuthConfigured = !this.acceptableSubjectDN.isEmpty() || !this.acceptableIssuerDN.isEmpty();
        boolean bl = bearerTokenConfigured = this.tokenManagerId != null;
        if (basicAuthConfigured && !StringUtils.isBlank((CharSequence)creds.getUsername()) && !StringUtils.isBlank((CharSequence)creds.getPassphrase())) {
            basicAuthReceived = true;
            if (this.httpBasicAuthUsername.equals(creds.getUsername()) && this.httpBasicAuthPassphrase.equals(creds.getPassphrase())) {
                basicAuthValidationStatus = true;
            } else {
                basicAuthValidationStatus = false;
                basicAuthValidationStatusMessage = "Invalid username or pass phrase.";
            }
        }
        if (!this.acceptableSubjectDN.isEmpty()) {
            if (creds.getSubjectDN() == null) {
                mutualAuthValidationSubjectDNCheckStatus = false;
                mutualAuthValidationStatusMessage = "Client Certificate needs to be provided by application.";
            } else {
                mutualAuthReceived = true;
                if (!CertHelper.compareDN(creds.getSubjectDN(), this.acceptableSubjectDN)) {
                    mutualAuthValidationSubjectDNCheckStatus = false;
                    mutualAuthValidationStatusMessage = "Subject DN for Client Certificate is not acceptable.";
                } else {
                    mutualAuthValidationSubjectDNCheckStatus = true;
                }
            }
        }
        if (!this.acceptableIssuerDN.isEmpty()) {
            if (creds.getIssuerDN() == null) {
                mutualAuthValidationIssuerDNCheckStatus = false;
                mutualAuthValidationStatusMessage = "Client Certificate needs to be provided by application.";
            } else {
                mutualAuthReceived = true;
                if (!CertHelper.compareDN(creds.getIssuerDN(), this.acceptableIssuerDN)) {
                    mutualAuthValidationIssuerDNCheckStatus = false;
                    mutualAuthValidationStatusMessage = !mutualAuthValidationStatusMessage.isEmpty() ? mutualAuthValidationStatusMessage + ", Issuer DN for Client Certificate is not acceptable." : "Issuer DN for Client Certificate is not acceptable.";
                } else {
                    mutualAuthValidationIssuerDNCheckStatus = true;
                }
            }
        }
        String realm = this.getRealm(creds.getHttpServletRequest());
        realm = this.sanitizeRealm(realm);
        if (!StringUtils.isBlank((CharSequence)creds.getBearerAccessToken()) && this.tokenManagerId != null) {
            String tokenValue = creds.getBearerAccessToken();
            bearerTokenReceived = true;
            AccessToken accessToken = this.tokenManagerPlugin.validateAccessToken(Collections.singletonList(this.tokenManagerId), tokenValue).getAccessToken();
            if (accessToken == null) {
                bearerTokenAuthValidationStatusMessage = "The access token is missing, expired, or invalid.";
                bearerTokenValidationStatus = false;
                this.setBearerTokenValidationFailureHeader(creds, realm, "invalid_token", bearerTokenAuthValidationStatusMessage, null);
            } else {
                bearerTokenValidationStatus = true;
            }
            if (bearerTokenValidationStatus) {
                if (accessToken.isExpired()) {
                    bearerTokenAuthValidationStatusMessage = "The access token has expired.";
                    this.setBearerTokenValidationFailureHeader(creds, realm, "invalid_token", bearerTokenAuthValidationStatusMessage, null);
                    bearerTokenValidationStatus = false;
                }
                if (bearerTokenValidationStatus) {
                    List list;
                    if (StringUtils.isNotBlank((CharSequence)this.bearerTokenValidClientIds) && !(list = Arrays.stream(this.bearerTokenValidClientIds.split("\\|")).map(String::trim).collect(Collectors.toList())).contains(accessToken.getClientId())) {
                        bearerTokenAuthValidationStatusMessage = "The client ID in access token is not authorized.";
                        this.setBearerTokenValidationFailureHeader(creds, realm, "invalid_token", bearerTokenAuthValidationStatusMessage, null);
                        bearerTokenValidationStatus = false;
                    }
                    if (bearerTokenValidationStatus && StringUtils.isNotBlank((CharSequence)this.bearerTokenRequiredScopes)) {
                        String accessTokenScopes = accessToken.getScope();
                        List tokenScopes = Arrays.stream(accessTokenScopes.split("\\s+")).map(String::trim).collect(Collectors.toList());
                        List configuredRequiredScopes = Arrays.stream(this.bearerTokenRequiredScopes.split("\\|")).map(String::trim).collect(Collectors.toList());
                        for (String requiredScope : configuredRequiredScopes) {
                            if (tokenScopes.contains(requiredScope)) continue;
                            bearerTokenInsufficientScope = true;
                            break;
                        }
                        if (bearerTokenInsufficientScope) {
                            String error = "The access token does not contain the required scope.";
                            bearerTokenAuthValidationStatusMessage = !bearerTokenAuthValidationStatusMessage.isEmpty() ? bearerTokenAuthValidationStatusMessage + " " + error : error;
                            bearerTokenValidationStatus = false;
                        }
                        this.setBearerTokenValidationFailureHeader(creds, realm, "insufficient_scope", bearerTokenAuthValidationStatusMessage, this.bearerTokenRequiredScopes.replace("|", " "));
                    }
                }
            }
        }
        if (basicAuthConfigured && basicAuthValidationStatus) {
            return;
        }
        if (bearerTokenConfigured && bearerTokenValidationStatus) {
            return;
        }
        if (!this.acceptableIssuerDN.isEmpty() && !this.acceptableSubjectDN.isEmpty() ? mutualAuthValidationSubjectDNCheckStatus && mutualAuthValidationIssuerDNCheckStatus : mutualAuthValidationSubjectDNCheckStatus || mutualAuthValidationIssuerDNCheckStatus) {
            return;
        }
        if (bearerTokenConfigured && bearerTokenReceived && !bearerTokenValidationStatus) {
            if (bearerTokenInsufficientScope) {
                throw new AccountException("Authentication failure. Cause: " + bearerTokenAuthValidationStatusMessage);
            }
            throw new LoginException("Authentication failure. Cause: " + bearerTokenAuthValidationStatusMessage);
        }
        if (basicAuthConfigured && basicAuthReceived && mutualAuthConfigured && mutualAuthReceived) {
            throw new LoginException("Authentication failure. Cause: " + basicAuthValidationStatusMessage + ", " + mutualAuthValidationStatusMessage);
        }
        if (basicAuthConfigured && basicAuthReceived) {
            throw new LoginException("Authentication failure. Cause: " + basicAuthValidationStatusMessage);
        }
        if (mutualAuthConfigured && mutualAuthReceived) {
            throw new LoginException("Authentication failure. Cause: " + mutualAuthValidationStatusMessage);
        }
        if (basicAuthConfigured && !basicAuthReceived && mutualAuthConfigured && !mutualAuthReceived) {
            throw new LoginException("Authentication failure: Authenticate with valid username/password or valid client certificate");
        }
        if (basicAuthConfigured && !basicAuthReceived) {
            throw new LoginException("Authentication failure: Authenticate with valid username/password");
        }
        if (mutualAuthConfigured && !mutualAuthReceived) {
            throw new LoginException("Authentication failure: Authenticate with valid client certificate");
        }
        if (bearerTokenConfigured && !bearerTokenReceived) {
            throw new LoginException("Authentication failure: Authenticate with valid bearer access token");
        }
    }

    public static class Builder {
        List<X500Principal> acceptableSubjectDN = new ArrayList<X500Principal>();
        List<X500Principal> acceptableIssuerDN = new ArrayList<X500Principal>();
        String httpBasicAuthUsername = "";
        String httpBasicAuthPassphrase = "";
        String tokenManagerId = null;
        String bearerTokenValidClientIds = null;
        String bearerTokenRequiredScopes = null;

        public Builder setAcceptableSubjectDN(List<X500Principal> acceptableSubjectDN) {
            this.acceptableSubjectDN = acceptableSubjectDN;
            return this;
        }

        public Builder setAcceptableIssuerDN(List<X500Principal> acceptableIssuerDN) {
            this.acceptableIssuerDN = acceptableIssuerDN;
            return this;
        }

        public Builder setHttpBasicAuthUsername(String httpBasicAuthUsername) {
            this.httpBasicAuthUsername = httpBasicAuthUsername;
            return this;
        }

        public Builder setHttpBasicAuthPassphrase(String httpBasicAuthPassphrase) {
            this.httpBasicAuthPassphrase = httpBasicAuthPassphrase;
            return this;
        }

        public Builder setTokenManagerId(String tokenManagerId) {
            this.tokenManagerId = tokenManagerId;
            return this;
        }

        public Builder setBearerTokenValidClientIds(String bearerTokenValidClientIds) {
            this.bearerTokenValidClientIds = bearerTokenValidClientIds;
            return this;
        }

        public Builder setBearerTokenRequiredScopes(String bearerTokenRequiredScopes) {
            this.bearerTokenRequiredScopes = bearerTokenRequiredScopes;
            return this;
        }

        public CredsValidatorUtil build() {
            CredsValidatorUtil credsValidatorUtil = new CredsValidatorUtil();
            credsValidatorUtil.httpBasicAuthUsername = this.httpBasicAuthUsername;
            credsValidatorUtil.httpBasicAuthPassphrase = this.httpBasicAuthPassphrase;
            credsValidatorUtil.acceptableIssuerDN = this.acceptableIssuerDN;
            credsValidatorUtil.acceptableSubjectDN = this.acceptableSubjectDN;
            credsValidatorUtil.tokenManagerId = this.tokenManagerId;
            credsValidatorUtil.bearerTokenValidClientIds = this.bearerTokenValidClientIds;
            credsValidatorUtil.bearerTokenRequiredScopes = this.bearerTokenRequiredScopes;
            return credsValidatorUtil;
        }
    }
}

