/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import com.pingidentity.common.util.Substituter;
import com.pingidentity.pf.adapters.referenceid.BackchannelReferenceAuthnAdapter;
import com.pingidentity.pf.adapters.referenceid.LogCleaner;
import com.pingidentity.pf.adapters.referenceid.LoggerMessage;
import com.pingidentity.pf.adapters.referenceid.QueryParamUtil;
import com.pingidentity.pf.adapters.referenceid.ReferenceIdParameters;
import com.pingidentity.pf.adapters.referenceid.api.ActionSpec;
import com.pingidentity.pf.adapters.referenceid.api.CheckReferenceId;
import com.pingidentity.pf.adapters.referenceid.api.ErrorDetailSpec;
import com.pingidentity.pf.adapters.referenceid.api.ReferenceIdRequired;
import com.pingidentity.pf.adapters.referenceid.api.StateSpec;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.exception.AuthnErrorException;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.MarkupEntities;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.service.ArtifactPersistenceServiceException;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.bindings.FormPost;
import shaded.refid.com.google.gson.Gson;
import shaded.refid.com.google.gson.JsonArray;
import shaded.refid.com.google.gson.JsonElement;
import shaded.refid.com.google.gson.JsonObject;
import shaded.refid.com.google.gson.JsonParser;
import shaded.refid.com.google.gson.JsonSyntaxException;
import shaded.refid.com.google.gson.reflect.TypeToken;
import shaded.refid.com.pingidentity.integrations.logger.IntegrationsLogger;
import shaded.refid.com.pingidentity.integrations.logger.LogEvent;

public class IdpBackchannelReferenceAuthnAdapter
extends BackchannelReferenceAuthnAdapter
implements IdpAuthenticationAdapterV2,
AuthnApiPlugin {
    private IdpAuthnAdapterDescriptor descriptor;
    private static final IntegrationsLogger logger;
    private static final String AUTH_ENDPOINT_FIELD_NAME = "Authentication Endpoint";
    private static final String PREFIX_ATTRS_FIELD_NAME = "Prefix Referenced Attributes";
    private static final String PRESERVE_JSON_FIELD_NAME = "Preserve JSON";
    private static final String DISABLE_HTTP_PARAMS_FIELD_NAME = "Ignore Untracked HTTP Parameters";
    private static final String SEND_REQUEST_PARAMS_FIELD_NAME = "Send Request Parameters";
    private String authnEndpoint = "https://";
    private Boolean prefixAttributes = false;
    private Boolean preserveJson = false;
    private Boolean disableHttpParams = false;
    private SEND_REQUEST_PARAMS_VALUES sendRequestParams;
    private static Boolean isSetDefaultForLegacyConfigMethodPresent;
    public static final String REAUTH_PARAM_NAME = "reauth";
    public static final String CONNECTION_ID_PARAM_NAME = "connectionId";
    public static final String ALLOW_INTERACT_PARAM_NAME = "allowInteraction";
    public static final String TRACKED_HTTP_PARAM_ATTR_PREFIX = "trackedparam.";
    public static final String HTTP_PARAM_ATTR_PREFIX = "httpparam.";
    public static final String SIGNED_ATTR_PREFIX = "signedreqattr.";
    public static final String CHAINED_ATTR_PREFIX = "chainedattr.";
    private static final String IN_PARAMETER_NAME_OAUTH_CLIENT_ID = "com.pingidentity.adapter.input.parameter.oauth.client.id";
    private static final String IN_PARAMETER_NAME_SP_ADAPTER_ID = "com.pingidentity.adapter.input.parameter.sp.adapter.id";
    private static final String IN_PARAMETER_NAME_SIGNED_REQUEST_CLAIMS = "com.pingidentity.adapter.input.parameter.signed.request.claims";
    private static final String IN_PARAMETER_NAME_TRACKING_ID = "com.pingidentity.adapter.input.parameter.tracking.id";
    private static final String IN_PARAMETER_NAME_CURRENT_SERVER_BASE_URL = "com.pingidentity.adapter.input.parameter.current.server.base.url";
    private static final String IN_PARAMETER_NAME_OAUTH_SCOPE = "com.pingidentity.adapter.input.parameter.oauth.scope";
    private static final String IN_PARAMETER_NAME_OAUTH_SCOPE_DESCRIPTIONS = "com.pingidentity.adapter.input.parameter.oauth.scope.descriptions";
    private static final String IN_PARAMETER_NAME_DEFAULT_SCOPE = "com.pingidentity.adapter.input.parameter.oauth.scope.default.description";
    private static final String IN_PARAMETER_NAME_APPLICATION_NAME = "com.pingidentity.adapter.input.parameter.application.name";
    private static final String IN_PARAMETER_NAME_APPLICATION_ICON_URL = "com.pingidentity.adapter.input.parameter.application.icon.url";
    private static final String ADAPTER_INFO_EXTERNAL_CONSENT_ADAPTER = "com.pingidentity.adapter.info.external.consent.adapter";
    private static final String IN_PARAMETER_NAME_ADAPTER_ACTION = "com.pingidentity.adapter.input.parameter.adapter.action";
    private static final String EXTERNAL_APPLICATION_FAILURE_MESSAGE = "com.pingidentity.adapter.refid.external.application.failure.message";
    private static Map<String, Object> adapterInfo;
    public static final String SESSION_REFERENCE_ATTR_NAME = "sessionid";
    private static final ParamMapping<CheckReferenceId, String> REFERENCE_ID_MAPPING;
    private Configuration configuration;
    private AuthnApiSupport apiSupport = AuthnApiSupport.getDefault();

    public AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor() {
        return this.adapterConfigurationGuiDescriptor(null);
    }

    public AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor(Configuration configuration) {
        AdapterConfigurationGuiDescriptor guiDesc = new AdapterConfigurationGuiDescriptor();
        guiDesc.setDescription("The Reference ID Adapter allows user attributes to be passed in and out of the PingFederate server via direct HTTP(S) calls. Attributes are retrieved via a Reference ID.");
        String authnEpDesc = "Application endpoint URL where the end user is redirected for authentication.";
        TextFieldDescriptor authEndptFieldDesc = new TextFieldDescriptor(AUTH_ENDPOINT_FIELD_NAME, authnEpDesc);
        authEndptFieldDesc.addValidator((FieldValidator)REQUIRED_FIELD_VALIDATOR);
        authEndptFieldDesc.addValidator((FieldValidator)HTTP_URL_VALIDATOR);
        guiDesc.addField((FieldDescriptor)authEndptFieldDesc);
        String prefixAttrsDesc = "Prefix attribute keys with source information. Untracked HTTP parameters will be prefixed with \"httpparam.\", tracked HTTP parameters with \"trackedparam.\", signed request object attributes with \"signedreqattr.\" and chained attributes with \"chainedattr.\".";
        CheckBoxFieldDescriptor prefixAttrsFieldDesc = new CheckBoxFieldDescriptor(PREFIX_ATTRS_FIELD_NAME, prefixAttrsDesc);
        prefixAttrsFieldDesc.setDefaultValue(true);
        try {
            Method m = prefixAttrsFieldDesc.getClass().getMethod("setDefaultForLegacyConfig", String.class);
            m.invoke((Object)prefixAttrsFieldDesc, "false");
        }
        catch (Throwable e) {
            logger.log((LogEvent)LoggerMessage.DEFAULT_FIELD_FAILURE, e);
        }
        guiDesc.addAdvancedField((FieldDescriptor)prefixAttrsFieldDesc);
        String preserveJsonDesc = "Automatically preserve incoming chained attribute value and tracked parameter as JSON if a valid JSON format is detected; otherwise, preserve its original format.";
        CheckBoxFieldDescriptor preserveJsonFieldAttr = new CheckBoxFieldDescriptor(PRESERVE_JSON_FIELD_NAME, preserveJsonDesc);
        preserveJsonFieldAttr.setDefaultValue(false);
        guiDesc.addAdvancedField((FieldDescriptor)preserveJsonFieldAttr);
        String disableHttpParamsDesc = "Disable referencing HTTP parameters sent to the adapter via the query string.";
        CheckBoxFieldDescriptor disableHttpParamsFieldDesc = new CheckBoxFieldDescriptor(DISABLE_HTTP_PARAMS_FIELD_NAME, disableHttpParamsDesc);
        disableHttpParamsFieldDesc.setDefaultValue(true);
        try {
            Method m = disableHttpParamsFieldDesc.getClass().getMethod("setDefaultForLegacyConfig", String.class);
            m.invoke((Object)disableHttpParamsFieldDesc, "false");
        }
        catch (Throwable e) {
            logger.log((LogEvent)LoggerMessage.DEFAULT_FIELD_FAILURE, e);
        }
        guiDesc.addAdvancedField((FieldDescriptor)disableHttpParamsFieldDesc);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> opts = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>(3);
        opts.add(new AbstractSelectionFieldDescriptor.OptionValue("All", SEND_REQUEST_PARAMS_VALUES.ALL.toString()));
        opts.add(new AbstractSelectionFieldDescriptor.OptionValue("Tracked Parameters", SEND_REQUEST_PARAMS_VALUES.TRACKED_PARAMS.toString()));
        opts.add(new AbstractSelectionFieldDescriptor.OptionValue("None", SEND_REQUEST_PARAMS_VALUES.NONE.toString()));
        String sendRequestParamsDesc = "Determines which request parameters are sent to the application authentication endpoint via the query string.";
        SelectFieldDescriptor sendRequestParamsFieldDesc = new SelectFieldDescriptor(SEND_REQUEST_PARAMS_FIELD_NAME, sendRequestParamsDesc, opts);
        sendRequestParamsFieldDesc.setDefaultValue(SEND_REQUEST_PARAMS_VALUES.NONE.toString());
        if (isSetDefaultForLegacyConfigMethodPresent.booleanValue()) {
            sendRequestParamsFieldDesc.setDefaultForLegacyConfig(SEND_REQUEST_PARAMS_VALUES.ALL.toString());
        }
        guiDesc.addAdvancedField((FieldDescriptor)sendRequestParamsFieldDesc);
        this.addCommonGuiStuff(guiDesc, configuration);
        return guiDesc;
    }

    @Override
    String getMoreLogoutDesc() {
        return "";
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        String type = "Reference ID IdP Adapter 2.2.1";
        this.descriptor = new IdpAuthnAdapterDescriptor(this, type, DEFAULT_CONTRACT, true, this.adapterConfigurationGuiDescriptor(), false){

            public GuiConfigDescriptorBuilder getGuiConfigDescriptorBuilder() {
                return new GuiConfigDescriptorBuilder(){

                    public GuiConfigDescriptor buildNewGuiDescriptor() {
                        AdapterConfigurationGuiDescriptor configDescriptor = IdpBackchannelReferenceAuthnAdapter.this.adapterConfigurationGuiDescriptor();
                        configDescriptor.addValidator(conf -> {
                            if (conf.getFieldValue("Logout Service Mode") != null && !conf.getFieldValue("Logout Service Mode").equals(BackchannelReferenceAuthnAdapter.LogoutMode.NONE.toString()) && StringUtils.isBlank((CharSequence)conf.getFieldValue("Logout Service Endpoint"))) {
                                throw new ValidationException("Complete the Logout Service Endpoint field, or set Logout Mode to None.");
                            }
                        });
                        return configDescriptor;
                    }

                    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
                        return IdpBackchannelReferenceAuthnAdapter.this.adapterConfigurationGuiDescriptor(configuration);
                    }
                };
            }
        };
        return this.descriptor;
    }

    public Map lookupAuthN(HttpServletRequest req, HttpServletResponse resp, String partnerSpEntityId, AuthnPolicy authnPolicy, String resumePath) throws AuthnAdapterException, IOException {
        return null;
    }

    public AuthnAdapterResponse lookupAuthN(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inputParameters) throws AuthnAdapterException, IOException {
        logger.log((LogEvent)LoggerMessage.START_LOOKUP_AUTHN, LogCleaner.clean(req.getRequestURI()));
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        try {
            return this.handleRequest(req, resp, inputParameters);
        }
        catch (ArtifactPersistenceServiceException e) {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            authnAdapterResponse.setErrorMessage(e.getMessage());
            logger.log((LogEvent)LoggerMessage.AUTHN_FAILED, e);
            return authnAdapterResponse;
        }
    }

    public boolean logoutAuthN(Map authnIdentifiers, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        if (this.isResume(req, resumePath) || this.logoutMode == BackchannelReferenceAuthnAdapter.LogoutMode.NONE || StringUtils.isBlank((CharSequence)this.logoutSvcEndpoint)) {
            if (StringUtils.isNotBlank((CharSequence)this.logoutSvcEndpoint) && this.logoutMode == BackchannelReferenceAuthnAdapter.LogoutMode.NONE) {
                logger.log(LoggerMessage.LOGOUT_ENDPOINT_CONFIGURED_WITH_MODE_NONE);
            }
            return true;
        }
        switch (this.logoutMode) {
            case BACK: {
                try {
                    String svcEndpoint = Substituter.substituteValues((String)this.logoutSvcEndpoint, (Map)authnIdentifiers);
                    return this.sendBackChannelLogout(svcEndpoint);
                }
                catch (Substituter.UnknownKeyException e) {
                    throw new AuthnAdapterException("Unable to send request to endpoint for logout " + this.logoutSvcEndpoint, (Throwable)e);
                }
            }
            case FRONT: {
                try {
                    if (req == null) {
                        logger.log(LoggerMessage.LOGOUT_MODE_MISCONFIGURATION);
                        return false;
                    }
                    Map attrs = authnIdentifiers;
                    attrs.put(this.getResumePathParamName(), resumePath);
                    String currentBaseUrl = this.getCurrentBaseUrl();
                    if (StringUtils.isNotBlank((CharSequence)currentBaseUrl)) {
                        attrs.put(this.getCurrentBaseUrlParamName(), currentBaseUrl);
                    }
                    AttributeMap attributeMap = AttrValueSupport.convert((Map)attrs, (boolean)false);
                    Map<String, Object> objectMap = this.attributeMapToObjectMap((Map<String, AttributeValue>)attributeMap);
                    String ref = this.storeAttrs(req, objectMap, null);
                    if (this.transportMode == 0) {
                        String svcEndpt = QueryParamUtil.addQueryParameter(this.logoutSvcEndpoint, this.getRefParamName(), ref);
                        resp.sendRedirect(svcEndpt);
                        break;
                    }
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put(this.getResumePathParamName(), resumePath);
                    postParams.put(this.getRefParamName(), ref);
                    if (StringUtils.isNotBlank((CharSequence)currentBaseUrl)) {
                        postParams.put(this.getCurrentBaseUrlParamName(), currentBaseUrl);
                    }
                    FormPost.post((String)this.logoutSvcEndpoint, postParams, (HttpServletResponse)resp);
                    break;
                }
                catch (ArtifactPersistenceServiceException e) {
                    throw new AuthnAdapterException((Throwable)e);
                }
            }
            default: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.authnEndpoint = configuration.getFieldValue(AUTH_ENDPOINT_FIELD_NAME);
        this.prefixAttributes = configuration.getAdvancedFields().getBooleanFieldValue(PREFIX_ATTRS_FIELD_NAME);
        this.preserveJson = configuration.getAdvancedFields().getBooleanFieldValue(PRESERVE_JSON_FIELD_NAME);
        this.disableHttpParams = configuration.getAdvancedFields().getBooleanFieldValue(DISABLE_HTTP_PARAMS_FIELD_NAME);
        this.configuration = configuration;
        String sendRequestParams = configuration.getAdvancedFields().getFieldValue(SEND_REQUEST_PARAMS_FIELD_NAME);
        this.sendRequestParams = sendRequestParams == null ? SEND_REQUEST_PARAMS_VALUES.ALL : SEND_REQUEST_PARAMS_VALUES.valueOf(sendRequestParams);
        IdpBackchannelReferenceAuthnAdapter.reloadHandlers();
    }

    public Map<String, Object> getAdapterInfo() {
        return adapterInfo;
    }

    public Map<String, Object> prepareAttributeMap(Map<String, Object> map) {
        HashMap<String, Object> serializedAttrs = new HashMap<String, Object>();
        Gson gson = new Gson();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AttributeValue) {
                AttributeValue av = (AttributeValue)value;
                Object object = value = av.isMultiValue() ? av.getValuesAsCollection() : av.getValue();
            }
            if (!(value instanceof String || value instanceof Date || value instanceof List)) {
                value = gson.toJson(value);
            } else if (value instanceof List) {
                ArrayList<String> arrayList = new ArrayList<String>();
                List valueList = (List)value;
                for (Object object : valueList) {
                    if (object instanceof Map) {
                        String toJsonStr = gson.toJson(object);
                        arrayList.add(toJsonStr);
                        continue;
                    }
                    arrayList.add(object.toString());
                }
                value = new AttributeValue(arrayList);
            }
            serializedAttrs.put(key, value);
        }
        return serializedAttrs;
    }

    public PluginApiSpec getApiSpec() {
        PluginApiSpec result = new PluginApiSpec(Arrays.asList(StateSpec.REFERENCE_ID_REQUIRED));
        return result;
    }

    private boolean isCheckReferenceIdRequiredRequest(HttpServletRequest req) {
        if (this.apiSupport.isApiRequest(req)) {
            return ActionSpec.CHECK_REFERENCE_ID.isRequested(req);
        }
        return StringUtils.isNotBlank((CharSequence)req.getParameter("pf.submit"));
    }

    private ReferenceIdParameters getInputParameters(Map<String, Object> inputParameters) {
        ReferenceIdParameters params = new ReferenceIdParameters();
        params.setResumePath((String)inputParameters.get("com.pingidentity.adapter.input.parameter.resume.path"));
        params.setAuthnPolicy((AuthnPolicy)inputParameters.get("com.pingidentity.adapter.input.parameter.authn.policy"));
        params.setEntityId((String)inputParameters.get("com.pingidentity.adapter.input.parameter.partner.entityid"));
        params.setOauthClientId((String)inputParameters.get(IN_PARAMETER_NAME_OAUTH_CLIENT_ID));
        params.setAdapterId((String)inputParameters.get(IN_PARAMETER_NAME_SP_ADAPTER_ID));
        params.setInstanceId((String)inputParameters.get("com.pingidentity.adapter.input.parameter.instanceid"));
        params.setUsername((String)inputParameters.get("com.pingidentity.adapter.input.parameter.userid"));
        params.setTrackingId((String)inputParameters.get(IN_PARAMETER_NAME_TRACKING_ID));
        params.setChainedAttributes((Map)inputParameters.computeIfAbsent("com.pingidentity.adapter.input.parameter.chained.attributes", k -> new HashMap()));
        params.setSignedRequestClaims((Map)inputParameters.computeIfAbsent(IN_PARAMETER_NAME_SIGNED_REQUEST_CLAIMS, k -> new HashMap()));
        params.setTrackedParams((Map)inputParameters.computeIfAbsent("com.pingidentity.adapter.tracked.http.request.params", k -> new HashMap()));
        params.setRequestedScopes((String)inputParameters.get(IN_PARAMETER_NAME_OAUTH_SCOPE));
        params.setScopeDescriptions((Map)inputParameters.get(IN_PARAMETER_NAME_OAUTH_SCOPE_DESCRIPTIONS));
        params.setDefaultScopeDescription((String)inputParameters.get(IN_PARAMETER_NAME_DEFAULT_SCOPE));
        params.setApplicationName((String)inputParameters.get(IN_PARAMETER_NAME_APPLICATION_NAME));
        params.setApplicationIconUrl((String)inputParameters.get(IN_PARAMETER_NAME_APPLICATION_ICON_URL));
        params.setAdapterAction((String)inputParameters.get(IN_PARAMETER_NAME_ADAPTER_ACTION));
        params.setCurrentServerBaseUrl((String)inputParameters.get(IN_PARAMETER_NAME_CURRENT_SERVER_BASE_URL));
        return params;
    }

    private String getConnectionIdFromParams(ReferenceIdParameters params) {
        String connectionId = null;
        if (!StringUtils.isEmpty((CharSequence)params.getEntityId())) {
            connectionId = params.getEntityId();
        } else if (!StringUtils.isEmpty((CharSequence)params.getOauthClientId())) {
            connectionId = params.getOauthClientId();
        } else if (!StringUtils.isEmpty((CharSequence)params.getAdapterId())) {
            connectionId = params.getAdapterId();
        }
        return connectionId;
    }

    private Map<String, Object> assembleSSOContextAttributes(HttpServletRequest req, ReferenceIdParameters params) {
        AttributeValue attrValue;
        Object jsonArray;
        Object value;
        String key;
        HashMap<String, Object> attributesToSend = new HashMap<String, Object>();
        if (this.disableHttpParams != null && !this.disableHttpParams.booleanValue()) {
            Set<String> trackedParamKeys = params.getTrackedParams().keySet();
            Map map2 = req.getParameterMap();
            map2 = map2 == null ? new HashMap() : map2;
            for (Map.Entry entry : map2.entrySet()) {
                String key2 = (String)entry.getKey();
                if (trackedParamKeys.contains(key2)) continue;
                if (this.prefixAttributes != null && this.prefixAttributes.booleanValue()) {
                    key2 = HTTP_PARAM_ATTR_PREFIX + key2;
                }
                String[] value2 = entry.getValue() == null ? new String[]{} : (String[])entry.getValue();
                List<String> listValue = Arrays.asList(value2);
                if (value2.length == 1) {
                    attributesToSend.put(key2, listValue.get(0));
                    continue;
                }
                attributesToSend.put(key2, listValue);
            }
        }
        for (Map.Entry<String, Collection<String>> entry : params.getTrackedParams().entrySet()) {
            String singleValue;
            ArrayList<String> listValue;
            key = entry.getKey();
            if (this.prefixAttributes != null && this.prefixAttributes.booleanValue()) {
                key = TRACKED_HTTP_PARAM_ATTR_PREFIX + key;
            }
            value = entry.getValue();
            if (this.preserveJson.booleanValue()) {
                if (value != null && value.size() == 1) {
                    listValue = new ArrayList<String>((Collection<String>)value);
                    singleValue = (String)listValue.get(0);
                    jsonArray = new JsonArray();
                    JsonObject jsonObject = this.getJsonObject(singleValue);
                    if (jsonObject != null) {
                        ((JsonArray)jsonArray).add(jsonObject);
                    } else {
                        ((JsonArray)jsonArray).add(singleValue);
                    }
                    attributesToSend.put(key, jsonArray);
                }
                if (value == null || value.size() <= 1) continue;
                ArrayList listValues = new ArrayList(value);
                JsonArray jsonArray2 = new JsonArray();
                jsonArray = listValues.iterator();
                while (jsonArray.hasNext()) {
                    String listValue2 = (String)jsonArray.next();
                    JsonObject jsonObject = this.getJsonObject(listValue2);
                    if (jsonObject != null) {
                        jsonArray2.add(jsonObject);
                        continue;
                    }
                    jsonArray2.add(listValue2);
                }
                attributesToSend.put(key, jsonArray2);
                continue;
            }
            if (value != null && value.size() == 1) {
                listValue = new ArrayList<String>((Collection<String>)value);
                singleValue = (String)listValue.get(0);
                attributesToSend.put(key, singleValue);
                continue;
            }
            attributesToSend.put(key, value);
        }
        if (params.getSignedRequestClaims() != null && !params.getSignedRequestClaims().isEmpty()) {
            for (Map.Entry<String, Object> entry : params.getSignedRequestClaims().entrySet()) {
                key = entry.getKey();
                if (this.prefixAttributes != null && this.prefixAttributes.booleanValue()) {
                    key = SIGNED_ATTR_PREFIX + key;
                }
                if ((value = entry.getValue()) instanceof AttributeValue) {
                    attrValue = (AttributeValue)value;
                    value = attrValue.isMultiValue() ? attrValue.getValuesAsCollection() : attrValue.getValue();
                }
                attributesToSend.put(key, value);
            }
        }
        if (params.getChainedAttributes() != null && !params.getChainedAttributes().isEmpty()) {
            for (Map.Entry<String, Object> entry : params.getChainedAttributes().entrySet()) {
                Object deserializedValue;
                key = entry.getKey();
                if (this.prefixAttributes != null && this.prefixAttributes.booleanValue()) {
                    key = CHAINED_ATTR_PREFIX + key;
                }
                if ((value = entry.getValue()) instanceof AttributeValue) {
                    attrValue = (AttributeValue)value;
                    Object deserializedValue2 = null;
                    if (attrValue.isMultiValue()) {
                        if (this.preserveJson.booleanValue() && (jsonArray = this.getJsonAsArray(attrValue.getAllObjectValues())) != null) {
                            attributesToSend.put(key, jsonArray);
                            continue;
                        }
                        attributesToSend.put(key, attrValue.getValuesAsCollection());
                        continue;
                    }
                    if (this.preserveJson.booleanValue() && (deserializedValue2 = this.convertAttributeValueToJson(attrValue)) != null) {
                        attributesToSend.put(key, deserializedValue2);
                        continue;
                    }
                    attributesToSend.put(key, attrValue.getValue());
                    continue;
                }
                if (this.preserveJson.booleanValue() && (deserializedValue = this.convertAttributeValueToJson(new AttributeValue(value.toString()))) != null) {
                    attributesToSend.put(key, deserializedValue);
                    continue;
                }
                attributesToSend.put(key, value);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)params.getTrackingId())) {
            attributesToSend.put(IN_PARAMETER_NAME_TRACKING_ID, params.getTrackingId());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getOauthClientId())) {
            attributesToSend.put(IN_PARAMETER_NAME_OAUTH_CLIENT_ID, params.getOauthClientId());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getRequestedScopes())) {
            attributesToSend.put(IN_PARAMETER_NAME_OAUTH_SCOPE, params.getRequestedScopes());
        }
        if (params.getScopeDescriptions() != null && !params.getScopeDescriptions().isEmpty()) {
            attributesToSend.put(IN_PARAMETER_NAME_OAUTH_SCOPE_DESCRIPTIONS, params.getScopeDescriptions());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getDefaultScopeDescription())) {
            attributesToSend.put(IN_PARAMETER_NAME_DEFAULT_SCOPE, params.getDefaultScopeDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getApplicationName())) {
            attributesToSend.put(IN_PARAMETER_NAME_APPLICATION_NAME, params.getApplicationName());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getApplicationIconUrl())) {
            attributesToSend.put(IN_PARAMETER_NAME_APPLICATION_ICON_URL, params.getApplicationIconUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getAdapterAction())) {
            attributesToSend.put(IN_PARAMETER_NAME_ADAPTER_ACTION, params.getAdapterAction());
        }
        if (StringUtils.isNotBlank((CharSequence)params.getCurrentServerBaseUrl())) {
            attributesToSend.put(IN_PARAMETER_NAME_CURRENT_SERVER_BASE_URL, params.getCurrentServerBaseUrl());
        }
        attributesToSend.put("isSsoContextVariable.flag", Boolean.toString(true));
        return attributesToSend;
    }

    private JsonObject getJsonObject(Object value) {
        Gson gson = new Gson();
        String json = value instanceof String ? (String)value : gson.toJson(value);
        try {
            JsonElement jsonElement = JsonParser.parseString(json);
            if (jsonElement.isJsonObject()) {
                return jsonElement.getAsJsonObject();
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return null;
    }

    private Object convertAttributeValueToJson(AttributeValue attrValue) {
        Object deserializedValue = null;
        Type mapTypeToken = new TypeToken<Map<String, Object>>(){}.getType();
        Type listTypeToken = new TypeToken<List<Object>>(){}.getType();
        Gson gson = new Gson();
        String attributeValueString = attrValue.getValue();
        try {
            deserializedValue = gson.fromJson(attributeValueString, listTypeToken);
            return deserializedValue;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            try {
                deserializedValue = gson.fromJson(attributeValueString, mapTypeToken);
                return deserializedValue;
            }
            catch (JsonSyntaxException jsonSyntaxException2) {
                return null;
            }
        }
    }

    private JsonArray getJsonAsArray(Object value) {
        Gson gson = new Gson();
        String json = value instanceof String ? (String)value : gson.toJson(value);
        try {
            JsonElement jsonElement = JsonParser.parseString(json);
            if (jsonElement.isJsonArray()) {
                return jsonElement.getAsJsonArray();
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return null;
    }

    private String assembleAuthUrl(ReferenceIdParameters params, String connectionId, String refId) {
        String authUrl = this.authnEndpoint;
        authUrl = QueryParamUtil.addQueryParameter(authUrl, this.getResumePathParamName(), params.getResumePath());
        if (params.getAuthnPolicy() != null) {
            authUrl = QueryParamUtil.addQueryParameter(authUrl, ALLOW_INTERACT_PARAM_NAME, String.valueOf(params.getAuthnPolicy().allowUserInteraction()));
            authUrl = QueryParamUtil.addQueryParameter(authUrl, REAUTH_PARAM_NAME, String.valueOf(params.getAuthnPolicy().reauthenticate()));
        }
        if (connectionId != null) {
            authUrl = QueryParamUtil.addQueryParameter(authUrl, CONNECTION_ID_PARAM_NAME, connectionId);
        }
        if (StringUtils.isNotBlank((CharSequence)refId)) {
            authUrl = QueryParamUtil.addQueryParameter(authUrl, this.getRefParamName(), refId);
        }
        return authUrl;
    }

    private AuthnAdapterResponse handleRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws AuthnAdapterException, IOException, ArtifactPersistenceServiceException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        try {
            if (this.isCheckReferenceIdRequiredRequest(req)) {
                String submittedReferenceId = (String)REFERENCE_ID_MAPPING.getValue(req);
                Map<String, Object> userAttributes = this.validateSubmittedReferenceId(req, submittedReferenceId);
                if (this.checkIsSSOContextAttributes(userAttributes)) {
                    logger.log(LoggerMessage.REQUEST_REF_ID_FOR_USER_ATTRIBUTES_ERROR);
                    AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
                    authnError.setDetails(Arrays.asList(ErrorDetailSpec.INVALID_REF_ID.makeInstanceBuilder().message("Reference ID: " + submittedReferenceId + " is not valid for user attributes.").build()));
                    throw new AuthnErrorException(authnError);
                }
                authnAdapterResponse.setAttributeMap(userAttributes);
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
                return authnAdapterResponse;
            }
            if (this.apiSupport.getActionId(req) != null) {
                throw new AuthnErrorException(CommonErrorSpec.INVALID_ACTION_ID.makeInstance());
            }
        }
        catch (AuthnErrorException e) {
            this.apiSupport.writeErrorResponse(req, resp, e.getValidationError());
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            return authnAdapterResponse;
        }
        this.renderResponse(req, resp, inParameters, authnAdapterResponse);
        if (null == authnAdapterResponse.getAttributeMap() || authnAdapterResponse.getAttributeMap().isEmpty()) {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        } else {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
        }
        return authnAdapterResponse;
    }

    private Map<String, Object> validateSubmittedReferenceId(HttpServletRequest req, String referenceId) throws AuthnErrorException {
        Map<String, Object> attributes = new HashMap<String, Object>();
        if (this.apiSupport.isApiRequest(req)) {
            ArrayList<AuthnErrorDetail> errorDetails = new ArrayList<AuthnErrorDetail>();
            try {
                attributes = this.retrieveAttributes(referenceId);
                if (attributes.isEmpty()) {
                    errorDetails.add(ErrorDetailSpec.INVALID_REF_ID.makeInstanceBuilder().message("The reference ID is not valid: " + referenceId).build());
                }
            }
            catch (ArtifactPersistenceServiceException ape) {
                errorDetails.add(ErrorDetailSpec.INVALID_REF_ID.makeInstanceBuilder().message(ape.getMessage()).build());
            }
            if (!errorDetails.isEmpty()) {
                AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
                authnError.setDetails(errorDetails);
                throw new AuthnErrorException(authnError);
            }
        }
        return attributes;
    }

    private void renderResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inputParameters, AuthnAdapterResponse authnAdapterResponse) throws AuthnAdapterException, ArtifactPersistenceServiceException, IOException {
        if (this.apiSupport.isApiRequest(req)) {
            this.renderApiResponse(req, resp, inputParameters);
        } else {
            this.renderFormResponse(req, resp, inputParameters, authnAdapterResponse);
        }
    }

    private void renderApiResponse(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inputParameters) throws AuthnAdapterException, IOException, ArtifactPersistenceServiceException {
        String refId = this.pickupSSOContextAttributes(request, response, inputParameters);
        ReferenceIdRequired model = new ReferenceIdRequired();
        model.setPickupReferenceId(refId);
        AuthnState authnState = this.apiSupport.makeAuthnState(request, StateSpec.REFERENCE_ID_REQUIRED, (Object)model);
        try {
            this.apiSupport.writeAuthnStateResponse(request, response, authnState);
        }
        catch (IOException e) {
            throw new AuthnAdapterException((Throwable)e);
        }
    }

    private void renderFormResponse(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inputParameters, AuthnAdapterResponse authnAdapterResponse) throws AuthnAdapterException, ArtifactPersistenceServiceException, IOException {
        ReferenceIdParameters params = this.getInputParameters(inputParameters);
        Map<String, Object> attributes = this.retrieveAttributes(request);
        boolean isResumeRequest = this.isResume(request, params.getResumePath());
        boolean isSSOContextAttributes = this.checkIsSSOContextAttributes(attributes);
        if (isResumeRequest && isSSOContextAttributes) {
            logger.log(LoggerMessage.REQUEST_REF_ID_FOR_USER_ATTRIBUTES_ERROR);
            throw new AuthnAdapterException("Invalid Reference ID");
        }
        if ((attributes == null || attributes.isEmpty()) && !isResumeRequest) {
            this.pickupSSOContextAttributes(request, response, inputParameters);
        }
        if (attributes != null && !attributes.isEmpty()) {
            String externalApplicationFailureMessage;
            Object attributeValue = attributes.remove("authnCtx");
            if (attributeValue != null) {
                attributes.put("org.sourceid.saml20.adapter.idp.authn.authnCtx", attributeValue);
            }
            if ((attributeValue = attributes.remove("authnInst")) instanceof String) {
                String value = (String)attributeValue;
                try {
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
                    Date date = fmt.parse(value);
                    attributes.put("org.sourceid.saml20.adapter.idp.authn.authnInst", date);
                }
                catch (Exception e) {
                    logger.log((LogEvent)LoggerMessage.DATE_PARSE_ERROR, e, value);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(externalApplicationFailureMessage = (String)attributes.get(EXTERNAL_APPLICATION_FAILURE_MESSAGE)))) {
                logger.log((LogEvent)LoggerMessage.AUTHN_FAILED_EXTERNAL_APP, externalApplicationFailureMessage);
                throw new AuthnAdapterException(externalApplicationFailureMessage);
            }
        }
        Map<String, Object> contractAttributes = this.prepareAttributeMap(attributes);
        logger.log((LogEvent)LoggerMessage.EXIT_LOOKUP_AUTHN, attributes.toString());
        authnAdapterResponse.setAttributeMap(contractAttributes);
    }

    private String pickupSSOContextAttributes(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inputParameters) throws ArtifactPersistenceServiceException, IOException {
        ReferenceIdParameters params = this.getInputParameters(inputParameters);
        String connectionId = this.getConnectionIdFromParams(params);
        String messageHandle = null;
        Map<String, Object> attributesToSend = this.assembleSSOContextAttributes(req, params);
        if (!attributesToSend.isEmpty()) {
            logger.log((LogEvent)LoggerMessage.ATTR_TO_SEND, LogCleaner.clean(attributesToSend.toString()));
            String sessionRefString = IDGenerator.rndAlphaNumeric((int)27);
            attributesToSend.put(SESSION_REFERENCE_ATTR_NAME, sessionRefString);
            messageHandle = this.storeAttrs(req, attributesToSend, connectionId);
        }
        if (!this.apiSupport.isApiRequest(req)) {
            this.submitFormRequestForSsoContextParameters(req, resp, params, connectionId, messageHandle);
        }
        return messageHandle;
    }

    private void submitFormRequestForSsoContextParameters(HttpServletRequest req, HttpServletResponse resp, ReferenceIdParameters params, String connectionId, String messageHandle) throws IOException {
        String authUrl = this.assembleAuthUrl(params, connectionId, messageHandle);
        logger.log((LogEvent)LoggerMessage.REDIRECT_MSG, authUrl);
        if (this.transportMode == 0) {
            Map paramMap;
            if (this.sendRequestParams == SEND_REQUEST_PARAMS_VALUES.TRACKED_PARAMS || this.sendRequestParams == SEND_REQUEST_PARAMS_VALUES.ALL) {
                for (Map.Entry<String, Collection<String>> entry : params.getTrackedParams().entrySet()) {
                    authUrl = QueryParamUtil.addQueryParameters(authUrl, entry.getKey(), entry.getValue());
                }
            }
            if (this.sendRequestParams == SEND_REQUEST_PARAMS_VALUES.ALL && (paramMap = req.getParameterMap()) != null) {
                for (Map.Entry entry : paramMap.entrySet()) {
                    String key2 = (String)entry.getKey();
                    String[] value2 = (String[])entry.getValue();
                    if (value2.length == 0 || value2[0] == null) continue;
                    authUrl = QueryParamUtil.addQueryParameter(authUrl, key2, value2[0]);
                }
            }
            resp.sendRedirect(authUrl);
        } else {
            HashMap<String, String> postParams = new HashMap<String, String>();
            Map map = req.getParameterMap();
            map.forEach((key, value) -> {
                if (((String[])value).length != 0 && value[0] != null) {
                    postParams.put(MarkupEntities.XSS.escape(key), MarkupEntities.XSS.escape(value[0]));
                }
            });
            postParams.put(this.getResumePathParamName(), params.getResumePath());
            if (params.getAuthnPolicy() != null) {
                postParams.put(ALLOW_INTERACT_PARAM_NAME, String.valueOf(params.getAuthnPolicy().allowUserInteraction()));
                postParams.put(REAUTH_PARAM_NAME, String.valueOf(params.getAuthnPolicy().reauthenticate()));
            }
            postParams.put(CONNECTION_ID_PARAM_NAME, connectionId);
            if (StringUtils.isNotBlank((CharSequence)messageHandle)) {
                postParams.put(this.getRefParamName(), messageHandle);
            }
            FormPost.post((String)this.authnEndpoint, postParams, (HttpServletResponse)resp);
        }
    }

    private boolean checkIsSSOContextAttributes(Map<String, Object> attributes) {
        Object ssoContextValue = attributes.get("isSsoContextVariable.flag");
        if (null != ssoContextValue && ssoContextValue instanceof String) {
            return Boolean.parseBoolean((String)ssoContextValue);
        }
        return false;
    }

    static {
        Method[] methods;
        logger = new IntegrationsLogger(IdpBackchannelReferenceAuthnAdapter.class);
        isSetDefaultForLegacyConfigMethodPresent = false;
        adapterInfo = new HashMap<String, Object>();
        adapterInfo.put(ADAPTER_INFO_EXTERNAL_CONSENT_ADAPTER, Boolean.TRUE);
        for (Method m : methods = CheckBoxFieldDescriptor.class.getMethods()) {
            if (!m.getName().equals("setDefaultForLegacyConfig")) continue;
            isSetDefaultForLegacyConfigMethodPresent = true;
            break;
        }
        REFERENCE_ID_MAPPING = new ParamMapping("REF", CheckReferenceId.class, CheckReferenceId::getDropoffReferenceId, Function.identity());
    }

    private static enum SEND_REQUEST_PARAMS_VALUES {
        NONE,
        ALL,
        TRACKED_PARAMS;

    }
}

