/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import shaded.refid.com.pingidentity.integrations.logger.LogEvent;
import shaded.refid.com.pingidentity.integrations.logger.LogLevel;

public enum LoggerMessage implements LogEvent
{
    MALFORMED_REF(LogLevel.INFO, "001", "REF is malformed, expecting %s hex encoded bytes"),
    INVALID_REF(LogLevel.DEBUG, "002", "Invalid REF : %s"),
    ATTRIBUTE_SERIALIZER_ERROR(LogLevel.ERROR, "003", "Could not create AttributeSerializer.  Will use default."),
    HOSTNAME_ERROR(LogLevel.WARN, "004", "Cannot check host name"),
    LOGOUT_MODE_MISCONFIGURATION(LogLevel.WARN, "005", "Adapter is configured for front channel logout but a back channel protocol message was received."),
    DATE_FORMAT_FAILURE(LogLevel.ERROR, "005", "Unable to format date to string with : %s"),
    DEFAULT_FIELD_FAILURE(LogLevel.WARN, "006", "This version of PingFederate doesn't support the ability to set default values for new fields."),
    REQUEST_REF_ID_FOR_USER_ATTRIBUTES_ERROR(LogLevel.DEBUG, "007", "The Reference ID received is for the request context, not user attributes."),
    DATE_PARSE_ERROR(LogLevel.ERROR, "008", "Unable to parse date from %s"),
    REF_ID_EXCHANGE(LogLevel.DEBUG, "009", "Reference %s exchanged to retrieve attributes %s"),
    ATTRIBUTES_EXCHANGE(LogLevel.DEBUG, "010", "Attributes %s stored in exchanged for reference %s"),
    SSL_TLS_REQUIRED_ERROR(LogLevel.INFO, "011", "SSL/TLS is required."),
    START_LOOKUP_AUTHN(LogLevel.DEBUG, "012", "Enter lookupAuthN at %s"),
    EXIT_LOOKUP_AUTHN(LogLevel.DEBUG, "013", "Exit lookupAuthN w/: %s"),
    AUTHN_FAILED_EXTERNAL_APP(LogLevel.DEBUG, "014", "Authentication failure triggered from external application with message: %s"),
    ATTR_TO_SEND(LogLevel.DEBUG, "015", "Attributes to send: %s"),
    REDIRECT_MSG(LogLevel.DEBUG, "016", "Redirecting to: %s"),
    REF(LogLevel.DEBUG, "017", "REF=%s"),
    BACKCHANNEL_MSG(LogLevel.DEBUG, "017", "Sending back channel logout to : %s"),
    REQUEST_RESPONSE(LogLevel.DEBUG, "018", "%1s returned status code %2s"),
    START_LOCAL_USER_ID(LogLevel.DEBUG, "019", "Enter lookupLocalUserId at %s"),
    EXIT_LOCAL_USER_ID(LogLevel.DEBUG, "020", "Exit lookupLocalUserId w/: %s"),
    RELOAD_SSL(LogLevel.DEBUG, "021", "Reloading SSL certificates."),
    PICKUP_HANDLER(LogLevel.DEBUG, "022", "++ In Pickup Handler ++"),
    DROP_OFF_HANDLER(LogLevel.DEBUG, "023", "++ In Dropoff Handler ++"),
    SERIALIZE_ATTR(LogLevel.DEBUG, "024", "JsonSerializer incoming attributes: %s"),
    SERIALIZER_KEY(LogLevel.DEBUG, "025", "Serializer key: %s"),
    SERIALIZER_VALUE(LogLevel.DEBUG, "026", "Serializer value: %s"),
    SERIALIZED_STRING(LogLevel.DEBUG, "027", "Serialized JSON String: %s"),
    NO_DATA_DESERIALIZER(LogLevel.DEBUG, "028", "No data presented to deserialize"),
    START_DESERIALIZER(LogLevel.DEBUG, "029", "Start Dropoff Deserialized Attributes"),
    DESERIALIZER_KEY(LogLevel.DEBUG, "030", "Deserializer key: %s"),
    DESERIALIZER_VALUE(LogLevel.DEBUG, "031", "Deserializer value: %s"),
    END_DESERIALIZER(LogLevel.DEBUG, "032", "End Dropoff Deserialized Attributes"),
    AUTHN_FAILED(LogLevel.DEBUG, "033", "Authentication failed"),
    INSTANCE_ID_FOUND(LogLevel.DEBUG, "034", "InstanceId found in request via header %1s or %2s: %3s"),
    MULTIPLE_ADAPTER_INSTANCE_ID(LogLevel.DEBUG, "035", "Multiple adapter instances are configured, %1s or %2s header is required with instance id value"),
    CREDENTIALS_MAPPED(LogLevel.DEBUG, "036", "Credentials mapped to adapter instance '%s'"),
    ATTEMPT_CERT_AUTH(LogLevel.DEBUG, "037", "Attempting certificate authentication"),
    ATTEMPT_AUTH_HEADER(LogLevel.DEBUG, "038", "Attempting simple proprietary auth looking for headers %1s/%2s and %3s/%4s"),
    BASIC_AUTH_PROVIDED(LogLevel.DEBUG, "039", "Basic Auth provided"),
    USER_PASS(LogLevel.DEBUG, "040", "username/pass: %1s/%2s"),
    CERT_DN(LogLevel.WARN, "041", "[%s] is not an acceptable Distinguished Name (DN).  Acceptable DNs are: [%s]"),
    EMPTY_PAYLOAD(LogLevel.INFO, "042", "Empty Payload"),
    LOGOUT_ENDPOINT_CONFIGURED_WITH_MODE_NONE(LogLevel.WARN, "043", "The 'Logout Service Endpoint' is configured with 'Logout Mode' set to 'None'. Please review if this is the intended configuration.");

    public static final String APP_MESSAGE_CODE = "IRID";
    private final LogLevel level;
    private final String code;
    private final String message;

    private LoggerMessage(LogLevel level, String code, String message) {
        this.level = level;
        this.code = code;
        this.message = message;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getCode() {
        return "IRID-" + this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

