/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import com.pingidentity.pf.adapters.referenceid.AttributeSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jose4j.json.JsonUtil;

public class PropertiesSerializer
implements AttributeSerializer {
    @Override
    public void serialize(Map<String, ?> attributes, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Properties props = new Properties();
        if (attributes != null) {
            for (Map.Entry<String, ?> e : attributes.entrySet()) {
                Object value = e.getValue();
                String key = e.getKey();
                if (value == null || key == null) continue;
                if (value instanceof String) {
                    props.put(key, value);
                    continue;
                }
                if (value instanceof Map) {
                    String jsonPayload = JsonUtil.toJson((Map)((Map)value));
                    props.put(key, jsonPayload);
                    continue;
                }
                props.put(key, value.toString());
            }
        }
        Set<String> keys = props.stringPropertyNames();
        String NEW_LINE = System.getProperty("line.separator");
        for (String key : keys) {
            String value = props.getProperty(key);
            resp.getWriter().write(key + "=" + value + NEW_LINE);
        }
        resp.flushBuffer();
    }
}

