/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid;

import com.pingidentity.pf.adapters.referenceid.BackchannelReferenceAuthnAdapter;
import com.pingidentity.pf.adapters.referenceid.LogCleaner;
import com.pingidentity.pf.adapters.referenceid.LoggerMessage;
import com.pingidentity.pf.adapters.referenceid.QueryParamUtil;
import com.pingidentity.pf.adapters.referenceid.TargetResourceUrlUtil;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.adapter.AuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.sp.authn.SpAuthenticationAdapter;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.saml20.service.ArtifactPersistenceServiceException;
import org.sourceid.websso.bindings.FormPost;
import shaded.refid.com.pingidentity.integrations.logger.IntegrationsLogger;
import shaded.refid.com.pingidentity.integrations.logger.LogEvent;

public class SpBackchannelReferenceAuthnAdapter
extends BackchannelReferenceAuthnAdapter
implements SpAuthenticationAdapter {
    private static final IntegrationsLogger logger = new IntegrationsLogger(SpBackchannelReferenceAuthnAdapter.class);
    private static final String AUTH_ENDPOINT_FIELD_NAME = "Authentication Endpoint";
    private static final String AUTH_LINK_ENDPOINT_FIELD_NAME = "Account Linking Authentication Endpoint";
    private String authnForLinkEndpoint = "https://";
    private String authnEndpoint = "https://";
    public static final String SESSION_REFERENCE_ATTR_NAME = "sessionid";
    private static final String TARGET_RESOURCE = "TargetResource";
    private static final String ENCODING = "UTF-8";
    private AuthnAdapterDescriptor descriptor;

    public AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor() {
        return this.adapterConfigurationGuiDescriptor(null);
    }

    public AdapterConfigurationGuiDescriptor adapterConfigurationGuiDescriptor(Configuration configuration) {
        AdapterConfigurationGuiDescriptor guiDesc = new AdapterConfigurationGuiDescriptor();
        String authnEpDesc = "Application endpoint URL where the end user is redirected for authentication.";
        TextFieldDescriptor authEndptFieldDesc = new TextFieldDescriptor(AUTH_ENDPOINT_FIELD_NAME, authnEpDesc);
        authEndptFieldDesc.addValidator((FieldValidator)HTTP_URL_VALIDATOR, true);
        authEndptFieldDesc.setSize(75);
        guiDesc.addField((FieldDescriptor)authEndptFieldDesc);
        this.addCommonGuiStuff(guiDesc, configuration);
        guiDesc.setDescription("The Reference ID Adapter allows user attributes to be passed in and out of the PingFederate server via direct HTTP(S) calls. Attributes are retrieved via a Reference ID.");
        String linkDesc = "The application endpoint URL where end users are redirected to obtain their local user IDs.";
        TextFieldDescriptor authnLinkEndPtFieldDesc = new TextFieldDescriptor(AUTH_LINK_ENDPOINT_FIELD_NAME, linkDesc);
        authnLinkEndPtFieldDesc.addValidator((FieldValidator)HTTP_URL_VALIDATOR, true);
        authnLinkEndPtFieldDesc.setSize(75);
        guiDesc.addField((FieldDescriptor)authnLinkEndPtFieldDesc);
        return guiDesc;
    }

    @Override
    String getMoreLogoutDesc() {
        return "";
    }

    public Serializable createAuthN(SsoContext ssoCtx, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        String authServiceURL = this.authnEndpoint;
        Map ssoCtxAttrs = ssoCtx.getSubjectAttrs();
        Map<String, Object> subjectAttrs = this.attributeMapToObjectMap(ssoCtxAttrs);
        String sessionRefString = IDGenerator.rndAlphaNumeric((int)27);
        subjectAttrs.put(SESSION_REFERENCE_ATTR_NAME, sessionRefString);
        try {
            subjectAttrs.put("authnCtx", ssoCtx.getAuthenticationContext());
            if (!StringUtils.isBlank((CharSequence)this.instanceId)) {
                subjectAttrs.put("instanceId", this.instanceId);
            }
            try {
                Date authenticationInstant = ssoCtx.getAuthenticationInstant();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
                String formatedDate = sdf.format(authenticationInstant);
                subjectAttrs.put("authnInst", formatedDate);
            }
            catch (Exception e) {
                logger.log((LogEvent)LoggerMessage.DATE_FORMAT_FAILURE, e, "yyyy-MM-dd HH:mm:ssZ");
            }
            String messageHandle = this.storeAttrs(req, subjectAttrs, ssoCtx.getIdpPartnerEntityId());
            String targetResourceUrl = ssoCtx.getTargetResourceUrl();
            targetResourceUrl = TargetResourceUrlUtil.removeRefParam(targetResourceUrl);
            boolean useAuthService = false;
            if (authServiceURL != null && authServiceURL.length() > 1 && !authServiceURL.equalsIgnoreCase("https://")) {
                useAuthService = true;
            }
            if (this.transportMode == 0) {
                if (useAuthService) {
                    targetResourceUrl = QueryParamUtil.addQueryParameter(authServiceURL, TARGET_RESOURCE, URLEncoder.encode(targetResourceUrl, ENCODING));
                    targetResourceUrl = QueryParamUtil.addQueryParameter(targetResourceUrl, this.getRefParamName(), messageHandle);
                    ssoCtx.setTargetResourceUrl(targetResourceUrl);
                } else {
                    targetResourceUrl = QueryParamUtil.addQueryParameter(targetResourceUrl, this.getRefParamName(), messageHandle);
                    ssoCtx.setTargetResourceUrl(targetResourceUrl);
                }
            } else {
                HashMap<String, String> postParams = new HashMap<String, String>();
                postParams.put(this.getRefParamName(), messageHandle);
                postParams.put(TARGET_RESOURCE, ssoCtx.getTargetResourceUrl());
                req.setAttribute("create.authn.complete", (Object)true);
                if (useAuthService) {
                    FormPost.post((String)authServiceURL, postParams, (HttpServletResponse)resp);
                } else {
                    FormPost.post((String)ssoCtx.getTargetResourceUrl(), postParams, (HttpServletResponse)resp);
                }
            }
        }
        catch (ArtifactPersistenceServiceException e) {
            throw new AuthnAdapterException("Problem storing message to be retrieved later.", (Throwable)e);
        }
        return sessionRefString;
    }

    public boolean logoutAuthN(Serializable authnBean, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        if (this.isResume(req, resumePath) || this.logoutMode == BackchannelReferenceAuthnAdapter.LogoutMode.NONE || StringUtils.isBlank((CharSequence)this.logoutSvcEndpoint)) {
            if (StringUtils.isNotBlank((CharSequence)this.logoutSvcEndpoint) && this.logoutMode == BackchannelReferenceAuthnAdapter.LogoutMode.NONE) {
                logger.log(LoggerMessage.LOGOUT_ENDPOINT_CONFIGURED_WITH_MODE_NONE);
            }
            return true;
        }
        String sessionReference = (String)((Object)authnBean);
        switch (this.logoutMode) {
            case BACK: {
                String svcEndpoint = QueryParamUtil.addQueryParameter(this.logoutSvcEndpoint, SESSION_REFERENCE_ATTR_NAME, sessionReference);
                return this.sendBackChannelLogout(svcEndpoint);
            }
            case FRONT: {
                try {
                    if (req == null) {
                        logger.log(LoggerMessage.LOGOUT_MODE_MISCONFIGURATION);
                        return false;
                    }
                    HashMap<String, Object> attrs = new HashMap<String, Object>();
                    attrs.put(this.getResumePathParamName(), resumePath);
                    attrs.put(SESSION_REFERENCE_ATTR_NAME, sessionReference);
                    String currentBaseUrl = this.getCurrentBaseUrl();
                    if (StringUtils.isNotBlank((CharSequence)currentBaseUrl)) {
                        attrs.put(this.getCurrentBaseUrlParamName(), currentBaseUrl);
                    }
                    String ref = this.storeAttrs(req, attrs, null);
                    if (this.transportMode == 0) {
                        String svcEndpt = QueryParamUtil.addQueryParameter(this.logoutSvcEndpoint, this.getRefParamName(), ref);
                        resp.sendRedirect(svcEndpt);
                        break;
                    }
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put(this.getRefParamName(), ref);
                    if (StringUtils.isNotBlank((CharSequence)currentBaseUrl)) {
                        postParams.put(this.getCurrentBaseUrlParamName(), currentBaseUrl);
                    }
                    FormPost.post((String)this.logoutSvcEndpoint, postParams, (HttpServletResponse)resp);
                    break;
                }
                catch (ArtifactPersistenceServiceException e) {
                    throw new AuthnAdapterException((Throwable)e);
                }
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public String lookupLocalUserId(HttpServletRequest req, HttpServletResponse resp, String partnerIdpEntityId, String resumePath) throws AuthnAdapterException, IOException {
        logger.log((LogEvent)LoggerMessage.START_LOCAL_USER_ID, LogCleaner.clean(req.getRequestURI()));
        if (StringUtils.isBlank((CharSequence)this.authnForLinkEndpoint)) {
            throw new AuthnAdapterException("Account Linking Authentication Endpoint must be configured to do account linking.");
        }
        try {
            Map<String, Object> attributes = this.retrieveAttributes(req);
            if ((attributes == null || attributes.isEmpty()) && !this.isResume(req, resumePath)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(this.getResumePathParamName(), resumePath);
                String ref = this.storeAttrs(req, params, partnerIdpEntityId);
                String authUrl = QueryParamUtil.addQueryParameter(this.authnForLinkEndpoint, this.getRefParamName(), ref);
                if (this.transportMode == 0) {
                    logger.log((LogEvent)LoggerMessage.REDIRECT_MSG, authUrl);
                    resp.sendRedirect(authUrl);
                } else {
                    HashMap<String, String> postParams = new HashMap<String, String>();
                    postParams.put(this.getResumePathParamName(), resumePath);
                    postParams.put(this.getRefParamName(), ref);
                    FormPost.post((String)this.authnForLinkEndpoint, postParams, (HttpServletResponse)resp);
                }
            }
            logger.log((LogEvent)LoggerMessage.EXIT_LOCAL_USER_ID, attributes != null ? attributes.toString() : "{}");
            if (attributes == null || attributes.isEmpty()) {
                return null;
            }
            return attributes.values().iterator().next().toString();
        }
        catch (ArtifactPersistenceServiceException e) {
            throw new AuthnAdapterException((Throwable)e);
        }
    }

    public AuthnAdapterDescriptor getAdapterDescriptor() {
        this.descriptor = new AuthnAdapterDescriptor(this, "Reference ID SP Adapter 2.2.1", DEFAULT_CONTRACT, true, this.adapterConfigurationGuiDescriptor()){

            public GuiConfigDescriptorBuilder getGuiConfigDescriptorBuilder() {
                return new GuiConfigDescriptorBuilder(){

                    public GuiConfigDescriptor buildNewGuiDescriptor() {
                        return SpBackchannelReferenceAuthnAdapter.this.adapterConfigurationGuiDescriptor();
                    }

                    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
                        return SpBackchannelReferenceAuthnAdapter.this.adapterConfigurationGuiDescriptor(configuration);
                    }
                };
            }
        };
        return this.descriptor;
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        this.authnForLinkEndpoint = configuration.getFieldValue(AUTH_LINK_ENDPOINT_FIELD_NAME);
        this.authnEndpoint = configuration.getFieldValue(AUTH_ENDPOINT_FIELD_NAME);
        SpBackchannelReferenceAuthnAdapter.reloadHandlers();
    }
}

