/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.adapters.referenceid.cert.util;

import com.pingidentity.pf.adapters.referenceid.LoggerMessage;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.StringUtils;
import shaded.refid.com.pingidentity.integrations.logger.IntegrationsLogger;
import shaded.refid.com.pingidentity.integrations.logger.LogEvent;

public class CertHelper {
    protected static IntegrationsLogger logger = new IntegrationsLogger(CertHelper.class);
    public static final String PIPE_SEPARATOR = "|";

    public static List<X500Principal> createDNList(String values) {
        String[] itemListArray;
        ArrayList<X500Principal> itemList = new ArrayList<X500Principal>();
        if (!StringUtils.isBlank((CharSequence)values) && (itemListArray = values.split("\\|")) != null && itemListArray.length > 0) {
            for (String item : itemListArray) {
                String tmpItem = item.trim();
                if (tmpItem.length() <= 0) continue;
                itemList.add(new X500Principal(tmpItem));
            }
        }
        return itemList;
    }

    public static boolean compareDN(X500Principal testPrincipal, List<X500Principal> acceptablePrincipals) {
        if (testPrincipal == null) {
            return false;
        }
        boolean isAcceptable = false;
        for (X500Principal p : acceptablePrincipals) {
            if (!CertHelper.compareDN(testPrincipal, p)) continue;
            isAcceptable = true;
            break;
        }
        if (!isAcceptable) {
            ArrayList<String> acceptablePrincipalNames = new ArrayList<String>();
            for (X500Principal p : acceptablePrincipals) {
                String acceptablePrincipalName = p.getName();
                acceptablePrincipalNames.add(acceptablePrincipalName);
            }
            logger.log((LogEvent)LoggerMessage.CERT_DN, testPrincipal, String.join((CharSequence)PIPE_SEPARATOR, acceptablePrincipalNames));
        }
        return isAcceptable;
    }

    public static boolean compareDN(X500Principal testPrincipal, X500Principal acceptablePrincipal) {
        boolean isAcceptable = false;
        String testPrincipalName = CertHelper.normalize(testPrincipal).getName("CANONICAL");
        String acceptablePrincipalName = CertHelper.normalize(acceptablePrincipal).getName("CANONICAL");
        if (acceptablePrincipalName.contains("*")) {
            String namePrefix = acceptablePrincipalName.substring(0, acceptablePrincipalName.indexOf("*"));
            String nameSuffix = acceptablePrincipalName.substring(acceptablePrincipalName.indexOf("*") + 1);
            if (StringUtils.isBlank((CharSequence)namePrefix) && StringUtils.isBlank((CharSequence)nameSuffix)) {
                isAcceptable = true;
            } else if (testPrincipalName.startsWith(namePrefix) && testPrincipalName.endsWith(nameSuffix)) {
                isAcceptable = true;
            }
        } else if (testPrincipalName.equalsIgnoreCase(acceptablePrincipalName)) {
            isAcceptable = true;
        }
        return isAcceptable;
    }

    private static X500Principal normalize(X500Principal principal) {
        return new X500Principal(principal.toString());
    }
}

