/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.http.javanet.NetHttpTransport;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.GoogleCredentials;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.DecryptRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.EncryptRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.KeyManagementServiceClient;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.stub.GrpcKeyManagementServiceStub;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.cloud.kms.v1.stub.KeyManagementServiceStubSettings;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.protobuf.ByteString;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class GcpKmsClientWrapper {
    private final KeyManagementServiceClient kmsClient;

    GcpKmsClientWrapper() {
        try {
            GoogleCredentials.getApplicationDefault(() -> {
                try {
                    TrustManager[] trustManagers = this.getCaCertsTrustManagers();
                    SSLContext tlsContext = SSLContext.getInstance("TLS");
                    tlsContext.init(null, trustManagers, null);
                    return new NetHttpTransport.Builder().setSslSocketFactory(tlsContext.getSocketFactory()).build();
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Failed to create SSLContext", e);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get default credentials", e);
        }
        try {
            InstantiatingGrpcChannelProvider transportChannelProvider = KeyManagementServiceStubSettings.defaultGrpcTransportProviderBuilder().setChannelConfigurator(channelBuilder -> {
                if (channelBuilder instanceof NettyChannelBuilder) {
                    NettyChannelBuilder nettyChannelBuilder = (NettyChannelBuilder)channelBuilder;
                    try {
                        TrustManagerFactory trustManagerFactory = this.getCaCertsTrustManagerFactory();
                        SslContext sslContext = GrpcSslContexts.forClient().trustManager(trustManagerFactory).build();
                        nettyChannelBuilder.sslContext(sslContext);
                    }
                    catch (SSLException e) {
                        throw new IllegalStateException("Failed to GrpcSslContexts", e);
                    }
                }
                return channelBuilder;
            }).build();
            KeyManagementServiceStubSettings settings = ((KeyManagementServiceStubSettings.Builder)KeyManagementServiceStubSettings.newBuilder().setTransportChannelProvider(transportChannelProvider)).build();
            GrpcKeyManagementServiceStub stub = GrpcKeyManagementServiceStub.create(settings);
            this.kmsClient = KeyManagementServiceClient.create(stub);
            Runtime.getRuntime().addShutdownHook(new Thread(this.kmsClient::close));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create KeyManagementServiceClient", e);
        }
    }

    byte[] encrypt(String cryptoKeyName, byte[] plainText) {
        EncryptRequest request = EncryptRequest.newBuilder().setName(cryptoKeyName).setPlaintext(ByteString.copyFrom(plainText)).build();
        return this.kmsClient.encrypt(request).getCiphertext().toByteArray();
    }

    byte[] decrypt(String cryptoKeyName, byte[] cipherText) {
        DecryptRequest request = DecryptRequest.newBuilder().setName(cryptoKeyName).setCiphertext(ByteString.copyFrom(cipherText)).build();
        return this.kmsClient.decrypt(request).getPlaintext().toByteArray();
    }

    private TrustManager[] getCaCertsTrustManagers() {
        return this.getCaCertsTrustManagerFactory().getTrustManagers();
    }

    private TrustManagerFactory getCaCertsTrustManagerFactory() {
        TrustManagerFactory trustManagerFactory;
        block9: {
            String javaHome = System.getProperty("java.home");
            if (javaHome == null) {
                throw new IllegalStateException("Expected java.home system property to be set");
            }
            Path cacerts = Paths.get(javaHome, new String[0]).resolve(Paths.get("lib/security/cacerts", new String[0]));
            InputStream inputStream = Files.newInputStream(cacerts, new OpenOption[0]);
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(inputStream, null);
                TrustManagerFactory trustManagerFactory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                PKIXBuilderParameters params = new PKIXBuilderParameters(ks, (CertSelector)new X509CertSelector());
                params.setRevocationEnabled(this.getBooleanProperty("com.sun.net.ssl.checkRevocation", false) && this.getBooleanProperty("pi.masterKeyEncryptor.checkRevocation", true));
                trustManagerFactory2.init(new CertPathTrustManagerParameters(params));
                trustManagerFactory = trustManagerFactory2;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new IllegalStateException("Failed to load Java trust store", e);
                }
            }
            inputStream.close();
        }
        return trustManagerFactory;
    }

    private boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        String strValue = System.getProperty(propertyName, Boolean.toString(defaultValue)).trim();
        return strValue.equalsIgnoreCase("true");
    }
}

