/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.core;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.InternalApi;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.annotations.VisibleForTesting;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Strings;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.protobuf.Any;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

@InternalApi
public class GaxProperties {
    private static final String DEFAULT_VERSION = "";
    private static final String GAX_VERSION = GaxProperties.getLibraryVersion(GaxProperties.class, "version.gax");
    private static final String JAVA_VERSION = GaxProperties.getRuntimeVersion();
    private static final String PROTOBUF_VERSION = GaxProperties.getProtobufVersion(Any.class, "com.pingidentity.pingcommons.gcp.key.shade.com.google.protobuf.RuntimeVersion");

    private GaxProperties() {
    }

    public static String getLibraryVersion(Class<?> libraryClass) {
        String version = libraryClass.getPackage().getImplementationVersion();
        return version != null ? version : DEFAULT_VERSION;
    }

    public static String getLibraryVersion(Class<?> libraryClass, String propertyName) {
        String version = null;
        if (!libraryClass.equals(GaxProperties.class) && !DEFAULT_VERSION.equals(version = GaxProperties.getLibraryVersion(libraryClass))) {
            return version;
        }
        try (InputStream in = libraryClass.getResourceAsStream("/dependencies.properties");){
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                version = props.getProperty(propertyName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version != null ? version : DEFAULT_VERSION;
    }

    public static String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static String getGaxVersion() {
        return GAX_VERSION;
    }

    public static String getProtobufVersion() {
        return PROTOBUF_VERSION;
    }

    @VisibleForTesting
    static String getRuntimeVersion() {
        String javaRuntimeInformation = System.getProperty("java.version", "null");
        String vendor = System.getProperty("java.vendor");
        if (!Strings.isNullOrEmpty(vendor)) {
            javaRuntimeInformation = String.format("%s__%s", javaRuntimeInformation, vendor);
            String vendorVersion = System.getProperty("java.vendor.version");
            if (!Strings.isNullOrEmpty(vendorVersion)) {
                javaRuntimeInformation = String.format("%s__%s", javaRuntimeInformation, vendorVersion);
            }
        }
        return javaRuntimeInformation.replaceAll("[^0-9a-zA-Z_\\\\.]", "-");
    }

    @VisibleForTesting
    static Optional<String> getBundleVersion(Class<?> clazz) {
        Optional<String> optional;
        File file = new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
        JarFile jar = new JarFile(file.getPath());
        try {
            Attributes attributes = jar.getManifest().getMainAttributes();
            optional = Optional.ofNullable(attributes.getValue("Bundle-Version"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        jar.close();
        return optional;
    }

    @VisibleForTesting
    static String getProtobufVersion(Class clazz, String protobufRuntimeVersionClassName) {
        try {
            Class<?> protobufRuntimeVersionClass = Class.forName(protobufRuntimeVersionClassName);
            return protobufRuntimeVersionClass.getField("MAJOR").get(null) + "." + protobufRuntimeVersionClass.getField("MINOR").get(null) + "." + protobufRuntimeVersionClass.getField("PATCH").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NullPointerException | SecurityException e) {
            return GaxProperties.getBundleVersion(clazz).orElse("3");
        }
    }
}

