/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.grpc;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.grpc.GrpcStatusCode;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.ApiException;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.ApiExceptionFactory;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.ErrorDetails;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.rpc.StatusCode;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.annotations.VisibleForTesting;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableSet;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.protobuf.InvalidProtocolBufferException;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.rpc.Status;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Set;

class GrpcApiExceptionFactory {
    @VisibleForTesting
    static final String ERROR_DETAIL_KEY = "grpc-status-details-bin";
    private final ImmutableSet<StatusCode.Code> retryableCodes;

    GrpcApiExceptionFactory(Set<StatusCode.Code> retryCodes) {
        this.retryableCodes = ImmutableSet.copyOf(retryCodes);
    }

    ApiException create(Throwable throwable) {
        if (throwable instanceof StatusException) {
            StatusException e = (StatusException)throwable;
            return this.create(throwable, e.getStatus().getCode(), e.getTrailers());
        }
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException e = (StatusRuntimeException)throwable;
            return this.create(throwable, e.getStatus().getCode(), e.getTrailers());
        }
        if (throwable instanceof ApiException) {
            return (ApiException)throwable;
        }
        return ApiExceptionFactory.createException(throwable, GrpcStatusCode.of(Status.Code.UNKNOWN), false);
    }

    private ApiException create(Throwable throwable, Status.Code statusCode, Metadata metadata) {
        Status status;
        boolean canRetry = this.retryableCodes.contains((Object)GrpcStatusCode.grpcCodeToStatusCode(statusCode));
        GrpcStatusCode grpcStatusCode = GrpcStatusCode.of(statusCode);
        if (metadata == null) {
            return ApiExceptionFactory.createException(throwable, grpcStatusCode, canRetry);
        }
        byte[] bytes = metadata.get(Metadata.Key.of(ERROR_DETAIL_KEY, Metadata.BINARY_BYTE_MARSHALLER));
        if (bytes == null) {
            return ApiExceptionFactory.createException(throwable, grpcStatusCode, canRetry);
        }
        try {
            status = Status.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            return ApiExceptionFactory.createException(throwable, grpcStatusCode, canRetry);
        }
        ErrorDetails.Builder errorDetailsBuilder = ErrorDetails.builder();
        errorDetailsBuilder.setRawErrorMessages(status.getDetailsList());
        return ApiExceptionFactory.createException(throwable, grpcStatusCode, canRetry, errorDetailsBuilder.build());
    }
}

