/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.nativeimage;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.InternalApi;
import com.pingidentity.pingcommons.gcp.key.shade.org.graalvm.nativeimage.hosted.Feature;
import com.pingidentity.pingcommons.gcp.key.shade.org.graalvm.nativeimage.hosted.RuntimeReflection;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class NativeImageUtils {
    private static final Logger LOGGER = Logger.getLogger(NativeImageUtils.class.getName());
    private static final String CLASS_REFLECTION_ERROR_MESSAGE = "Failed to find {0} on the classpath for reflection.";

    private NativeImageUtils() {
    }

    public static Method getMethodOrFail(Class<?> clazz, String methodName, Class<?> ... params) {
        try {
            return clazz.getDeclaredMethod(methodName, params);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Failed to find method %s for class %s", methodName, clazz.getName()), e);
        }
    }

    public static void registerForReflectiveInstantiation(Feature.FeatureAccess access, String className) {
        Class clazz = access.findClassByName(className);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
        } else {
            LOGGER.log(Level.WARNING, "Failed to find {0} on the classpath for reflective instantiation.", className);
        }
    }

    public static void registerConstructorsForReflection(Feature.FeatureAccess access, String name) {
        Class clazz = access.findClassByName(name);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
            RuntimeReflection.register((Executable[])clazz.getDeclaredConstructors());
        } else {
            LOGGER.log(Level.WARNING, CLASS_REFLECTION_ERROR_MESSAGE, name);
        }
    }

    public static void registerClassForReflection(Feature.FeatureAccess access, String name) {
        Class clazz = access.findClassByName(name);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
            RuntimeReflection.register((Executable[])clazz.getDeclaredConstructors());
            RuntimeReflection.register((Field[])clazz.getDeclaredFields());
            RuntimeReflection.register((Executable[])clazz.getDeclaredMethods());
        } else {
            LOGGER.log(Level.WARNING, CLASS_REFLECTION_ERROR_MESSAGE, name);
        }
    }

    public static void registerClassHierarchyForReflection(Feature.FeatureAccess access, String className) {
        Class clazz = access.findClassByName(className);
        if (clazz != null) {
            NativeImageUtils.registerClassForReflection(access, className);
            for (Class<?> nestedClass : clazz.getDeclaredClasses()) {
                if (Modifier.isPrivate(nestedClass.getModifiers())) continue;
                NativeImageUtils.registerClassHierarchyForReflection(access, nestedClass.getName());
            }
        } else {
            LOGGER.log(Level.WARNING, CLASS_REFLECTION_ERROR_MESSAGE, className);
        }
    }

    public static void registerForUnsafeFieldAccess(Feature.FeatureAccess access, String className, String ... fields) {
        Class clazz = access.findClassByName(className);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
            for (String fieldName : fields) {
                try {
                    RuntimeReflection.register((Field[])new Field[]{clazz.getDeclaredField(fieldName)});
                }
                catch (NoSuchFieldException ex) {
                    LOGGER.warning("Failed to register field " + fieldName + " for class " + className);
                    LOGGER.warning(ex.getMessage());
                }
            }
        } else {
            LOGGER.log(Level.WARNING, "Failed to find {0} on the classpath for unsafe fields access registration.", className);
        }
    }
}

