/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.retrying;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ApiFuture;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ApiFutures;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.BetaApi;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.core.ListenableFutureToApiFuture;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.retrying.CallbackChainRetryingFuture;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.retrying.NoopRetryingContext;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.retrying.RetryAlgorithm;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.retrying.RetryingContext;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.gax.retrying.RetryingFuture;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledRetryingExecutor<ResponseT>
implements RetryingExecutorWithContext<ResponseT> {
    private final RetryAlgorithm<ResponseT> retryAlgorithm;
    private final ListeningScheduledExecutorService scheduler;

    public ScheduledRetryingExecutor(RetryAlgorithm<ResponseT> retryAlgorithm, ScheduledExecutorService scheduler) {
        this.retryAlgorithm = retryAlgorithm;
        this.scheduler = MoreExecutors.listeningDecorator(scheduler);
    }

    @Override
    public RetryingFuture<ResponseT> createFuture(Callable<ResponseT> callable) {
        return this.createFuture(callable, NoopRetryingContext.create());
    }

    @Override
    @BetaApi(value="The surface for passing per operation state is not yet stable")
    public RetryingFuture<ResponseT> createFuture(Callable<ResponseT> callable, RetryingContext context) {
        return new CallbackChainRetryingFuture<ResponseT>(callable, this.retryAlgorithm, this, context);
    }

    @Override
    public ApiFuture<ResponseT> submit(RetryingFuture<ResponseT> retryingFuture) {
        try {
            ScheduledFuture attemptFuture = this.scheduler.schedule((Callable)retryingFuture.getCallable(), retryingFuture.getAttemptSettings().getRandomizedRetryDelayDuration().toMillis(), TimeUnit.MILLISECONDS);
            return new ListenableFutureToApiFuture(attemptFuture);
        }
        catch (RejectedExecutionException e) {
            return ApiFutures.immediateFailedFuture(e);
        }
    }
}

