/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.http.GenericUrl;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.http.HttpRequest;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.http.HttpRequestFactory;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.http.HttpResponse;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.http.HttpResponseException;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.http.HttpTransport;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.http.UrlEncodedContent;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.http.javanet.NetHttpTransport;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.json.JsonFactory;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.json.JsonObjectParser;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.json.webtoken.JsonWebSignature;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.json.webtoken.JsonWebToken;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.api.client.util.GenericData;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.http.HttpTransportFactory;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.AccessToken;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.GoogleAuthException;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.GoogleCredentials;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.auth.oauth2.OAuth2Utils;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.annotations.VisibleForTesting;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.MoreObjects;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class GdchCredentials
extends GoogleCredentials {
    static final String SUPPORTED_FORMAT_VERSION = "1";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private static final int DEFAULT_LIFETIME_IN_SECONDS = 3600;
    private final PrivateKey privateKey;
    private final String privateKeyId;
    private final String projectId;
    private final String serviceIdentityName;
    private final URI tokenServerUri;
    private final URI apiAudience;
    private final int lifetime;
    private final String transportFactoryClassName;
    private final String caCertPath;
    private transient HttpTransportFactory transportFactory;

    @VisibleForTesting
    GdchCredentials(Builder builder) {
        this.projectId = Preconditions.checkNotNull(builder.projectId);
        this.privateKeyId = Preconditions.checkNotNull(builder.privateKeyId);
        this.privateKey = Preconditions.checkNotNull(builder.privateKey);
        this.serviceIdentityName = Preconditions.checkNotNull(builder.serviceIdentityName);
        this.tokenServerUri = Preconditions.checkNotNull(builder.tokenServerUri);
        this.transportFactory = Preconditions.checkNotNull(builder.transportFactory);
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        this.caCertPath = builder.caCertPath;
        this.apiAudience = builder.apiAudience;
        this.lifetime = builder.lifetime;
    }

    static GdchCredentials fromJson(Map<String, Object> json) throws IOException {
        String caCertPath = (String)json.get("ca_cert_path");
        return GdchCredentials.fromJson(json, new TransportFactoryForGdch(caCertPath));
    }

    @VisibleForTesting
    static GdchCredentials fromJson(Map<String, Object> json, HttpTransportFactory transportFactory) throws IOException {
        String formatVersion = GdchCredentials.validateField((String)json.get("format_version"), "format_version");
        String projectId = GdchCredentials.validateField((String)json.get("project"), "project");
        String privateKeyId = GdchCredentials.validateField((String)json.get("private_key_id"), "private_key_id");
        String privateKeyPkcs8 = GdchCredentials.validateField((String)json.get("private_key"), "private_key");
        String serviceIdentityName = GdchCredentials.validateField((String)json.get("name"), "name");
        String tokenServerUriStringFromCreds = GdchCredentials.validateField((String)json.get("token_uri"), "token_uri");
        String caCertPath = (String)json.get("ca_cert_path");
        if (!SUPPORTED_FORMAT_VERSION.equals(formatVersion)) {
            throw new IOException(String.format("Only format version %s is supported.", SUPPORTED_FORMAT_VERSION));
        }
        URI tokenServerUriFromCreds = null;
        try {
            tokenServerUriFromCreds = new URI(tokenServerUriStringFromCreds);
        }
        catch (URISyntaxException e) {
            throw new IOException("Token server URI specified in 'token_uri' could not be parsed.");
        }
        Builder builder = GdchCredentials.newBuilder().setProjectId(projectId).setPrivateKeyId(privateKeyId).setTokenServerUri(tokenServerUriFromCreds).setServiceIdentityName(serviceIdentityName).setCaCertPath(caCertPath).setHttpTransportFactory(transportFactory);
        return GdchCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    static GdchCredentials fromPkcs8(String privateKeyPkcs8, Builder builder) throws IOException {
        PrivateKey privateKey = OAuth2Utils.privateKeyFromPkcs8(privateKeyPkcs8);
        builder.setPrivateKey(privateKey);
        return new GdchCredentials(builder);
    }

    public GdchCredentials createWithGdchAudience(URI apiAudience) throws IOException {
        Preconditions.checkNotNull(apiAudience, "Audience are not configured for GDCH service account credentials.");
        return this.toBuilder().setGdchAudience(apiAudience).build();
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        HttpResponse response;
        Preconditions.checkNotNull(this.apiAudience, "Audience are not configured for GDCH service account. Specify the audience by calling createWithGDCHAudience.");
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        long currentTime = this.clock.currentTimeMillis();
        String assertion = this.createAssertion(jsonFactory, currentTime, this.getApiAudience());
        GenericData tokenRequest = new GenericData();
        tokenRequest.set("grant_type", "urn:ietf:params:oauth:token-type:token-exchange");
        tokenRequest.set("assertion", assertion);
        UrlEncodedContent content = new UrlEncodedContent(tokenRequest);
        HttpRequestFactory requestFactory = this.transportFactory.create().createRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(this.tokenServerUri), content);
        request.setParser(new JsonObjectParser(jsonFactory));
        String errorTemplate = "Error getting access token for GDCH service account: %s, iss: %s";
        try {
            response = request.execute();
        }
        catch (HttpResponseException re) {
            String message = String.format(errorTemplate, re.getMessage(), this.getServiceIdentityName());
            throw GoogleAuthException.createWithTokenEndpointResponseException(re, message);
        }
        catch (IOException e) {
            throw GoogleAuthException.createWithTokenEndpointIOException(e, String.format(errorTemplate, e.getMessage(), this.getServiceIdentityName()));
        }
        GenericData responseData = response.parseAs(GenericData.class);
        String accessToken = OAuth2Utils.validateString(responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32(responseData, "expires_in", PARSE_ERROR_PREFIX);
        long expiresAtMilliseconds = this.clock.currentTimeMillis() + (long)expiresInSeconds * 1000L;
        return new AccessToken(accessToken, new Date(expiresAtMilliseconds));
    }

    String createAssertion(JsonFactory jsonFactory, long currentTime, URI apiAudience) throws IOException {
        String assertion;
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        header.setKeyId(this.privateKeyId);
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        payload.setIssuer(GdchCredentials.getIssuerSubjectValue(this.projectId, this.serviceIdentityName));
        payload.setSubject(GdchCredentials.getIssuerSubjectValue(this.projectId, this.serviceIdentityName));
        payload.setIssuedAtTimeSeconds(currentTime / 1000L);
        payload.setExpirationTimeSeconds(currentTime / 1000L + (long)this.lifetime);
        payload.setAudience(this.getTokenServerUri().toString());
        try {
            payload.set("api_audience", apiAudience.toString());
            assertion = JsonWebSignature.signUsingRsaSha256(this.privateKey, jsonFactory, header, payload);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error signing service account access token request with private key.", e);
        }
        return assertion;
    }

    @VisibleForTesting
    static String getIssuerSubjectValue(String projectId, String serviceIdentityName) {
        return String.format("system:serviceaccount:%s:%s", projectId, serviceIdentityName);
    }

    public final String getProjectId() {
        return this.projectId;
    }

    public final String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final String getServiceIdentityName() {
        return this.serviceIdentityName;
    }

    public final URI getTokenServerUri() {
        return this.tokenServerUri;
    }

    public final URI getApiAudience() {
        return this.apiAudience;
    }

    public final HttpTransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    public final String getCaCertPath() {
        return this.caCertPath;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.transportFactory = (HttpTransportFactory)GdchCredentials.newInstance(this.transportFactoryClassName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.projectId, this.privateKeyId, this.privateKey, this.serviceIdentityName, this.tokenServerUri, this.transportFactoryClassName, this.apiAudience, this.caCertPath, this.lifetime);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("projectId", this.projectId).add("privateKeyId", this.privateKeyId).add("serviceIdentityName", this.serviceIdentityName).add("tokenServerUri", this.tokenServerUri).add("transportFactoryClassName", this.transportFactoryClassName).add("caCertPath", this.caCertPath).add("apiAudience", this.apiAudience).add("lifetime", this.lifetime).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GdchCredentials)) {
            return false;
        }
        GdchCredentials other = (GdchCredentials)obj;
        return Objects.equals(this.projectId, other.projectId) && Objects.equals(this.privateKeyId, other.privateKeyId) && Objects.equals(this.privateKey, other.privateKey) && Objects.equals(this.serviceIdentityName, other.serviceIdentityName) && Objects.equals(this.tokenServerUri, other.tokenServerUri) && Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName) && Objects.equals(this.apiAudience, other.apiAudience) && Objects.equals(this.caCertPath, other.caCertPath) && Objects.equals(this.lifetime, other.lifetime);
    }

    static InputStream readStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private static String validateField(String field, String fieldName) throws IOException {
        if (field == null || field.isEmpty()) {
            throw new IOException(String.format("Error reading GDCH service account credential from JSON, %s is misconfigured.", fieldName));
        }
        return field;
    }

    static class TransportFactoryForGdch
    implements HttpTransportFactory {
        HttpTransport transport;

        public TransportFactoryForGdch(String caCertPath) throws IOException {
            this.setTransport(caCertPath);
        }

        @Override
        public HttpTransport create() {
            return this.transport;
        }

        private void setTransport(String caCertPath) throws IOException {
            if (caCertPath == null || caCertPath.isEmpty()) {
                this.transport = new NetHttpTransport();
                return;
            }
            try {
                InputStream certificateStream = GdchCredentials.readStream(new File(caCertPath));
                this.transport = new NetHttpTransport.Builder().trustCertificatesFromStream(certificateStream).build();
            }
            catch (IOException e) {
                throw new IOException(String.format("Error reading certificate file from CA cert path, value '%s': %s", caCertPath, e.getMessage()), e);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Error initiating transport with certificate stream.", e);
            }
        }
    }

    public static class Builder
    extends GoogleCredentials.Builder {
        private String projectId;
        private String privateKeyId;
        private PrivateKey privateKey;
        private String serviceIdentityName;
        private URI tokenServerUri;
        private URI apiAudience;
        private HttpTransportFactory transportFactory;
        private String caCertPath;
        private int lifetime = 3600;

        protected Builder() {
        }

        protected Builder(GdchCredentials credentials) {
            this.projectId = credentials.projectId;
            this.privateKeyId = credentials.privateKeyId;
            this.privateKey = credentials.privateKey;
            this.serviceIdentityName = credentials.serviceIdentityName;
            this.tokenServerUri = credentials.tokenServerUri;
            this.transportFactory = credentials.transportFactory;
            this.caCertPath = credentials.caCertPath;
            this.lifetime = credentials.lifetime;
        }

        @CanIgnoreReturnValue
        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrivateKeyId(String privateKeyId) {
            this.privateKeyId = privateKeyId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setServiceIdentityName(String name) {
            this.serviceIdentityName = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTokenServerUri(URI tokenServerUri) {
            this.tokenServerUri = tokenServerUri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaCertPath(String caCertPath) {
            this.caCertPath = caCertPath;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setGdchAudience(URI apiAudience) {
            this.apiAudience = apiAudience;
            return this;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getPrivateKeyId() {
            return this.privateKeyId;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public String getServiceIdentityName() {
            return this.serviceIdentityName;
        }

        public URI getTokenServerUri() {
            return this.tokenServerUri;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.transportFactory;
        }

        public String getCaCertPath() {
            return this.caCertPath;
        }

        public int getLifetime() {
            return this.lifetime;
        }

        @Override
        public GdchCredentials build() {
            return new GdchCredentials(this);
        }
    }
}

