/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.common.graph;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableSet;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.Iterators;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.UnmodifiableIterator;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.CheckForNull;
import java.util.AbstractSet;
import java.util.Map;

@ElementTypesAreNonnullByDefault
final class EdgesConnecting<E>
extends AbstractSet<E> {
    private final Map<?, E> nodeToOutEdge;
    private final Object targetNode;

    EdgesConnecting(Map<?, E> nodeToEdgeMap, Object targetNode) {
        this.nodeToOutEdge = Preconditions.checkNotNull(nodeToEdgeMap);
        this.targetNode = Preconditions.checkNotNull(targetNode);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge == null ? ImmutableSet.of().iterator() : Iterators.singletonIterator(connectingEdge);
    }

    @Override
    public int size() {
        return this.getConnectingEdge() == null ? 0 : 1;
    }

    @Override
    public boolean contains(@CheckForNull Object edge) {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge != null && connectingEdge.equals(edge);
    }

    @CheckForNull
    private E getConnectingEdge() {
        return this.nodeToOutEdge.get(this.targetNode);
    }
}

