/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j.MatcherInput;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j.Pattern;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j.RE2;
import java.util.Map;

public final class Matcher {
    private final Pattern pattern;
    private final int[] groups;
    private final Map<String, Integer> namedGroups;
    private final int groupCount;
    private MatcherInput matcherInput;
    private int inputLength;
    private int appendPos;
    private boolean hasMatch;
    private boolean hasGroups;
    private int anchorFlag;

    private Matcher(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        this.pattern = pattern;
        RE2 re2 = pattern.re2();
        this.groupCount = re2.numberOfCapturingGroups();
        this.groups = new int[2 + 2 * this.groupCount];
        this.namedGroups = re2.namedGroups;
    }

    Matcher(Pattern pattern, CharSequence input) {
        this(pattern);
        this.reset(input);
    }

    Matcher(Pattern pattern, MatcherInput input) {
        this(pattern);
        this.reset(input);
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Matcher reset() {
        this.inputLength = this.matcherInput.length();
        this.appendPos = 0;
        this.hasMatch = false;
        this.hasGroups = false;
        return this;
    }

    public Matcher reset(CharSequence input) {
        return this.reset(MatcherInput.utf16(input));
    }

    public Matcher reset(byte[] bytes) {
        return this.reset(MatcherInput.utf8(bytes));
    }

    private Matcher reset(MatcherInput input) {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        this.matcherInput = input;
        this.reset();
        return this;
    }

    public int start() {
        return this.start(0);
    }

    public int end() {
        return this.end(0);
    }

    public int start(int group) {
        this.loadGroup(group);
        return this.groups[2 * group];
    }

    public int start(String group) {
        Integer g2 = this.namedGroups.get(group);
        if (g2 == null) {
            throw new IllegalArgumentException("group '" + group + "' not found");
        }
        return this.start(g2);
    }

    public int end(int group) {
        this.loadGroup(group);
        return this.groups[2 * group + 1];
    }

    public int end(String group) {
        Integer g2 = this.namedGroups.get(group);
        if (g2 == null) {
            throw new IllegalArgumentException("group '" + group + "' not found");
        }
        return this.end(g2);
    }

    public String group() {
        return this.group(0);
    }

    public String group(int group) {
        int start = this.start(group);
        int end = this.end(group);
        if (start < 0 && end < 0) {
            return null;
        }
        return this.substring(start, end);
    }

    public String group(String group) {
        Integer g2 = this.namedGroups.get(group);
        if (g2 == null) {
            throw new IllegalArgumentException("group '" + group + "' not found");
        }
        return this.group(g2);
    }

    public int groupCount() {
        return this.groupCount;
    }

    private void loadGroup(int group) {
        boolean ok;
        if (group < 0 || group > this.groupCount) {
            throw new IndexOutOfBoundsException("Group index out of bounds: " + group);
        }
        if (!this.hasMatch) {
            throw new IllegalStateException("perhaps no match attempted");
        }
        if (group == 0 || this.hasGroups) {
            return;
        }
        int end = this.groups[1] + 1;
        if (end > this.inputLength) {
            end = this.inputLength;
        }
        if (!(ok = this.pattern.re2().match(this.matcherInput, this.groups[0], end, this.anchorFlag, this.groups, 1 + this.groupCount))) {
            throw new IllegalStateException("inconsistency in matching group data");
        }
        this.hasGroups = true;
    }

    public boolean matches() {
        return this.genMatch(0, 2);
    }

    public boolean lookingAt() {
        return this.genMatch(0, 1);
    }

    public boolean find() {
        int start = 0;
        if (this.hasMatch) {
            start = this.groups[1];
            if (this.groups[0] == this.groups[1]) {
                ++start;
            }
        }
        return this.genMatch(start, 0);
    }

    public boolean find(int start) {
        if (start < 0 || start > this.inputLength) {
            throw new IndexOutOfBoundsException("start index out of bounds: " + start);
        }
        this.reset();
        return this.genMatch(start, 0);
    }

    private boolean genMatch(int startByte, int anchor) {
        boolean ok = this.pattern.re2().match(this.matcherInput, startByte, this.inputLength, anchor, this.groups, 1);
        if (!ok) {
            return false;
        }
        this.hasMatch = true;
        this.hasGroups = false;
        this.anchorFlag = anchor;
        return true;
    }

    String substring(int start, int end) {
        if (this.matcherInput.getEncoding() == MatcherInput.Encoding.UTF_8) {
            return new String(this.matcherInput.asBytes(), start, end - start);
        }
        return this.matcherInput.asCharSequence().subSequence(start, end).toString();
    }

    int inputLength() {
        return this.inputLength;
    }

    public static String quoteReplacement(String s2) {
        if (s2.indexOf(92) < 0 && s2.indexOf(36) < 0) {
            return s2;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\\' || c == '$') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        StringBuilder result = new StringBuilder();
        this.appendReplacement(result, replacement);
        sb.append((CharSequence)result);
        return this;
    }

    public Matcher appendReplacement(StringBuilder sb, String replacement) {
        int s2 = this.start();
        int e = this.end();
        if (this.appendPos < s2) {
            sb.append(this.substring(this.appendPos, s2));
        }
        this.appendPos = e;
        this.appendReplacementInternal(sb, replacement);
        return this;
    }

    private void appendReplacementInternal(StringBuilder sb, String replacement) {
        int last = 0;
        int m4 = replacement.length();
        for (int i = 0; i < m4 - 1; ++i) {
            int j;
            if (replacement.charAt(i) == '\\') {
                if (last < i) {
                    sb.append(replacement.substring(last, i));
                }
                last = ++i;
                continue;
            }
            if (replacement.charAt(i) != '$') continue;
            char c = replacement.charAt(i + 1);
            if ('0' <= c && c <= '9') {
                int n = c - 48;
                if (last < i) {
                    sb.append(replacement.substring(last, i));
                }
                i += 2;
                while (i < m4 && (c = replacement.charAt(i)) >= '0' && c <= '9' && n * 10 + c - 48 <= this.groupCount) {
                    n = n * 10 + c - 48;
                    ++i;
                }
                if (n > this.groupCount) {
                    throw new IndexOutOfBoundsException("n > number of groups: " + n);
                }
                String group = this.group(n);
                if (group != null) {
                    sb.append(group);
                }
                last = i--;
                continue;
            }
            if (c != '{') continue;
            if (last < i) {
                sb.append(replacement.substring(last, i));
            }
            for (j = ++i + 1; j < replacement.length() && replacement.charAt(j) != '}' && replacement.charAt(j) != ' '; ++j) {
            }
            if (j == replacement.length() || replacement.charAt(j) != '}') {
                throw new IllegalArgumentException("named capture group is missing trailing '}'");
            }
            String groupName = replacement.substring(i + 1, j);
            sb.append(this.group(groupName));
            last = j + 1;
        }
        if (last < m4) {
            sb.append(replacement, last, m4);
        }
    }

    public StringBuffer appendTail(StringBuffer sb) {
        sb.append(this.substring(this.appendPos, this.inputLength));
        return sb;
    }

    public StringBuilder appendTail(StringBuilder sb) {
        sb.append(this.substring(this.appendPos, this.inputLength));
        return sb;
    }

    public String replaceAll(String replacement) {
        return this.replace(replacement, true);
    }

    public String replaceFirst(String replacement) {
        return this.replace(replacement, false);
    }

    private String replace(String replacement, boolean all) {
        this.reset();
        StringBuffer sb = new StringBuffer();
        while (this.find()) {
            this.appendReplacement(sb, replacement);
            if (all) continue;
        }
        this.appendTail(sb);
        return sb.toString();
    }
}

