/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j.CharClass;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j.CharGroup;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j.PatternSyntaxException;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j.Regexp;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j.Unicode;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j.UnicodeTables;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.re2j.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class Parser {
    private static final String ERR_INTERNAL_ERROR = "regexp/syntax: internal error";
    private static final String ERR_INVALID_CHAR_CLASS = "invalid character class";
    private static final String ERR_INVALID_CHAR_RANGE = "invalid character class range";
    private static final String ERR_INVALID_ESCAPE = "invalid escape sequence";
    private static final String ERR_INVALID_NAMED_CAPTURE = "invalid named capture";
    private static final String ERR_INVALID_PERL_OP = "invalid or unsupported Perl syntax";
    private static final String ERR_INVALID_REPEAT_OP = "invalid nested repetition operator";
    private static final String ERR_INVALID_REPEAT_SIZE = "invalid repeat count";
    private static final String ERR_MISSING_BRACKET = "missing closing ]";
    private static final String ERR_MISSING_PAREN = "missing closing )";
    private static final String ERR_MISSING_REPEAT_ARGUMENT = "missing argument to repetition operator";
    private static final String ERR_TRAILING_BACKSLASH = "trailing backslash at end of expression";
    private static final String ERR_DUPLICATE_NAMED_CAPTURE = "duplicate capture group name";
    private final String wholeRegexp;
    private int flags;
    private final Stack stack = new Stack();
    private Regexp free;
    private int numCap = 0;
    private final Map<String, Integer> namedGroups = new HashMap<String, Integer>();
    private static final int[][] ANY_TABLE = new int[][]{{0, 0x10FFFF, 1}};

    Parser(String wholeRegexp, int flags) {
        this.wholeRegexp = wholeRegexp;
        this.flags = flags;
    }

    private Regexp newRegexp(Regexp.Op op) {
        Regexp re = this.free;
        if (re != null && re.subs != null && re.subs.length > 0) {
            this.free = re.subs[0];
            re.reinit();
            re.op = op;
        } else {
            re = new Regexp(op);
        }
        return re;
    }

    private void reuse(Regexp re) {
        if (re.subs != null && re.subs.length > 0) {
            re.subs[0] = this.free;
        }
        this.free = re;
    }

    private Regexp pop() {
        return (Regexp)this.stack.remove(this.stack.size() - 1);
    }

    private Regexp[] popToPseudo() {
        int n;
        int i;
        for (i = n = this.stack.size(); i > 0 && !((Regexp)this.stack.get((int)(i - 1))).op.isPseudo(); --i) {
        }
        Regexp[] r = this.stack.subList(i, n).toArray(new Regexp[n - i]);
        this.stack.removeRange(i, n);
        return r;
    }

    private Regexp push(Regexp re) {
        if (re.op == Regexp.Op.CHAR_CLASS && re.runes.length == 2 && re.runes[0] == re.runes[1]) {
            if (this.maybeConcat(re.runes[0], this.flags & 0xFFFFFFFE)) {
                return null;
            }
            re.op = Regexp.Op.LITERAL;
            re.runes = new int[]{re.runes[0]};
            re.flags = this.flags & 0xFFFFFFFE;
        } else if (re.op == Regexp.Op.CHAR_CLASS && re.runes.length == 4 && re.runes[0] == re.runes[1] && re.runes[2] == re.runes[3] && Unicode.simpleFold(re.runes[0]) == re.runes[2] && Unicode.simpleFold(re.runes[2]) == re.runes[0] || re.op == Regexp.Op.CHAR_CLASS && re.runes.length == 2 && re.runes[0] + 1 == re.runes[1] && Unicode.simpleFold(re.runes[0]) == re.runes[1] && Unicode.simpleFold(re.runes[1]) == re.runes[0]) {
            if (this.maybeConcat(re.runes[0], this.flags | 1)) {
                return null;
            }
            re.op = Regexp.Op.LITERAL;
            re.runes = new int[]{re.runes[0]};
            re.flags = this.flags | 1;
        } else {
            this.maybeConcat(-1, 0);
        }
        this.stack.add(re);
        return re;
    }

    private boolean maybeConcat(int r, int flags) {
        int n = this.stack.size();
        if (n < 2) {
            return false;
        }
        Regexp re1 = (Regexp)this.stack.get(n - 1);
        Regexp re2 = (Regexp)this.stack.get(n - 2);
        if (re1.op != Regexp.Op.LITERAL || re2.op != Regexp.Op.LITERAL || (re1.flags & 1) != (re2.flags & 1)) {
            return false;
        }
        re2.runes = Parser.concatRunes(re2.runes, re1.runes);
        if (r >= 0) {
            re1.runes = new int[]{r};
            re1.flags = flags;
            return true;
        }
        this.pop();
        this.reuse(re1);
        return false;
    }

    private Regexp newLiteral(int r, int flags) {
        Regexp re = this.newRegexp(Regexp.Op.LITERAL);
        re.flags = flags;
        if ((flags & 1) != 0) {
            r = Parser.minFoldRune(r);
        }
        re.runes = new int[]{r};
        return re;
    }

    private static int minFoldRune(int r) {
        if (r < 65 || r > 66639) {
            return r;
        }
        int min2 = r;
        int r0 = r;
        r = Unicode.simpleFold(r);
        while (r != r0) {
            if (min2 > r) {
                min2 = r;
            }
            r = Unicode.simpleFold(r);
        }
        return min2;
    }

    private void literal(int r) {
        this.push(this.newLiteral(r, this.flags));
    }

    private Regexp op(Regexp.Op op) {
        Regexp re = this.newRegexp(op);
        re.flags = this.flags;
        return this.push(re);
    }

    private void repeat(Regexp.Op op, int min2, int max, int beforePos, StringIterator t2, int lastRepeatPos) throws PatternSyntaxException {
        int n;
        int flags = this.flags;
        if ((flags & 0x40) != 0) {
            if (t2.more() && t2.lookingAt('?')) {
                t2.skip(1);
                flags ^= 0x20;
            }
            if (lastRepeatPos != -1) {
                throw new PatternSyntaxException(ERR_INVALID_REPEAT_OP, t2.from(lastRepeatPos));
            }
        }
        if ((n = this.stack.size()) == 0) {
            throw new PatternSyntaxException(ERR_MISSING_REPEAT_ARGUMENT, t2.from(beforePos));
        }
        Regexp sub = (Regexp)this.stack.get(n - 1);
        if (sub.op.isPseudo()) {
            throw new PatternSyntaxException(ERR_MISSING_REPEAT_ARGUMENT, t2.from(beforePos));
        }
        Regexp re = this.newRegexp(op);
        re.min = min2;
        re.max = max;
        re.flags = flags;
        re.subs = new Regexp[]{sub};
        this.stack.set(n - 1, re);
    }

    private Regexp concat() {
        this.maybeConcat(-1, 0);
        Regexp[] subs = this.popToPseudo();
        if (subs.length == 0) {
            return this.push(this.newRegexp(Regexp.Op.EMPTY_MATCH));
        }
        return this.push(this.collapse(subs, Regexp.Op.CONCAT));
    }

    private Regexp alternate() {
        Regexp[] subs = this.popToPseudo();
        if (subs.length > 0) {
            this.cleanAlt(subs[subs.length - 1]);
        }
        if (subs.length == 0) {
            return this.push(this.newRegexp(Regexp.Op.NO_MATCH));
        }
        return this.push(this.collapse(subs, Regexp.Op.ALTERNATE));
    }

    private void cleanAlt(Regexp re) {
        if (re.op == Regexp.Op.CHAR_CLASS) {
            re.runes = new CharClass(re.runes).cleanClass().toArray();
            if (re.runes.length == 2 && re.runes[0] == 0 && re.runes[1] == 0x10FFFF) {
                re.runes = null;
                re.op = Regexp.Op.ANY_CHAR;
            } else if (re.runes.length == 4 && re.runes[0] == 0 && re.runes[1] == 9 && re.runes[2] == 11 && re.runes[3] == 0x10FFFF) {
                re.runes = null;
                re.op = Regexp.Op.ANY_CHAR_NOT_NL;
            }
        }
    }

    private Regexp collapse(Regexp[] subs, Regexp.Op op) {
        if (subs.length == 1) {
            return subs[0];
        }
        int len = 0;
        for (Regexp sub : subs) {
            len += sub.op == op ? sub.subs.length : 1;
        }
        Regexp[] newsubs = new Regexp[len];
        int i = 0;
        for (Regexp sub : subs) {
            if (sub.op == op) {
                System.arraycopy(sub.subs, 0, newsubs, i, sub.subs.length);
                i += sub.subs.length;
                this.reuse(sub);
                continue;
            }
            newsubs[i++] = sub;
        }
        Regexp re = this.newRegexp(op);
        re.subs = newsubs;
        if (op == Regexp.Op.ALTERNATE) {
            re.subs = this.factor(re.subs, re.flags);
            if (re.subs.length == 1) {
                Regexp old = re;
                re = re.subs[0];
                this.reuse(old);
            }
        }
        return re;
    }

    private Regexp[] factor(Regexp[] array, int flags) {
        int i;
        if (array.length < 2) {
            return array;
        }
        int s2 = 0;
        int lensub = array.length;
        int lenout = 0;
        int[] str = null;
        int strlen = 0;
        int strflags = 0;
        int start = 0;
        for (int i2 = 0; i2 <= lensub; ++i2) {
            int[] istr = null;
            int istrlen = 0;
            int iflags = 0;
            if (i2 < lensub) {
                Regexp re = array[s2 + i2];
                if (re.op == Regexp.Op.CONCAT && re.subs.length > 0) {
                    re = re.subs[0];
                }
                if (re.op == Regexp.Op.LITERAL) {
                    istr = re.runes;
                    istrlen = re.runes.length;
                    iflags = re.flags & 1;
                }
                if (iflags == strflags) {
                    int same;
                    for (same = 0; same < strlen && same < istrlen && str[same] == istr[same]; ++same) {
                    }
                    if (same > 0) {
                        strlen = same;
                        continue;
                    }
                }
            }
            if (i2 != start) {
                if (i2 == start + 1) {
                    array[lenout++] = array[s2 + start];
                } else {
                    Regexp prefix = this.newRegexp(Regexp.Op.LITERAL);
                    prefix.flags = strflags;
                    prefix.runes = Utils.subarray(str, 0, strlen);
                    for (int j = start; j < i2; ++j) {
                        array[s2 + j] = this.removeLeadingString(array[s2 + j], strlen);
                    }
                    Regexp suffix = this.collapse(Parser.subarray(array, s2 + start, s2 + i2), Regexp.Op.ALTERNATE);
                    Regexp re = this.newRegexp(Regexp.Op.CONCAT);
                    re.subs = new Regexp[]{prefix, suffix};
                    array[lenout++] = re;
                }
            }
            start = i2;
            str = istr;
            strlen = istrlen;
            strflags = iflags;
        }
        lensub = lenout;
        s2 = 0;
        start = 0;
        lenout = 0;
        Regexp first = null;
        for (i = 0; i <= lensub; ++i) {
            Regexp ifirst = null;
            if (i < lensub) {
                ifirst = Parser.leadingRegexp(array[s2 + i]);
                if (first != null && first.equals(ifirst) && (Parser.isCharClass(first) || first.op == Regexp.Op.REPEAT && first.min == first.max && Parser.isCharClass(first.subs[0]))) continue;
            }
            if (i != start) {
                if (i == start + 1) {
                    array[lenout++] = array[s2 + start];
                } else {
                    Regexp prefix = first;
                    for (int j = start; j < i; ++j) {
                        boolean reuse = j != start;
                        array[s2 + j] = this.removeLeadingRegexp(array[s2 + j], reuse);
                    }
                    Regexp suffix = this.collapse(Parser.subarray(array, s2 + start, s2 + i), Regexp.Op.ALTERNATE);
                    Regexp re = this.newRegexp(Regexp.Op.CONCAT);
                    re.subs = new Regexp[]{prefix, suffix};
                    array[lenout++] = re;
                }
            }
            start = i;
            first = ifirst;
        }
        lensub = lenout;
        s2 = 0;
        start = 0;
        lenout = 0;
        for (i = 0; i <= lensub; ++i) {
            if (i < lensub && Parser.isCharClass(array[s2 + i])) continue;
            if (i != start) {
                if (i == start + 1) {
                    array[lenout++] = array[s2 + start];
                } else {
                    int max = start;
                    for (int j = start + 1; j < i; ++j) {
                        Regexp subMax = array[s2 + max];
                        Regexp subJ = array[s2 + j];
                        if (subMax.op.ordinal() >= subJ.op.ordinal() && (subMax.op != subJ.op || (subMax.runes != null ? subMax.runes.length : 0) >= (subJ.runes != null ? subJ.runes.length : 0))) continue;
                        max = j;
                    }
                    Regexp tmp = array[s2 + start];
                    array[s2 + start] = array[s2 + max];
                    array[s2 + max] = tmp;
                    for (int j = start + 1; j < i; ++j) {
                        Parser.mergeCharClass(array[s2 + start], array[s2 + j]);
                        this.reuse(array[s2 + j]);
                    }
                    this.cleanAlt(array[s2 + start]);
                    array[lenout++] = array[s2 + start];
                }
            }
            if (i < lensub) {
                array[lenout++] = array[s2 + i];
            }
            start = i + 1;
        }
        lensub = lenout;
        s2 = 0;
        start = 0;
        lenout = 0;
        for (i = 0; i < lensub; ++i) {
            if (i + 1 < lensub && array[s2 + i].op == Regexp.Op.EMPTY_MATCH && array[s2 + i + 1].op == Regexp.Op.EMPTY_MATCH) continue;
            array[lenout++] = array[s2 + i];
        }
        lensub = lenout;
        s2 = 0;
        return Parser.subarray(array, s2, lensub);
    }

    private Regexp removeLeadingString(Regexp re, int n) {
        if (re.op == Regexp.Op.CONCAT && re.subs.length > 0) {
            Regexp sub;
            re.subs[0] = sub = this.removeLeadingString(re.subs[0], n);
            if (sub.op == Regexp.Op.EMPTY_MATCH) {
                this.reuse(sub);
                switch (re.subs.length) {
                    case 0: 
                    case 1: {
                        re.op = Regexp.Op.EMPTY_MATCH;
                        re.subs = null;
                        break;
                    }
                    case 2: {
                        Regexp old = re;
                        re = re.subs[1];
                        this.reuse(old);
                        break;
                    }
                    default: {
                        re.subs = Parser.subarray(re.subs, 1, re.subs.length);
                    }
                }
            }
            return re;
        }
        if (re.op == Regexp.Op.LITERAL) {
            re.runes = Utils.subarray(re.runes, n, re.runes.length);
            if (re.runes.length == 0) {
                re.op = Regexp.Op.EMPTY_MATCH;
            }
        }
        return re;
    }

    private static Regexp leadingRegexp(Regexp re) {
        if (re.op == Regexp.Op.EMPTY_MATCH) {
            return null;
        }
        if (re.op == Regexp.Op.CONCAT && re.subs.length > 0) {
            Regexp sub = re.subs[0];
            if (sub.op == Regexp.Op.EMPTY_MATCH) {
                return null;
            }
            return sub;
        }
        return re;
    }

    private Regexp removeLeadingRegexp(Regexp re, boolean reuse) {
        if (re.op == Regexp.Op.CONCAT && re.subs.length > 0) {
            if (reuse) {
                this.reuse(re.subs[0]);
            }
            re.subs = Parser.subarray(re.subs, 1, re.subs.length);
            switch (re.subs.length) {
                case 0: {
                    re.op = Regexp.Op.EMPTY_MATCH;
                    re.subs = Regexp.EMPTY_SUBS;
                    break;
                }
                case 1: {
                    Regexp old = re;
                    re = re.subs[0];
                    this.reuse(old);
                }
            }
            return re;
        }
        if (reuse) {
            this.reuse(re);
        }
        return this.newRegexp(Regexp.Op.EMPTY_MATCH);
    }

    private static Regexp literalRegexp(String s2, int flags) {
        Regexp re = new Regexp(Regexp.Op.LITERAL);
        re.flags = flags;
        re.runes = Utils.stringToRunes(s2);
        return re;
    }

    static Regexp parse(String pattern, int flags) throws PatternSyntaxException {
        return new Parser(pattern, flags).parseInternal();
    }

    private Regexp parseInternal() throws PatternSyntaxException {
        if ((this.flags & 2) != 0) {
            return Parser.literalRegexp(this.wholeRegexp, this.flags);
        }
        int lastRepeatPos = -1;
        int min2 = -1;
        int max = -1;
        StringIterator t2 = new StringIterator(this.wholeRegexp);
        while (t2.more()) {
            int repeatPos = -1;
            block0 : switch (t2.peek()) {
                default: {
                    this.literal(t2.pop());
                    break;
                }
                case 40: {
                    if ((this.flags & 0x40) != 0 && t2.lookingAt("(?")) {
                        this.parsePerlFlags(t2);
                        break;
                    }
                    this.op((Regexp.Op)Regexp.Op.LEFT_PAREN).cap = ++this.numCap;
                    t2.skip(1);
                    break;
                }
                case 124: {
                    this.parseVerticalBar();
                    t2.skip(1);
                    break;
                }
                case 41: {
                    this.parseRightParen();
                    t2.skip(1);
                    break;
                }
                case 94: {
                    if ((this.flags & 0x10) != 0) {
                        this.op(Regexp.Op.BEGIN_TEXT);
                    } else {
                        this.op(Regexp.Op.BEGIN_LINE);
                    }
                    t2.skip(1);
                    break;
                }
                case 36: {
                    if ((this.flags & 0x10) != 0) {
                        this.op((Regexp.Op)Regexp.Op.END_TEXT).flags |= 0x100;
                    } else {
                        this.op(Regexp.Op.END_LINE);
                    }
                    t2.skip(1);
                    break;
                }
                case 46: {
                    if ((this.flags & 8) != 0) {
                        this.op(Regexp.Op.ANY_CHAR);
                    } else {
                        this.op(Regexp.Op.ANY_CHAR_NOT_NL);
                    }
                    t2.skip(1);
                    break;
                }
                case 91: {
                    this.parseClass(t2);
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    repeatPos = t2.pos();
                    Regexp.Op op = null;
                    switch (t2.pop()) {
                        case 42: {
                            op = Regexp.Op.STAR;
                            break;
                        }
                        case 43: {
                            op = Regexp.Op.PLUS;
                            break;
                        }
                        case 63: {
                            op = Regexp.Op.QUEST;
                        }
                    }
                    this.repeat(op, min2, max, repeatPos, t2, lastRepeatPos);
                    break;
                }
                case 123: {
                    repeatPos = t2.pos();
                    int minMax = Parser.parseRepeat(t2);
                    if (minMax < 0) {
                        t2.rewindTo(repeatPos);
                        this.literal(t2.pop());
                        break;
                    }
                    min2 = minMax >> 16;
                    max = (short)(minMax & 0xFFFF);
                    this.repeat(Regexp.Op.REPEAT, min2, max, repeatPos, t2, lastRepeatPos);
                    break;
                }
                case 92: {
                    CharClass cc;
                    int savedPos = t2.pos();
                    t2.skip(1);
                    if ((this.flags & 0x40) != 0 && t2.more()) {
                        int c = t2.pop();
                        switch (c) {
                            case 65: {
                                this.op(Regexp.Op.BEGIN_TEXT);
                                break block0;
                            }
                            case 98: {
                                this.op(Regexp.Op.WORD_BOUNDARY);
                                break block0;
                            }
                            case 66: {
                                this.op(Regexp.Op.NO_WORD_BOUNDARY);
                                break block0;
                            }
                            case 67: {
                                throw new PatternSyntaxException(ERR_INVALID_ESCAPE, "\\C");
                            }
                            case 81: {
                                int codepoint;
                                String lit = t2.rest();
                                int i = lit.indexOf("\\E");
                                if (i >= 0) {
                                    lit = lit.substring(0, i);
                                }
                                t2.skipString(lit);
                                t2.skipString("\\E");
                                for (int j = 0; j < lit.length(); j += Character.charCount(codepoint)) {
                                    codepoint = lit.codePointAt(j);
                                    this.literal(codepoint);
                                }
                                break block0;
                            }
                            case 122: {
                                this.op(Regexp.Op.END_TEXT);
                                break block0;
                            }
                            default: {
                                t2.rewindTo(savedPos);
                            }
                        }
                    }
                    Regexp re = this.newRegexp(Regexp.Op.CHAR_CLASS);
                    re.flags = this.flags;
                    if ((t2.lookingAt("\\p") || t2.lookingAt("\\P")) && this.parseUnicodeClass(t2, cc = new CharClass())) {
                        re.runes = cc.toArray();
                        this.push(re);
                        break;
                    }
                    cc = new CharClass();
                    if (this.parsePerlClassEscape(t2, cc)) {
                        re.runes = cc.toArray();
                        this.push(re);
                        break;
                    }
                    t2.rewindTo(savedPos);
                    this.reuse(re);
                    this.literal(Parser.parseEscape(t2));
                    break;
                }
            }
            lastRepeatPos = repeatPos;
        }
        this.concat();
        if (this.swapVerticalBar()) {
            this.pop();
        }
        this.alternate();
        int n = this.stack.size();
        if (n != 1) {
            throw new PatternSyntaxException(ERR_MISSING_PAREN, this.wholeRegexp);
        }
        ((Regexp)this.stack.get((int)0)).namedGroups = this.namedGroups;
        return (Regexp)this.stack.get(0);
    }

    private static int parseRepeat(StringIterator t2) throws PatternSyntaxException {
        int max;
        int start = t2.pos();
        if (!t2.more() || !t2.lookingAt('{')) {
            return -1;
        }
        t2.skip(1);
        int min2 = Parser.parseInt(t2);
        if (min2 == -1) {
            return -1;
        }
        if (!t2.more()) {
            return -1;
        }
        if (!t2.lookingAt(',')) {
            max = min2;
        } else {
            t2.skip(1);
            if (!t2.more()) {
                return -1;
            }
            if (t2.lookingAt('}')) {
                max = -1;
            } else {
                max = Parser.parseInt(t2);
                if (max == -1) {
                    return -1;
                }
            }
        }
        if (!t2.more() || !t2.lookingAt('}')) {
            return -1;
        }
        t2.skip(1);
        if (min2 < 0 || min2 > 1000 || max == -2 || max > 1000 || max >= 0 && min2 > max) {
            throw new PatternSyntaxException(ERR_INVALID_REPEAT_SIZE, t2.from(start));
        }
        return min2 << 16 | max & 0xFFFF;
    }

    private void parsePerlFlags(StringIterator t2) throws PatternSyntaxException {
        int startPos = t2.pos();
        String s2 = t2.rest();
        if (s2.startsWith("(?P<")) {
            int end = s2.indexOf(62);
            if (end < 0) {
                throw new PatternSyntaxException(ERR_INVALID_NAMED_CAPTURE, s2);
            }
            String name = s2.substring(4, end);
            t2.skipString(name);
            t2.skip(5);
            if (!Parser.isValidCaptureName(name)) {
                throw new PatternSyntaxException(ERR_INVALID_NAMED_CAPTURE, s2.substring(0, end));
            }
            Regexp re = this.op(Regexp.Op.LEFT_PAREN);
            re.cap = ++this.numCap;
            if (this.namedGroups.put(name, this.numCap) != null) {
                throw new PatternSyntaxException(ERR_DUPLICATE_NAMED_CAPTURE, name);
            }
            re.name = name;
            return;
        }
        t2.skip(2);
        int flags = this.flags;
        int sign = 1;
        boolean sawFlag = false;
        block8: while (t2.more()) {
            int c = t2.pop();
            switch (c) {
                default: {
                    break block8;
                }
                case 105: {
                    flags |= 1;
                    sawFlag = true;
                    break;
                }
                case 109: {
                    flags &= 0xFFFFFFEF;
                    sawFlag = true;
                    break;
                }
                case 115: {
                    flags |= 8;
                    sawFlag = true;
                    break;
                }
                case 85: {
                    flags |= 0x20;
                    sawFlag = true;
                    break;
                }
                case 45: {
                    if (sign < 0) break block8;
                    sign = -1;
                    flags ^= 0xFFFFFFFF;
                    sawFlag = false;
                    break;
                }
                case 41: 
                case 58: {
                    if (sign < 0) {
                        if (!sawFlag) break block8;
                        flags ^= 0xFFFFFFFF;
                    }
                    if (c == 58) {
                        this.op(Regexp.Op.LEFT_PAREN);
                    }
                    this.flags = flags;
                    return;
                }
            }
        }
        throw new PatternSyntaxException(ERR_INVALID_PERL_OP, t2.from(startPos));
    }

    private static boolean isValidCaptureName(String name) {
        if (name.isEmpty()) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_' || Utils.isalnum(c)) continue;
            return false;
        }
        return true;
    }

    private static int parseInt(StringIterator t2) {
        int c;
        int start = t2.pos();
        while (t2.more() && (c = t2.peek()) >= 48 && c <= 57) {
            t2.skip(1);
        }
        String n = t2.from(start);
        if (n.isEmpty() || n.length() > 1 && n.charAt(0) == '0') {
            return -1;
        }
        if (n.length() > 8) {
            return -2;
        }
        return Integer.valueOf(n, 10);
    }

    private static boolean isCharClass(Regexp re) {
        return re.op == Regexp.Op.LITERAL && re.runes.length == 1 || re.op == Regexp.Op.CHAR_CLASS || re.op == Regexp.Op.ANY_CHAR_NOT_NL || re.op == Regexp.Op.ANY_CHAR;
    }

    private static boolean matchRune(Regexp re, int r) {
        switch (re.op) {
            case LITERAL: {
                return re.runes.length == 1 && re.runes[0] == r;
            }
            case CHAR_CLASS: {
                for (int i = 0; i < re.runes.length; i += 2) {
                    if (re.runes[i] > r || r > re.runes[i + 1]) continue;
                    return true;
                }
                return false;
            }
            case ANY_CHAR_NOT_NL: {
                return r != 10;
            }
            case ANY_CHAR: {
                return true;
            }
        }
        return false;
    }

    private void parseVerticalBar() {
        this.concat();
        if (!this.swapVerticalBar()) {
            this.op(Regexp.Op.VERTICAL_BAR);
        }
    }

    private static void mergeCharClass(Regexp dst, Regexp src) {
        switch (dst.op) {
            case ANY_CHAR: {
                break;
            }
            case ANY_CHAR_NOT_NL: {
                if (!Parser.matchRune(src, 10)) break;
                dst.op = Regexp.Op.ANY_CHAR;
                break;
            }
            case CHAR_CLASS: {
                if (src.op == Regexp.Op.LITERAL) {
                    dst.runes = new CharClass(dst.runes).appendLiteral(src.runes[0], src.flags).toArray();
                    break;
                }
                dst.runes = new CharClass(dst.runes).appendClass(src.runes).toArray();
                break;
            }
            case LITERAL: {
                if (src.runes[0] == dst.runes[0] && src.flags == dst.flags) break;
                dst.op = Regexp.Op.CHAR_CLASS;
                dst.runes = new CharClass().appendLiteral(dst.runes[0], dst.flags).appendLiteral(src.runes[0], src.flags).toArray();
            }
        }
    }

    private boolean swapVerticalBar() {
        int n = this.stack.size();
        if (n >= 3 && ((Regexp)this.stack.get((int)(n - 2))).op == Regexp.Op.VERTICAL_BAR && Parser.isCharClass((Regexp)this.stack.get(n - 1)) && Parser.isCharClass((Regexp)this.stack.get(n - 3))) {
            Regexp re1 = (Regexp)this.stack.get(n - 1);
            Regexp re3 = (Regexp)this.stack.get(n - 3);
            if (re1.op.ordinal() > re3.op.ordinal()) {
                Regexp tmp = re3;
                re3 = re1;
                re1 = tmp;
                this.stack.set(n - 3, re3);
            }
            Parser.mergeCharClass(re3, re1);
            this.reuse(re1);
            this.pop();
            return true;
        }
        if (n >= 2) {
            Regexp re1 = (Regexp)this.stack.get(n - 1);
            Regexp re2 = (Regexp)this.stack.get(n - 2);
            if (re2.op == Regexp.Op.VERTICAL_BAR) {
                if (n >= 3) {
                    this.cleanAlt((Regexp)this.stack.get(n - 3));
                }
                this.stack.set(n - 2, re1);
                this.stack.set(n - 1, re2);
                return true;
            }
        }
        return false;
    }

    private void parseRightParen() throws PatternSyntaxException {
        this.concat();
        if (this.swapVerticalBar()) {
            this.pop();
        }
        this.alternate();
        int n = this.stack.size();
        if (n < 2) {
            throw new PatternSyntaxException(ERR_INTERNAL_ERROR, "stack underflow");
        }
        Regexp re1 = this.pop();
        Regexp re2 = this.pop();
        if (re2.op != Regexp.Op.LEFT_PAREN) {
            throw new PatternSyntaxException(ERR_MISSING_PAREN, this.wholeRegexp);
        }
        this.flags = re2.flags;
        if (re2.cap == 0) {
            this.push(re1);
        } else {
            re2.op = Regexp.Op.CAPTURE;
            re2.subs = new Regexp[]{re1};
            this.push(re2);
        }
    }

    private static int parseEscape(StringIterator t2) throws PatternSyntaxException {
        int startPos = t2.pos();
        t2.skip(1);
        if (!t2.more()) {
            throw new PatternSyntaxException(ERR_TRAILING_BACKSLASH);
        }
        int c = t2.pop();
        block0 : switch (c) {
            default: {
                if (Utils.isalnum(c)) break;
                return c;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                if (!t2.more() || t2.peek() < 48 || t2.peek() > 55) break;
            }
            case 48: {
                int r = c - 48;
                for (int i = 1; i < 3 && t2.more() && t2.peek() >= 48 && t2.peek() <= 55; ++i) {
                    r = r * 8 + t2.peek() - 48;
                    t2.skip(1);
                }
                return r;
            }
            case 120: {
                if (!t2.more()) break;
                c = t2.pop();
                if (c == 123) {
                    int nhex = 0;
                    int r = 0;
                    while (t2.more()) {
                        c = t2.pop();
                        if (c != 125) {
                            int v = Utils.unhex(c);
                            if (v < 0 || (r = r * 16 + v) > 0x10FFFF) break block0;
                            ++nhex;
                            continue;
                        }
                        if (nhex == 0) break block0;
                        return r;
                    }
                    break;
                }
                int x = Utils.unhex(c);
                if (!t2.more()) break;
                c = t2.pop();
                int y = Utils.unhex(c);
                if (x < 0 || y < 0) break;
                return x * 16 + y;
            }
            case 97: {
                return 7;
            }
            case 102: {
                return 12;
            }
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 118: {
                return 11;
            }
        }
        throw new PatternSyntaxException(ERR_INVALID_ESCAPE, t2.from(startPos));
    }

    private static int parseClassChar(StringIterator t2, int wholeClassPos) throws PatternSyntaxException {
        if (!t2.more()) {
            throw new PatternSyntaxException(ERR_MISSING_BRACKET, t2.from(wholeClassPos));
        }
        if (t2.lookingAt('\\')) {
            return Parser.parseEscape(t2);
        }
        return t2.pop();
    }

    private boolean parsePerlClassEscape(StringIterator t2, CharClass cc) {
        int beforePos = t2.pos();
        if ((this.flags & 0x40) == 0 || !t2.more() || t2.pop() != 92 || !t2.more()) {
            return false;
        }
        t2.pop();
        CharGroup g2 = CharGroup.PERL_GROUPS.get(t2.from(beforePos));
        if (g2 == null) {
            return false;
        }
        cc.appendGroup(g2, (this.flags & 1) != 0);
        return true;
    }

    private boolean parseNamedClass(StringIterator t2, CharClass cc) throws PatternSyntaxException {
        String cls = t2.rest();
        int i = cls.indexOf(":]");
        if (i < 0) {
            return false;
        }
        String name = cls.substring(0, i + 2);
        t2.skipString(name);
        CharGroup g2 = CharGroup.POSIX_GROUPS.get(name);
        if (g2 == null) {
            throw new PatternSyntaxException(ERR_INVALID_CHAR_RANGE, name);
        }
        cc.appendGroup(g2, (this.flags & 1) != 0);
        return true;
    }

    private static Pair<int[][], int[][]> unicodeTable(String name) {
        if (name.equals("Any")) {
            return Pair.of(ANY_TABLE, ANY_TABLE);
        }
        int[][] table = UnicodeTables.CATEGORIES.get(name);
        if (table != null) {
            return Pair.of(table, UnicodeTables.FOLD_CATEGORIES.get(name));
        }
        table = UnicodeTables.SCRIPTS.get(name);
        if (table != null) {
            return Pair.of(table, UnicodeTables.FOLD_SCRIPT.get(name));
        }
        return null;
    }

    private boolean parseUnicodeClass(StringIterator t2, CharClass cc) throws PatternSyntaxException {
        Pair<int[][], int[][]> pair;
        String name;
        int startPos = t2.pos();
        if ((this.flags & 0x80) == 0 || !t2.lookingAt("\\p") && !t2.lookingAt("\\P")) {
            return false;
        }
        t2.skip(1);
        int sign = 1;
        int c = t2.pop();
        if (c == 80) {
            sign = -1;
        }
        if (!t2.more()) {
            t2.rewindTo(startPos);
            throw new PatternSyntaxException(ERR_INVALID_CHAR_RANGE, t2.rest());
        }
        c = t2.pop();
        if (c != 123) {
            name = Utils.runeToString(c);
        } else {
            String rest = t2.rest();
            int end = rest.indexOf(125);
            if (end < 0) {
                t2.rewindTo(startPos);
                throw new PatternSyntaxException(ERR_INVALID_CHAR_RANGE, t2.rest());
            }
            name = rest.substring(0, end);
            t2.skipString(name);
            t2.skip(1);
        }
        if (!name.isEmpty() && name.charAt(0) == '^') {
            sign = -sign;
            name = name.substring(1);
        }
        if ((pair = Parser.unicodeTable(name)) == null) {
            throw new PatternSyntaxException(ERR_INVALID_CHAR_RANGE, t2.from(startPos));
        }
        int[][] tab = (int[][])pair.first;
        int[][] fold = (int[][])pair.second;
        if ((this.flags & 1) == 0 || fold == null) {
            cc.appendTableWithSign(tab, sign);
        } else {
            int[] tmp = new CharClass().appendTable(tab).appendTable(fold).cleanClass().toArray();
            cc.appendClassWithSign(tmp, sign);
        }
        return true;
    }

    private void parseClass(StringIterator t2) throws PatternSyntaxException {
        int startPos = t2.pos();
        t2.skip(1);
        Regexp re = this.newRegexp(Regexp.Op.CHAR_CLASS);
        re.flags = this.flags;
        CharClass cc = new CharClass();
        int sign = 1;
        if (t2.more() && t2.lookingAt('^')) {
            sign = -1;
            t2.skip(1);
            if ((this.flags & 4) == 0) {
                cc.appendRange(10, 10);
            }
        }
        boolean first = true;
        while (!t2.more() || t2.peek() != 93 || first) {
            int lo;
            String s2;
            if (t2.more() && t2.lookingAt('-') && (this.flags & 0x40) == 0 && !first && ((s2 = t2.rest()).equals("-") || !s2.startsWith("-]"))) {
                t2.rewindTo(startPos);
                throw new PatternSyntaxException(ERR_INVALID_CHAR_RANGE, t2.rest());
            }
            first = false;
            int beforePos = t2.pos();
            if (t2.lookingAt("[:")) {
                if (this.parseNamedClass(t2, cc)) continue;
                t2.rewindTo(beforePos);
            }
            if (this.parseUnicodeClass(t2, cc) || this.parsePerlClassEscape(t2, cc)) continue;
            t2.rewindTo(beforePos);
            int hi = lo = Parser.parseClassChar(t2, startPos);
            if (t2.more() && t2.lookingAt('-')) {
                t2.skip(1);
                if (t2.more() && t2.lookingAt(']')) {
                    t2.skip(-1);
                } else {
                    hi = Parser.parseClassChar(t2, startPos);
                    if (hi < lo) {
                        throw new PatternSyntaxException(ERR_INVALID_CHAR_RANGE, t2.from(beforePos));
                    }
                }
            }
            if ((this.flags & 1) == 0) {
                cc.appendRange(lo, hi);
                continue;
            }
            cc.appendFoldedRange(lo, hi);
        }
        t2.skip(1);
        cc.cleanClass();
        if (sign < 0) {
            cc.negateClass();
        }
        re.runes = cc.toArray();
        this.push(re);
    }

    static Regexp[] subarray(Regexp[] array, int start, int end) {
        Regexp[] r = new Regexp[end - start];
        for (int i = start; i < end; ++i) {
            r[i - start] = array[i];
        }
        return r;
    }

    private static int[] concatRunes(int[] x, int[] y) {
        int[] z = new int[x.length + y.length];
        System.arraycopy(x, 0, z, 0, x.length);
        System.arraycopy(y, 0, z, x.length, y.length);
        return z;
    }

    private static class Pair<F, S> {
        final F first;
        final S second;

        Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        static <F, S> Pair<F, S> of(F first, S second) {
            return new Pair<F, S>(first, second);
        }
    }

    private static class StringIterator {
        private final String str;
        private int pos = 0;

        StringIterator(String str) {
            this.str = str;
        }

        int pos() {
            return this.pos;
        }

        void rewindTo(int pos) {
            this.pos = pos;
        }

        boolean more() {
            return this.pos < this.str.length();
        }

        int peek() {
            return this.str.codePointAt(this.pos);
        }

        void skip(int n) {
            this.pos += n;
        }

        void skipString(String s2) {
            this.pos += s2.length();
        }

        int pop() {
            int r = this.str.codePointAt(this.pos);
            this.pos += Character.charCount(r);
            return r;
        }

        boolean lookingAt(char c) {
            return this.str.charAt(this.pos) == c;
        }

        boolean lookingAt(String s2) {
            return this.rest().startsWith(s2);
        }

        String rest() {
            return this.str.substring(this.pos);
        }

        String from(int beforePos) {
            return this.str.substring(beforePos, this.pos);
        }

        public String toString() {
            return this.rest();
        }
    }

    private static class Stack
    extends ArrayList<Regexp> {
        private Stack() {
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

