/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.annotations.VisibleForTesting;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.LeastRequestLoadBalancer;
import java.util.Map;

@Internal
public final class LeastRequestLoadBalancerProvider
extends LoadBalancerProvider {
    static final int MIN_CHOICE_COUNT = 2;
    static final int MAX_CHOICE_COUNT = 10;
    @VisibleForTesting
    static final Integer DEFAULT_CHOICE_COUNT = 2;

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new LeastRequestLoadBalancer(helper);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "least_request_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            Integer choiceCount = JsonUtil.getNumberAsInteger(rawConfig, "choiceCount");
            if (choiceCount == null) {
                choiceCount = DEFAULT_CHOICE_COUNT;
            }
            if (choiceCount < 2) {
                return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withDescription("Invalid 'choiceCount' in least_request_experimental config"));
            }
            return NameResolver.ConfigOrError.fromConfig(new LeastRequestLoadBalancer.LeastRequestConfig(choiceCount));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withCause(e).withDescription("Failed to parse least_request_experimental LB config: " + rawConfig));
        }
    }
}

