/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.auto.value.AutoValue;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableList;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.collect.ImmutableMap;
import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.Nullable;
import io.grpc.Internal;
import io.grpc.xds.client.AutoValue_Stats_ClusterStats;
import io.grpc.xds.client.AutoValue_Stats_DroppedRequests;
import io.grpc.xds.client.AutoValue_Stats_UpstreamLocalityStats;
import io.grpc.xds.client.Locality;
import java.util.Map;

@Internal
public final class Stats {
    private Stats() {
    }

    public static final class BackendLoadMetricStats {
        private long numRequestsFinishedWithMetric;
        private double totalMetricValue;

        BackendLoadMetricStats(long numRequestsFinishedWithMetric, double totalMetricValue) {
            this.numRequestsFinishedWithMetric = numRequestsFinishedWithMetric;
            this.totalMetricValue = totalMetricValue;
        }

        public long numRequestsFinishedWithMetric() {
            return this.numRequestsFinishedWithMetric;
        }

        public double totalMetricValue() {
            return this.totalMetricValue;
        }

        public void addMetricValueAndIncrementRequestsFinished(double metricValue) {
            ++this.numRequestsFinishedWithMetric;
            this.totalMetricValue += metricValue;
        }
    }

    @AutoValue
    public static abstract class UpstreamLocalityStats {
        public abstract Locality locality();

        public abstract long totalIssuedRequests();

        public abstract long totalSuccessfulRequests();

        public abstract long totalErrorRequests();

        public abstract long totalRequestsInProgress();

        public abstract ImmutableMap<String, BackendLoadMetricStats> loadMetricStatsMap();

        public static UpstreamLocalityStats create(Locality locality, long totalIssuedRequests, long totalSuccessfulRequests, long totalErrorRequests, long totalRequestsInProgress, Map<String, BackendLoadMetricStats> loadMetricStatsMap) {
            return new AutoValue_Stats_UpstreamLocalityStats(locality, totalIssuedRequests, totalSuccessfulRequests, totalErrorRequests, totalRequestsInProgress, ImmutableMap.copyOf(loadMetricStatsMap));
        }
    }

    @AutoValue
    public static abstract class DroppedRequests {
        public abstract String category();

        public abstract long droppedCount();

        public static DroppedRequests create(String category, long droppedCount) {
            return new AutoValue_Stats_DroppedRequests(category, droppedCount);
        }
    }

    @AutoValue
    public static abstract class ClusterStats {
        abstract String clusterName();

        @Nullable
        public abstract String clusterServiceName();

        public abstract ImmutableList<UpstreamLocalityStats> upstreamLocalityStatsList();

        public abstract ImmutableList<DroppedRequests> droppedRequestsList();

        public abstract long totalDroppedRequests();

        public abstract long loadReportIntervalNano();

        public static Builder newBuilder() {
            return new AutoValue_Stats_ClusterStats.Builder().totalDroppedRequests(0L).loadReportIntervalNano(0L);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            abstract Builder clusterName(String var1);

            abstract Builder clusterServiceName(String var1);

            abstract ImmutableList.Builder<UpstreamLocalityStats> upstreamLocalityStatsListBuilder();

            Builder addUpstreamLocalityStats(UpstreamLocalityStats upstreamLocalityStats) {
                this.upstreamLocalityStatsListBuilder().add((Object)upstreamLocalityStats);
                return this;
            }

            abstract ImmutableList.Builder<DroppedRequests> droppedRequestsListBuilder();

            Builder addDroppedRequests(DroppedRequests droppedRequests) {
                this.droppedRequestsListBuilder().add((Object)droppedRequests);
                return this;
            }

            abstract Builder totalDroppedRequests(long var1);

            abstract Builder loadReportIntervalNano(long var1);

            abstract long loadReportIntervalNano();

            abstract ClusterStats build();
        }
    }
}

