/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.certprovider;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.annotations.VisibleForTesting;
import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.concurrent.ThreadSafe;
import io.grpc.xds.internal.security.ReferenceCountingMap;
import io.grpc.xds.internal.security.certprovider.CertificateProvider;
import io.grpc.xds.internal.security.certprovider.CertificateProviderProvider;
import io.grpc.xds.internal.security.certprovider.CertificateProviderRegistry;
import java.io.Closeable;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

@ThreadSafe
public final class CertificateProviderStore {
    private static final Logger logger = Logger.getLogger(CertificateProviderStore.class.getName());
    private static CertificateProviderStore instance;
    private final CertificateProviderRegistry certificateProviderRegistry;
    private final ReferenceCountingMap<CertProviderKey, CertificateProvider> certProviderMap;

    @VisibleForTesting
    public CertificateProviderStore(CertificateProviderRegistry certificateProviderRegistry) {
        this.certificateProviderRegistry = certificateProviderRegistry;
        this.certProviderMap = new ReferenceCountingMap<CertProviderKey, CertificateProvider>(new CertProviderFactory());
    }

    public synchronized Handle createOrGetProvider(String certName, String pluginName, Object config, CertificateProvider.Watcher watcher, boolean notifyCertUpdates) {
        if (!notifyCertUpdates) {
            try {
                return this.createProviderHelper(certName, pluginName, config, watcher, true);
            }
            catch (UnsupportedOperationException uoe) {
                logger.log(Level.FINE, "Trying to get provider for notifyCertUpdates==true", uoe);
            }
        }
        return this.createProviderHelper(certName, pluginName, config, watcher, notifyCertUpdates);
    }

    private synchronized Handle createProviderHelper(String certName, String pluginName, Object config, CertificateProvider.Watcher watcher, boolean notifyCertUpdates) {
        CertProviderKey key = new CertProviderKey(certName, pluginName, notifyCertUpdates, config);
        CertificateProvider provider = this.certProviderMap.get(key);
        CertificateProvider.DistributorWatcher distWatcher = provider.getWatcher();
        distWatcher.addWatcher(watcher);
        return new Handle(key, watcher, provider);
    }

    public static synchronized CertificateProviderStore getInstance() {
        if (instance == null) {
            instance = new CertificateProviderStore(CertificateProviderRegistry.getInstance());
        }
        return instance;
    }

    private final class CertProviderFactory
    implements ReferenceCountingMap.ValueFactory<CertProviderKey, CertificateProvider> {
        private CertProviderFactory() {
        }

        @Override
        public CertificateProvider create(CertProviderKey key) {
            CertificateProviderProvider certProviderProvider = CertificateProviderStore.this.certificateProviderRegistry.getProvider(key.pluginName);
            if (certProviderProvider == null) {
                throw new IllegalArgumentException("Provider not found for " + key.pluginName);
            }
            CertificateProvider certProvider = certProviderProvider.createCertificateProvider(key.config, new CertificateProvider.DistributorWatcher(), key.notifyCertUpdates);
            certProvider.start();
            return certProvider;
        }
    }

    private static final class CertProviderKey {
        private final String certName;
        private final String pluginName;
        private final boolean notifyCertUpdates;
        private final Object config;

        private CertProviderKey(String certName, String pluginName, boolean notifyCertUpdates, Object config) {
            this.certName = certName;
            this.pluginName = pluginName;
            this.notifyCertUpdates = notifyCertUpdates;
            this.config = config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CertProviderKey)) {
                return false;
            }
            CertProviderKey that = (CertProviderKey)o;
            return this.notifyCertUpdates == that.notifyCertUpdates && Objects.equals(this.certName, that.certName) && Objects.equals(this.pluginName, that.pluginName) && Objects.equals(this.config, that.config);
        }

        public int hashCode() {
            return Objects.hash(this.certName, this.pluginName, this.notifyCertUpdates, this.config);
        }

        public String toString() {
            return "CertProviderKey{certName='" + this.certName + '\'' + ", pluginName='" + this.pluginName + '\'' + ", notifyCertUpdates=" + this.notifyCertUpdates + ", config=" + this.config + '}';
        }
    }

    @VisibleForTesting
    final class Handle
    implements Closeable {
        private final CertProviderKey key;
        private final CertificateProvider.Watcher watcher;
        @VisibleForTesting
        final CertificateProvider certProvider;

        private Handle(CertProviderKey key, CertificateProvider.Watcher watcher, CertificateProvider certProvider) {
            this.key = key;
            this.watcher = watcher;
            this.certProvider = certProvider;
        }

        @Override
        public synchronized void close() {
            CertificateProvider.DistributorWatcher distWatcher = this.certProvider.getWatcher();
            distWatcher.removeWatcher(this.watcher);
            CertificateProviderStore.this.certProviderMap.release(this.key, this.certProvider);
        }
    }
}

