/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.trust;

import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.annotations.VisibleForTesting;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Preconditions;
import com.pingidentity.pingcommons.gcp.key.shade.com.google.common.base.Strings;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.grpc.xds.internal.security.trust.CertificateUtils;
import io.grpc.xds.internal.security.trust.XdsX509TrustManager;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.DataSource;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

public final class XdsTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Logger logger = Logger.getLogger(XdsTrustManagerFactory.class.getName());
    private XdsX509TrustManager xdsX509TrustManager;

    public XdsTrustManagerFactory(CertificateValidationContext certificateValidationContext) throws CertificateException, IOException, CertStoreException {
        this(XdsTrustManagerFactory.getTrustedCaFromCertContext(certificateValidationContext), certificateValidationContext, false);
    }

    public XdsTrustManagerFactory(X509Certificate[] certs, CertificateValidationContext staticCertificateValidationContext) throws CertStoreException {
        this(certs, staticCertificateValidationContext, true);
    }

    public XdsTrustManagerFactory(Map<String, List<X509Certificate>> spiffeTrustMap, CertificateValidationContext staticCertificateValidationContext) throws CertStoreException {
        this(spiffeTrustMap, staticCertificateValidationContext, true);
    }

    private XdsTrustManagerFactory(X509Certificate[] certs, CertificateValidationContext certificateValidationContext, boolean validationContextIsStatic) throws CertStoreException {
        if (validationContextIsStatic) {
            Preconditions.checkArgument(certificateValidationContext == null || !certificateValidationContext.hasTrustedCa(), "only static certificateValidationContext expected");
        }
        this.xdsX509TrustManager = XdsTrustManagerFactory.createX509TrustManager(certs, certificateValidationContext);
    }

    private XdsTrustManagerFactory(Map<String, List<X509Certificate>> spiffeTrustMap, CertificateValidationContext certificateValidationContext, boolean validationContextIsStatic) throws CertStoreException {
        if (validationContextIsStatic) {
            Preconditions.checkArgument(certificateValidationContext == null || !certificateValidationContext.hasTrustedCa(), "only static certificateValidationContext expected");
            this.xdsX509TrustManager = XdsTrustManagerFactory.createX509TrustManager(spiffeTrustMap, certificateValidationContext);
        }
    }

    private static X509Certificate[] getTrustedCaFromCertContext(CertificateValidationContext certificateValidationContext) throws CertificateException, IOException {
        DataSource.SpecifierCase specifierCase = certificateValidationContext.getTrustedCa().getSpecifierCase();
        if (specifierCase == DataSource.SpecifierCase.FILENAME) {
            String certsFile = certificateValidationContext.getTrustedCa().getFilename();
            Preconditions.checkState(!Strings.isNullOrEmpty(certsFile), "trustedCa.file-name in certificateValidationContext cannot be empty");
            return CertificateUtils.toX509Certificates(new File(certsFile));
        }
        if (specifierCase == DataSource.SpecifierCase.INLINE_BYTES) {
            try (InputStream is = certificateValidationContext.getTrustedCa().getInlineBytes().newInput();){
                X509Certificate[] x509CertificateArray = CertificateUtils.toX509Certificates(is);
                return x509CertificateArray;
            }
        }
        throw new IllegalArgumentException("Not supported: " + specifierCase);
    }

    @VisibleForTesting
    static XdsX509TrustManager createX509TrustManager(X509Certificate[] certs, CertificateValidationContext certContext) throws CertStoreException {
        return new XdsX509TrustManager(certContext, XdsTrustManagerFactory.createTrustManager(certs));
    }

    @VisibleForTesting
    static XdsX509TrustManager createX509TrustManager(Map<String, List<X509Certificate>> spiffeTrustMapFile, CertificateValidationContext certContext) throws CertStoreException {
        Preconditions.checkNotNull(spiffeTrustMapFile, "spiffeTrustMapFile");
        HashMap<String, X509ExtendedTrustManager> delegates = new HashMap<String, X509ExtendedTrustManager>();
        for (Map.Entry<String, List<X509Certificate>> entry : spiffeTrustMapFile.entrySet()) {
            delegates.put(entry.getKey(), XdsTrustManagerFactory.createTrustManager(entry.getValue().toArray(new X509Certificate[0])));
        }
        return new XdsX509TrustManager(certContext, delegates);
    }

    private static X509ExtendedTrustManager createTrustManager(X509Certificate[] certs) throws CertStoreException {
        TrustManagerFactory tmf = null;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(null, null);
            int i = 1;
            for (X509Certificate cert : certs) {
                ks.setCertificateEntry("alias" + i, cert);
                ++i;
            }
            tmf.init(ks);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.log(Level.SEVERE, "createX509TrustManager", e);
            throw new CertStoreException(e);
        }
        TrustManager[] tms = tmf.getTrustManagers();
        X509ExtendedTrustManager myDelegate = null;
        if (tms != null) {
            for (TrustManager tm : tms) {
                if (!(tm instanceof X509ExtendedTrustManager)) continue;
                myDelegate = (X509ExtendedTrustManager)tm;
                break;
            }
        }
        if (myDelegate == null) {
            throw new CertStoreException("Native X509 TrustManager not found.");
        }
        return myDelegate;
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.xdsX509TrustManager};
    }
}

