/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.metrics.export;

import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.concurrent.ThreadSafe;
import io.opencensus.internal.Utils;
import io.opencensus.metrics.export.MetricProducer;
import java.util.Collections;
import java.util.Set;

@ThreadSafe
public abstract class MetricProducerManager {
    public abstract void add(MetricProducer var1);

    public abstract void remove(MetricProducer var1);

    public abstract Set<MetricProducer> getAllMetricProducer();

    static MetricProducerManager newNoopMetricProducerManager() {
        return new NoopMetricProducerManager();
    }

    private static final class NoopMetricProducerManager
    extends MetricProducerManager {
        private NoopMetricProducerManager() {
        }

        @Override
        public void add(MetricProducer metricProducer) {
            Utils.checkNotNull(metricProducer, "metricProducer");
        }

        @Override
        public void remove(MetricProducer metricProducer) {
            Utils.checkNotNull(metricProducer, "metricProducer");
        }

        @Override
        public Set<MetricProducer> getAllMetricProducer() {
            return Collections.emptySet();
        }
    }
}

