/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.internal.ser;

import java.lang.ref.WeakReference;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.internal.ser.SerMessages;
import org.apache.hivemind.internal.ser.ServiceSerializationSupport;

public class ServiceSerializationHelper {
    private static final ThreadLocal _threadLocal = new ThreadLocal();

    public static ServiceSerializationSupport getServiceSerializationSupport() {
        ServiceSerializationSupport result = null;
        WeakReference reference = (WeakReference)_threadLocal.get();
        if (reference != null) {
            result = (ServiceSerializationSupport)reference.get();
        }
        if (result == null) {
            throw new ApplicationRuntimeException(SerMessages.noSupportSet());
        }
        return result;
    }

    public static void setServiceSerializationSupport(ServiceSerializationSupport serviceSerializationSupport) {
        WeakReference<ServiceSerializationSupport> reference = new WeakReference<ServiceSerializationSupport>(serviceSerializationSupport);
        _threadLocal.set(reference);
    }
}

