/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.util;

import java.net.URL;
import java.util.Locale;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.AbstractResource;
import org.apache.hivemind.util.LocalizedResource;
import org.apache.hivemind.util.LocalizedResourceFinder;

public class ClasspathResource
extends AbstractResource {
    private ClassResolver _resolver;

    public ClasspathResource(ClassResolver resolver, String path) {
        this(resolver, path, null);
    }

    public ClasspathResource(ClassResolver resolver, String path, Locale locale) {
        super(path, locale);
        this._resolver = resolver;
    }

    public Resource getLocalization(Locale locale) {
        LocalizedResourceFinder finder = new LocalizedResourceFinder(this._resolver);
        String path = this.getPath();
        LocalizedResource localizedResource = finder.resolve(path, locale);
        if (localizedResource == null) {
            return null;
        }
        String localizedPath = localizedResource.getResourcePath();
        Locale pathLocale = localizedResource.getResourceLocale();
        if (localizedPath == null) {
            return null;
        }
        if (path.equals(localizedPath)) {
            return this;
        }
        return new ClasspathResource(this._resolver, localizedPath, pathLocale);
    }

    public URL getResourceURL() {
        return this._resolver.getResource(this.getPath());
    }

    public String toString() {
        return "classpath:" + this.getPath();
    }

    public int hashCode() {
        return 0x12AF & this.getPath().hashCode();
    }

    protected Resource newResource(String path) {
        return new ClasspathResource(this._resolver, path);
    }
}

