/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.AmazonEC2Exception;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.StringUtils;
import com.pingidentity.aws.AWSPermissionsError;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;
import org.w3c.dom.Node;

public class AWS_PING
extends Discovery {
    private static String INSTANCE_METADATA_BASE_URI = "http://169.254.169.254/latest/meta-data/";
    private static String GET_INSTANCE_ID = INSTANCE_METADATA_BASE_URI + "instance-id";
    private static final String AWS_EC2_METADATA_TOKEN_URI = "http://169.254.169.254/latest/api/token";
    private static final String AWS_EC2_METADATA_TOKEN_TTL_SECONDS_HEADER = "X-aws-ec2-metadata-token-ttl-seconds";
    private static final String AWS_EC2_METADATA_TOKEN_HEADER = "X-aws-ec2-metadata-token";
    private static final int AWS_EC2_METADATA_TOKEN_TTL_SECONDS_DEFAULT = 300;
    @Property(description="The AWS Credentials Chain Class to use when searching for the account.")
    private String credentials_provider_class = DefaultAWSCredentialsProviderChain.class.getName();
    @Property(description="The AWS Access Key for the account to search.")
    private String access_key;
    @Property(description="The AWS Secret Key for the account to search.")
    private String secret_key;
    @Property(description="A comma-delimited list of EC2 region names in which discovery will be attempted.")
    private String regions;
    @Property(description="A semicolon delimited list of filters to search on. (name1=value1,value2;name2=value1,value2)")
    private String filters;
    @Property(description="A list of tags that identify this cluster.")
    private String tags;
    @Property(description="The port number being used for cluster membership.  The default is 7600.")
    int port_number = 7600;
    @Property(description="Number of additional ports to be probed for membership. A port_range of 0 does not probe additional ports. Example: initial_hosts=A[7800] port_range=0 probes A:7800, port_range=1 probes A:7800 and A:7801. The default is 0.")
    protected int port_range = 0;
    @Property(description="Turns on AWS error message logging.")
    private boolean log_aws_error_messages = false;
    private String instanceId;
    private Collection<Filter> awsFilters;
    private List<String> awsTagNames;
    private List<String> ec2Regions;
    private List<RegionClient> regionClients = new ArrayList<RegionClient>();

    public void init() throws Exception {
        super.init();
        DefaultHttpClient client = null;
        try {
            client = new DefaultHttpClient();
            this.instanceId = this.getBody((HttpClient)client, GET_INSTANCE_ID);
        }
        finally {
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
        }
        this.ec2Regions = this.parseRegions(this.regions);
        if (this.filters != null) {
            this.awsFilters = AWS_PING.parseFilters(this.filters);
        }
        if (this.tags != null) {
            this.awsTagNames = AWS_PING.parseTagNames(this.tags);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Configured with regions " + this.ec2Regions);
            if (this.filters != null) {
                this.log.debug("Configured with filters " + this.awsFilters);
            }
            if (this.tags != null) {
                this.log.debug("Configured with tags " + this.awsTagNames);
            }
        }
    }

    public void start() throws Exception {
        super.start();
        for (String ec2Region : this.ec2Regions) {
            this.regionClients.add(new RegionClient(ec2Region, this.makeAmazonEC2(ec2Region)));
        }
        this.testConnectivityAndValidateTags();
    }

    private AmazonEC2 makeAmazonEC2(String region) throws Exception {
        AmazonEC2 ec2;
        if ((this.access_key == null || this.access_key.trim().isEmpty()) && (this.secret_key == null || this.secret_key.trim().isEmpty())) {
            AWSCredentialsProvider awsCredentialsProvider = AWS_PING.loadCredentialsProvider(this.credentials_provider_class, ((Object)((Object)this)).getClass(), this.log);
            ec2 = (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withCredentials(awsCredentialsProvider)).withRegion(region)).build();
        } else {
            BasicAWSCredentials creds = new BasicAWSCredentials(this.access_key, this.secret_key);
            ec2 = (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)creds))).withRegion(region)).build();
        }
        if (this.log_aws_error_messages) {
            this.setupAWSExceptionLogging(ec2);
        }
        return ec2;
    }

    private void testConnectivityAndValidateTags() throws AWSPermissionsError {
        this.log.info("Testing AWS connectivity ...");
        try {
            Map<String, String> instanceTags = AWS_PING.getInstanceTags(this.getLocalAmazonEC2(), this.instanceId);
            if (this.awsTagNames != null) {
                for (String awsTagName : this.awsTagNames) {
                    if (instanceTags.containsKey(awsTagName)) continue;
                    this.log.warn("Tag " + awsTagName + " is not defined on this instance and will not be used for discovery");
                }
            }
        }
        catch (AmazonEC2Exception e) {
            this.log.error("Could not get metadata information from EC2 due to: " + e.getMessage() + ". Please make sure your role or access key has the proper permissions.");
            throw new AWSPermissionsError("Error while attempting to describe EC2 instances with the provided credentials.");
        }
        catch (SdkClientException e) {
            this.log.error("SDK exception was encountered. Please make sure this system is configured with either a Role or an access key with the proper permissions to access EC2.");
            throw new AWSPermissionsError("Error while attempting to describe EC2 instances.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupAWSExceptionLogging(AmazonEC2 ec2) {
        boolean accessible = false;
        Field exceptionUnmarshallersField = null;
        try {
            exceptionUnmarshallersField = AmazonEC2Client.class.getDeclaredField("exceptionUnmarshallers");
            accessible = exceptionUnmarshallersField.isAccessible();
            exceptionUnmarshallersField.setAccessible(true);
            List exceptionUnmarshallers = (List)exceptionUnmarshallersField.get(ec2);
            exceptionUnmarshallers.add(0, new AWSFaultLogger());
            ((AmazonEC2Client)ec2).addRequestHandler((RequestHandler2)exceptionUnmarshallers.get(0));
        }
        catch (Throwable throwable) {
        }
        finally {
            if (exceptionUnmarshallersField != null) {
                try {
                    exceptionUnmarshallersField.setAccessible(accessible);
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    public void stop() {
        try {
            this.regionClients.forEach(regionClient -> regionClient.getAmazonEC2().shutdown());
        }
        finally {
            super.stop();
        }
    }

    protected void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, (Object)this.local_addr));
        PingData data = new PingData(this.local_addr, false, NameCache.get((Address)this.local_addr), physical_addr);
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name);
        List<PhysicalAddress> clusterMembers = this.expandClusterMemberPorts(this.getPrivateIpAddresses());
        for (PhysicalAddress addr : clusterMembers) {
            if (physical_addr != null && addr.equals(physical_addr)) continue;
            Message msg = new Message((Address)addr).setFlag(new Message.Flag[]{Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE, Message.Flag.OOB}).putHeader(this.id, (Header)hdr).setBuffer(AWS_PING.marshal((PingData)data));
            if (this.async_discovery_use_separate_thread_per_request) {
                this.timer.execute(() -> {
                    this.log.trace("%s: sending discovery request to %s", new Object[]{this.local_addr, msg.getDest()});
                    this.down_prot.down(msg);
                });
                continue;
            }
            this.log.trace("%s: sending discovery request to %s", new Object[]{this.local_addr, msg.getDest()});
            this.down_prot.down(msg);
        }
    }

    protected List<PhysicalAddress> expandClusterMemberPorts(List<String> privateIpAddresses) {
        ArrayList<PhysicalAddress> clusterMembers = new ArrayList<PhysicalAddress>();
        for (String privateIpAddress : privateIpAddresses) {
            for (int i = this.port_number; i <= this.port_number + this.port_range; ++i) {
                try {
                    clusterMembers.add((PhysicalAddress)new IpAddress(privateIpAddress, i));
                    continue;
                }
                catch (UnknownHostException e) {
                    this.log.warn("Could not create an IpAddress for " + privateIpAddress + ":" + i);
                }
            }
        }
        return clusterMembers;
    }

    private List<String> getPrivateIpAddresses() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (this.awsTagNames != null) {
            Map<String, String> instanceTags = AWS_PING.getInstanceTags(this.getLocalAmazonEC2(), this.instanceId);
            for (String awsTagName : this.awsTagNames) {
                String tagValue = instanceTags.get(awsTagName);
                if (tagValue == null) continue;
                filters.add(new Filter("tag:" + awsTagName, Collections.singletonList(tagValue)));
            }
        }
        if (this.awsFilters != null) {
            filters.addAll(this.awsFilters);
        }
        DescribeInstancesRequest request = new DescribeInstancesRequest().withFilters(filters);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Describing AWS instances with the following filters " + filters);
        }
        for (RegionClient regionClient : this.regionClients) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Making AWS Request " + request + " in region " + regionClient.getRegion());
            }
            ArrayList<String> regionResult = new ArrayList<String>();
            try {
                DescribeInstancesResult filterResult = regionClient.getAmazonEC2().describeInstances(request);
                for (Reservation reservation : filterResult.getReservations()) {
                    for (Instance instance : reservation.getInstances()) {
                        if (instance.getPrivateIpAddress() == null) continue;
                        regionResult.add(instance.getPrivateIpAddress());
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("In region " + regionClient.getRegion() + " found instances " + regionResult);
                }
                result.addAll(regionResult);
            }
            catch (Exception e) {
                this.log.error("Error attempting to list instances in region " + regionClient.getRegion() + ". Please ensure your role or access key has the proper permissions.", (Throwable)e);
            }
        }
        return result;
    }

    public boolean isDynamic() {
        return true;
    }

    public String getName() {
        return "AWS_PING";
    }

    private AmazonEC2 getLocalAmazonEC2() {
        if (this.regionClients.isEmpty()) {
            throw new RuntimeException("Unexpected error: no EC2 clients exist");
        }
        return this.regionClients.get(0).getAmazonEC2();
    }

    private List<String> parseRegions(String regions) throws AWSPermissionsError {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Region region = Regions.getCurrentRegion();
        if (region == null) {
            throw new AWSPermissionsError("Failed to determine current EC2 region");
        }
        result.add(region.getName());
        if (regions != null) {
            String[] regionElements;
            for (String element : regionElements = regions.split(",")) {
                if ((element = element.trim()).isEmpty()) continue;
                result.add(element);
            }
        }
        return new ArrayList<String>(result);
    }

    private static List<Filter> parseFilters(String filters) {
        ArrayList<Filter> awsFilters = new ArrayList<Filter>();
        for (String filterString : filters.split("\\s*;\\s*")) {
            String trimmed = filterString.trim();
            if (trimmed.length() == 0) continue;
            String[] keyValues = trimmed.split("\\s*=\\s*");
            if (keyValues.length != 2 || keyValues[0].length() == 0 || keyValues[1].length() == 0) {
                throw new IllegalArgumentException("Could not process key value pair '" + filterString + "'");
            }
            awsFilters.add(new Filter().withName(keyValues[0]).withValues(keyValues[1].split("\\s*,\\s*")));
        }
        return awsFilters;
    }

    private static List<String> parseTagNames(String tagNames) {
        String[] tagNameArray = tagNames.split("\\s*,\\s*");
        ArrayList<String> result = new ArrayList<String>();
        for (String tagName : tagNameArray) {
            String trimmed = tagName.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result;
    }

    private String getBody(HttpClient client, String uri) throws Exception {
        HttpResponse response;
        HttpGet getInstance = new HttpGet();
        getInstance.setURI(new URI(uri));
        String metadataToken = this.getMetadataToken(client);
        if (!StringUtils.isNullOrEmpty((String)metadataToken)) {
            getInstance.setHeader(AWS_EC2_METADATA_TOKEN_HEADER, metadataToken);
        }
        if ((response = client.execute((HttpUriRequest)getInstance)).getStatusLine().getStatusCode() != 200) {
            throw new Exception("Could not get instance ID.");
        }
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    private String getMetadataToken(HttpClient client) {
        String token = "";
        try {
            HttpPut putToken = new HttpPut();
            putToken.setURI(new URI(AWS_EC2_METADATA_TOKEN_URI));
            putToken.setHeader(AWS_EC2_METADATA_TOKEN_TTL_SECONDS_HEADER, String.valueOf(300));
            HttpResponse response = client.execute((HttpUriRequest)putToken);
            if (response.getStatusLine().getStatusCode() == 200) {
                token = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        catch (Exception e) {
            this.log.debug("Failed to get metadata session token." + e);
        }
        return token;
    }

    private static Map<String, String> getInstanceTags(AmazonEC2 ec2, String instanceId) {
        HashMap<String, String> tags = new HashMap<String, String>();
        DescribeInstancesResult response = ec2.describeInstances(new DescribeInstancesRequest().withInstanceIds(Collections.singletonList(instanceId)));
        for (Reservation res : response.getReservations()) {
            for (Instance inst : res.getInstances()) {
                List instanceTags = inst.getTags();
                if (instanceTags == null) continue;
                for (Tag tag : instanceTags) {
                    tags.put(tag.getKey(), tag.getValue());
                }
            }
        }
        return tags;
    }

    static AWSCredentialsProvider loadCredentialsProvider(String credentialProviderClass, Class<?> jgroupsClass, Log log) throws Exception {
        AWSCredentialsProvider awsCredentialsProvider;
        Class credsProviderClazz;
        try {
            credsProviderClazz = Util.loadClass((String)credentialProviderClass, jgroupsClass);
        }
        catch (ClassNotFoundException e) {
            throw new Exception("unable to load credentials provider class " + credentialProviderClass);
        }
        try {
            awsCredentialsProvider = (AWSCredentialsProvider)credsProviderClazz.newInstance();
        }
        catch (InstantiationException e) {
            log.error("an instance of " + credentialProviderClass + " could not be created. Please check that it implements interface AWSCredentialsProvider and that is has a public empty constructor !");
            throw e;
        }
        return awsCredentialsProvider;
    }

    static {
        ClassConfigurator.addProtocol((short)600, AWS_PING.class);
    }

    private class AWSFaultLogger
    extends RequestHandler2
    implements Unmarshaller<AmazonServiceException, Node> {
        private final ThreadLocal<Request<?>> request = new ThreadLocal();

        private AWSFaultLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AmazonServiceException unmarshall(Node node) throws Exception {
            try {
                TransformerFactory tfactory = TransformerFactory.newInstance();
                Transformer xform = tfactory.newTransformer();
                DOMSource src = new DOMSource(node);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                xform.transform(src, result);
                AWS_PING.this.log.error("AWS Exception: [" + writer.toString() + "] For request [" + this.request.get() + "]");
            }
            catch (Throwable t) {
                AWS_PING.this.log.debug("Failed to log xml soap fault message.", t);
            }
            finally {
                this.request.remove();
            }
            return null;
        }

        public void afterResponse(Request<?> request, Response<?> response) {
            this.request.remove();
        }

        public void afterError(Request<?> request, Response<?> response, Exception e) {
            this.request.remove();
        }

        public void beforeRequest(Request<?> request) {
            this.request.set(request);
        }
    }

    private static class RegionClient {
        private String region;
        private AmazonEC2 amazonEC2;

        public RegionClient(String region, AmazonEC2 amazonEC2) {
            this.region = region;
            this.amazonEC2 = amazonEC2;
        }

        public String getRegion() {
            return this.region;
        }

        public AmazonEC2 getAmazonEC2() {
            return this.amazonEC2;
        }
    }
}

